package jp.agentec.abook.abv.ui.viewer.activity;

import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.FrameLayout;
import android.widget.ImageButton;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVContentViewActivity;
import jp.agentec.abook.abv.ui.common.appinfo.options.Options;
import jp.agentec.abook.abv.ui.common.view.ABVPopupListWindow;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

// TODO: later 遠隔連動関連はContentView,HTMLWebViewと共通しているので要集約
public class NoPdfViewActivity extends ABVContentViewActivity {

	private static final String TAG = "NoPdfViewActivity";
	private ImageButton exitBtn;
	private ImageButton btnLinkOriginalBack;
	private ImageButton historyListBtn;
	private ImageButton mBtnRemoteStart;
	private ImageButton promoteBtn;
	private ImageButton pauseBtn;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		requestWindowFeature(Window.FEATURE_NO_TITLE);   //タイトルバー非表示
		
		setContentView(R.layout.content_common_toolbar);

		exitBtn = (ImageButton) findViewById(R.id.btn_exit);
		exitBtn.setOnClickListener(new View.OnClickListener() {
			@Override
            public void onClick(View v) {
				Logger.d(TAG, "[exit] click!!");
				finishActivity();
			}
		});

		btnLinkOriginalBack = (ImageButton) findViewById(R.id.btn_link_original_back);
		btnLinkOriginalBack.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Logger.d(TAG, "[btn_link_original_back] click!!");
				goToBack();
			}
		});

		historyListBtn = (ImageButton) findViewById(R.id.btn_history_list);
		historyListBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				showHistoryList(v);
			}
		});
		historyListBtn.setVisibility(View.INVISIBLE);

		subMenuBtn = (ImageButton) findViewById(R.id.btn_sub_menu);

		subMenuBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mShowedPopupWindow = new ABVPopupListWindow(NoPdfViewActivity.this);
				if (isNormalSize()) {
					mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_normal));
				} else {
					mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_large));
				}

				ArrayList<String> menuNameList = new ArrayList<>();

				mShowedPopupWindow.setRepresentNames(menuNameList);
				mShowedPopupWindow.setOnItemClickListener(new OnItemClickListener() {
					@Override
					public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
						mShowedPopupWindow.dismiss();
					}
				});

				mShowedPopupWindow.showAsDropDown(v);
			}
		});

		subMenuBtn.setVisibility(View.GONE);

		mBtnRemoteStart = (ImageButton) findViewById(R.id.btn_remote_start);
        mBtnRemoteStart.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				meetingManager.setPaused(false);
				configureRemote();
			}
		});
        
		exitMeetingBtn = (ImageButton) findViewById(R.id.btn_exitMeeting);
		exitMeetingBtn.setOnClickListener(new View.OnClickListener() {
			@Override
            public void onClick(View v) {
				Logger.v(TAG, "exit onClick");
				showMeetingExitDialog();
			}
		});

		promoteBtn = (ImageButton) findViewById(R.id.btn_promote);
		promoteBtn.setOnClickListener(new View.OnClickListener() {
			@Override
            public void onClick(View v) {
				Logger.v(TAG, "promote onClick");
				sendPromoteRequest();
			}
		});

		pauseBtn = (ImageButton) findViewById(R.id.btn_remote_pause);
		pauseBtn.setOnClickListener(new View.OnClickListener() {
			@Override
            public void onClick(View v) {
				Logger.v(TAG, "remoteOnOff onClick");
				meetingManager.setPaused(true);
				configureRemote();
			}
		});

		if(isLinkedContent) {
			ContentDto contentDto = AbstractDao.getDao(ContentDao.class).getContent(contentId);
			if (ContentJSON.KEY_IMAGE_TYPE.equals(contentDto.contentType) || ContentJSON.KEY_MOVIE_TYPE.equals(contentDto.contentType)
					|| ContentJSON.KEY_PANO_IMAGE_TYPE.equals(contentDto.contentType) || ContentJSON.KEY_PANO_MOVIE_TYPE.equals(contentDto.contentType)
					|| ContentJSON.KEY_OBJECTVR_TYPE.equals(contentDto.contentType) || ContentJSON.KEY_MUSIC_TYPE.equals(contentDto.contentType)
					|| ContentJSON.KEY_NONE_TYPE.equals(contentDto.contentType)
					|| ContentJSON.KEY_OTHER_TYPE.equals(contentDto.contentType)) {

				exitBtn.setBackgroundResource(R.drawable.btn_first_back);
				btnLinkOriginalBack.setVisibility(View.VISIBLE);
				historyListBtn.setVisibility(View.GONE);
				subMenuBtn.setVisibility(View.GONE);
				mBtnRemoteStart.setVisibility(View.GONE);
				exitMeetingBtn.setVisibility(View.GONE);
				promoteBtn.setVisibility(View.GONE);
				pauseBtn.setVisibility(View.GONE);
			}
		} else {
			configureRemote();
		}
	}
	
	@Override
	public void configureRemote() {
		if (meetingManager.isSubscribed()) {
			exitBtn.setVisibility(View.INVISIBLE);
			historyListBtn.setVisibility(View.INVISIBLE);
			if (meetingManager.isPaused()) {
				subMenuBtn.setVisibility(View.GONE);
				mBtnRemoteStart.setVisibility(View.VISIBLE);
				pauseBtn.setVisibility(View.GONE);
				exitMeetingBtn.setVisibility(View.GONE);
				promoteBtn.setVisibility(View.GONE);
			}
			else {
				subMenuBtn.setVisibility(View.GONE);
				mBtnRemoteStart.setVisibility(View.GONE);
				pauseBtn.setVisibility(View.VISIBLE);
				exitMeetingBtn.setVisibility(View.VISIBLE);
				promoteBtn.setVisibility(View.VISIBLE);
			}
		}
		else {
			exitBtn.setVisibility(View.VISIBLE);
			historyListBtn.setVisibility(View.VISIBLE);
			subMenuBtn.setVisibility(View.GONE);
			mBtnRemoteStart.setVisibility(View.GONE);
			pauseBtn.setVisibility(View.GONE);
			switchMeetingExitButton();
			promoteBtn.setVisibility(View.GONE);
		}
		historyListBtn.setVisibility(View.INVISIBLE);
	}
	
	@Override
	protected void finishActivity() {
		Logger.d(TAG, "finishActivity");
		finish();
		if (isLinkedContent) {
			ActivityHandlingHelper.getInstance().finishAllLinkContentViewActivity();
		} else {
			ActivityHandlingHelper.getInstance().finishAllContentViewActivity();

		}
	}
	
	protected View getToolbar() {
		return findViewById(R.id.toolbar);
	}
	
	protected void addViewToMainFrame(View view) {
		 FrameLayout layout = (FrameLayout) findViewById(R.id.main_frame);
	     layout.addView(view);
	}

}
