package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;

import jp.agentec.abook.abv.bl.dto.OperationTaskDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by leej on 2019/02/25.
 */


public class ActionOperationTaskPin extends ImageView {
    public String taskKey;
    private boolean isAnimated = false;
    private Context mContext;
    private Animation animation;

    public OperationTaskDto mOperationTaskDto;


    public ActionOperationTaskPin(final Context context, final OperationTaskDto dto) {
        super(context);
        mContext = context;
        mOperationTaskDto = dto;
        if (mOperationTaskDto.isFinished) {
            setImageResource(R.drawable.ic_pin_finish);
        } else {
            setImageResource(R.drawable.ic_pin_unfinish);
        }
        setBackgroundColor(Color.TRANSPARENT);
    }

    public void stopAnimation() {
        if (this.isAnimated) {
            this.clearAnimation();
            this.isAnimated = false;
        }
    }

    public void startBlinkAnimation() {
        if (animation == null) {
            animation = new AlphaAnimation(1, 0);
            animation.setDuration(1000);
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE);
            animation.setRepeatMode(Animation.REVERSE);
        }

        this.startAnimation(animation);
        this.isAnimated = true;
    }
}
