/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.LottieDrawable;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.content.GreedyContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.TransformKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.KeyPathElement;
import oz.lottie.model.animatable.AnimatableTransform;
import oz.lottie.model.content.ContentModel;
import oz.lottie.model.content.ShapeGroup;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public class ContentGroup
implements DrawingContent,
PathContent,
BaseKeyframeAnimation$AnimationListener,
KeyPathElement {
    private Paint offScreenPaint = new LPaint();
    private RectF offScreenRectF = new RectF();
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final boolean hidden;
    private final List contents;
    private final LottieDrawable lottieDrawable;
    private List pathContents;
    private TransformKeyframeAnimation transformAnimation;

    private static List contentsFromModels(LottieDrawable lottieDrawable, BaseLayer baseLayer, List list) {
        ArrayList<Content> arrayList = new ArrayList<Content>(list.size());
        int n = 0;
        while (n < list.size()) {
            Content content = ((ContentModel)list.get(n)).toContent(lottieDrawable, baseLayer);
            if (content != null) {
                arrayList.add(content);
            }
            ++n;
        }
        return arrayList;
    }

    static AnimatableTransform findTransform(List list) {
        int n = 0;
        while (n < list.size()) {
            ContentModel contentModel = (ContentModel)list.get(n);
            if (contentModel instanceof AnimatableTransform) {
                return (AnimatableTransform)contentModel;
            }
            ++n;
        }
        return null;
    }

    public ContentGroup(LottieDrawable lottieDrawable, BaseLayer baseLayer, ShapeGroup shapeGroup) {
        this(lottieDrawable, baseLayer, shapeGroup.getName(), shapeGroup.isHidden(), ContentGroup.contentsFromModels(lottieDrawable, baseLayer, shapeGroup.getItems()), ContentGroup.findTransform(shapeGroup.getItems()));
    }

    ContentGroup(LottieDrawable lottieDrawable, BaseLayer baseLayer, String string, boolean bl, List list, AnimatableTransform animatableTransform) {
        this.name = string;
        this.lottieDrawable = lottieDrawable;
        this.hidden = bl;
        this.contents = list;
        if (animatableTransform != null) {
            this.transformAnimation = animatableTransform.createAnimation();
            this.transformAnimation.addAnimationsToLayer(baseLayer);
            this.transformAnimation.addListener(this);
        }
        ArrayList<GreedyContent> arrayList = new ArrayList<GreedyContent>();
        int n = list.size() - 1;
        while (n >= 0) {
            Content content = (Content)list.get(n);
            if (content instanceof GreedyContent) {
                arrayList.add((GreedyContent)((Object)content));
            }
            --n;
        }
        n = arrayList.size() - 1;
        while (n >= 0) {
            ((GreedyContent)arrayList.get(n)).absorbContent(list.listIterator(list.size()));
            --n;
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContents(List list, List list2) {
        ArrayList<Content> arrayList = new ArrayList<Content>(list.size() + this.contents.size());
        arrayList.addAll(list);
        int n = this.contents.size() - 1;
        while (n >= 0) {
            Content content = (Content)this.contents.get(n);
            content.setContents(arrayList, this.contents.subList(0, n));
            arrayList.add(content);
            --n;
        }
    }

    List getPathList() {
        if (this.pathContents == null) {
            this.pathContents = new ArrayList();
            int n = 0;
            while (n < this.contents.size()) {
                Content content = (Content)this.contents.get(n);
                if (content instanceof PathContent) {
                    this.pathContents.add((PathContent)content);
                }
                ++n;
            }
        }
        return this.pathContents;
    }

    Matrix getTransformationMatrix() {
        if (this.transformAnimation != null) {
            return this.transformAnimation.getMatrix();
        }
        this.matrix.reset();
        return this.matrix;
    }

    @Override
    public Path getPath() {
        this.matrix.reset();
        if (this.transformAnimation != null) {
            this.matrix.set(this.transformAnimation.getMatrix());
        }
        this.path.reset();
        if (this.hidden) {
            return this.path;
        }
        int n = this.contents.size() - 1;
        while (n >= 0) {
            Content content = (Content)this.contents.get(n);
            if (content instanceof PathContent) {
                this.path.addPath(((PathContent)content).getPath(), this.matrix);
            }
            --n;
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        int n2;
        int n3;
        if (this.hidden) {
            return;
        }
        this.matrix.set(matrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
            n3 = this.transformAnimation.getOpacity() == null ? 100 : (Integer)this.transformAnimation.getOpacity().getValue();
            n2 = (int)((float)n3 / 100.0f * (float)n / 255.0f * 255.0f);
        } else {
            n2 = n;
        }
        int n4 = n3 = this.lottieDrawable.isApplyingOpacityToLayersEnabled() && this.hasTwoOrMoreDrawableContent() && n2 != 255 ? 1 : 0;
        if (n3 != 0) {
            this.offScreenRectF.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.getBounds(this.offScreenRectF, this.matrix, true);
            this.offScreenPaint.setAlpha(n2);
            Utils.saveLayerCompat(canvas, this.offScreenRectF, this.offScreenPaint);
        }
        int n5 = n3 != 0 ? 255 : n2;
        int n6 = this.contents.size() - 1;
        while (n6 >= 0) {
            Object e2 = this.contents.get(n6);
            if (e2 instanceof DrawingContent) {
                ((DrawingContent)e2).draw(canvas, this.matrix, n5);
            }
            --n6;
        }
        if (n3 != 0) {
            canvas.restore();
        }
    }

    private boolean hasTwoOrMoreDrawableContent() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.contents.size()) {
            if (this.contents.get(n2) instanceof DrawingContent && ++n >= 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        this.matrix.set(matrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
        }
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        int n = this.contents.size() - 1;
        while (n >= 0) {
            Content content = (Content)this.contents.get(n);
            if (content instanceof DrawingContent) {
                ((DrawingContent)content).getBounds(this.rect, this.matrix, bl);
                rectF.union(this.rect);
            }
            --n;
        }
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        if (!keyPath.matches(this.getName(), n)) {
            return;
        }
        if (!"__container".equals(this.getName())) {
            keyPath2 = keyPath2.addKey(this.getName());
            if (keyPath.fullyResolvesTo(this.getName(), n)) {
                list.add(keyPath2.resolve(this));
            }
        }
        if (keyPath.propagateToChildren(this.getName(), n)) {
            int n2 = n + keyPath.incrementDepthBy(this.getName(), n);
            int n3 = 0;
            while (n3 < this.contents.size()) {
                Content content = (Content)this.contents.get(n3);
                if (content instanceof KeyPathElement) {
                    KeyPathElement keyPathElement = (KeyPathElement)((Object)content);
                    keyPathElement.resolveKeyPath(keyPath, n2, list, keyPath2);
                }
                ++n3;
            }
        }
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (this.transformAnimation != null) {
            this.transformAnimation.applyValueCallback(object, lottieValueCallback);
        }
    }
}

