/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.util.zip.CRC32;
import java.util.zip.Deflater;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.DeflaterSink;
import oz.lottie.custom.okio.Okio;
import oz.lottie.custom.okio.Segment;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Timeout;
import oz.lottie.custom.okio.Util;

public final class GzipSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private final DeflaterSink deflaterSink;
    private boolean closed;
    private final CRC32 crc = new CRC32();

    public GzipSink(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        this.deflater = new Deflater(-1, true);
        this.sink = Okio.buffer(sink);
        this.deflaterSink = new DeflaterSink(this.sink, this.deflater);
        this.writeHeader();
    }

    @Override
    public void write(Buffer buffer, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (l == 0L) {
            return;
        }
        this.updateCrc(buffer, l);
        this.deflaterSink.write(buffer, l);
    }

    @Override
    public void flush() {
        this.deflaterSink.flush();
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public void close() {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.deflaterSink.finishDeflate();
                    this.writeFooter();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    private void writeHeader() {
        Buffer buffer = this.sink.buffer();
        buffer.writeShort(8075);
        buffer.writeByte(8);
        buffer.writeByte(0);
        buffer.writeInt(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
    }

    private void writeFooter() {
        this.sink.writeIntLe((int)this.crc.getValue());
        this.sink.writeIntLe(this.deflater.getTotalIn());
    }

    private void updateCrc(Buffer buffer, long l) {
        Segment segment = buffer.head;
        while (l > 0L) {
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            this.crc.update(segment.data, segment.pos, n);
            l -= (long)n;
            segment = segment.next;
        }
    }
}

