/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import java.util.ArrayList;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableGradientColorValue;
import oz.lottie.model.animatable.AnimatableIntegerValue;
import oz.lottie.model.animatable.AnimatablePointValue;
import oz.lottie.model.content.GradientStroke;
import oz.lottie.model.content.GradientType;
import oz.lottie.model.content.ShapeStroke$LineCapType;
import oz.lottie.model.content.ShapeStroke$LineJoinType;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;

class GradientStrokeParser {
    private static JsonReader$Options NAMES = JsonReader$Options.of("nm", "g", "o", "t", "s", "e", "w", "lc", "lj", "ml", "hd", "d");
    private static final JsonReader$Options GRADIENT_NAMES = JsonReader$Options.of("p", "k");
    private static final JsonReader$Options DASH_PATTERN_NAMES = JsonReader$Options.of("n", "v");

    private GradientStrokeParser() {
    }

    static GradientStroke parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        String string = null;
        AnimatableGradientColorValue animatableGradientColorValue = null;
        AnimatableIntegerValue animatableIntegerValue = null;
        GradientType gradientType = null;
        AnimatablePointValue animatablePointValue = null;
        AnimatablePointValue animatablePointValue2 = null;
        AnimatableFloatValue animatableFloatValue = null;
        ShapeStroke$LineCapType shapeStroke$LineCapType = null;
        ShapeStroke$LineJoinType shapeStroke$LineJoinType = null;
        AnimatableFloatValue animatableFloatValue2 = null;
        float f2 = 0.0f;
        boolean bl = false;
        ArrayList<AnimatableFloatValue> arrayList = new ArrayList<AnimatableFloatValue>();
        block22: while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    string = jsonReader.nextString();
                    break;
                }
                case 1: {
                    int n = -1;
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        switch (jsonReader.selectName(GRADIENT_NAMES)) {
                            case 0: {
                                n = jsonReader.nextInt();
                                break;
                            }
                            case 1: {
                                animatableGradientColorValue = AnimatableValueParser.parseGradientColor(jsonReader, lottieComposition, n);
                                break;
                            }
                            default: {
                                jsonReader.skipName();
                                jsonReader.skipValue();
                            }
                        }
                    }
                    jsonReader.endObject();
                    break;
                }
                case 2: {
                    animatableIntegerValue = AnimatableValueParser.parseInteger(jsonReader, lottieComposition);
                    break;
                }
                case 3: {
                    gradientType = jsonReader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    break;
                }
                case 4: {
                    animatablePointValue = AnimatableValueParser.parsePoint(jsonReader, lottieComposition);
                    break;
                }
                case 5: {
                    animatablePointValue2 = AnimatableValueParser.parsePoint(jsonReader, lottieComposition);
                    break;
                }
                case 6: {
                    animatableFloatValue = AnimatableValueParser.parseFloat(jsonReader, lottieComposition);
                    break;
                }
                case 7: {
                    shapeStroke$LineCapType = ShapeStroke$LineCapType.values()[jsonReader.nextInt() - 1];
                    break;
                }
                case 8: {
                    shapeStroke$LineJoinType = ShapeStroke$LineJoinType.values()[jsonReader.nextInt() - 1];
                    break;
                }
                case 9: {
                    f2 = (float)jsonReader.nextDouble();
                    break;
                }
                case 10: {
                    bl = jsonReader.nextBoolean();
                    break;
                }
                case 11: {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        String string2 = null;
                        AnimatableFloatValue animatableFloatValue3 = null;
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            switch (jsonReader.selectName(DASH_PATTERN_NAMES)) {
                                case 0: {
                                    string2 = jsonReader.nextString();
                                    break;
                                }
                                case 1: {
                                    animatableFloatValue3 = AnimatableValueParser.parseFloat(jsonReader, lottieComposition);
                                    break;
                                }
                                default: {
                                    jsonReader.skipName();
                                    jsonReader.skipValue();
                                }
                            }
                        }
                        jsonReader.endObject();
                        if (string2.equals("o")) {
                            animatableFloatValue2 = animatableFloatValue3;
                            continue;
                        }
                        if (!string2.equals("d") && !string2.equals("g")) continue;
                        lottieComposition.setHasDashPattern(true);
                        arrayList.add(animatableFloatValue3);
                    }
                    jsonReader.endArray();
                    if (arrayList.size() != 1) continue block22;
                    arrayList.add((AnimatableFloatValue)arrayList.get(0));
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        return new GradientStroke(string, gradientType, animatableGradientColorValue, animatableIntegerValue, animatablePointValue, animatablePointValue2, animatableFloatValue, shapeStroke$LineCapType, shapeStroke$LineJoinType, f2, arrayList, animatableFloatValue2, bl);
    }
}

