/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.WeekFields;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.DateRangeIndex;

public class WeekPagerAdapter$Weekly
implements DateRangeIndex {
    private final CalendarDay min;
    private final int count;
    private final DayOfWeek firstDayOfWeek;

    public WeekPagerAdapter$Weekly(CalendarDay calendarDay, CalendarDay calendarDay2, DayOfWeek dayOfWeek) {
        this.firstDayOfWeek = dayOfWeek;
        this.min = this.getFirstDayOfWeek(calendarDay);
        this.count = this.indexOf(calendarDay2) + 1;
    }

    public int getCount() {
        return this.count;
    }

    public int indexOf(CalendarDay calendarDay) {
        WeekFields weekFields = WeekFields.of((DayOfWeek)this.firstDayOfWeek, (int)1);
        LocalDate localDate = calendarDay.getDate().with(weekFields.dayOfWeek(), 1L);
        return (int)ChronoUnit.WEEKS.between((Temporal)this.min.getDate(), (Temporal)localDate);
    }

    public CalendarDay getItem(int n) {
        return CalendarDay.from(this.min.getDate().plusWeeks((long)n));
    }

    private CalendarDay getFirstDayOfWeek(CalendarDay calendarDay) {
        LocalDate localDate = calendarDay.getDate().with(WeekFields.of((DayOfWeek)this.firstDayOfWeek, (int)1).dayOfWeek(), 1L);
        return CalendarDay.from(localDate);
    }
}

