/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.ProductParsedResult;
import oz.util.barcode.client.result.ResultParser;
import oz.util.barcode.oned.UPCEReader;

public final class ProductResultParser
extends ResultParser {
    @Override
    public ProductParsedResult parse(Result result) {
        BarcodeFormat barcodeFormat = result.getBarcodeFormat();
        if (barcodeFormat != BarcodeFormat.UPC_A && barcodeFormat != BarcodeFormat.UPC_E && barcodeFormat != BarcodeFormat.EAN_8 && barcodeFormat != BarcodeFormat.EAN_13) {
            return null;
        }
        String string = ProductResultParser.getMassagedText(result);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 < '0' || c2 > '9') {
                return null;
            }
            ++n2;
        }
        String string2 = barcodeFormat == BarcodeFormat.UPC_E ? UPCEReader.convertUPCEtoUPCA(string) : string;
        return new ProductParsedResult(string, string2);
    }
}

