/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned.rss.expanded.decoders;

import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.rss.expanded.decoders.AbstractExpandedDecoder;

abstract class AI01decoder
extends AbstractExpandedDecoder {
    protected static final int GTIN_SIZE = 40;

    AI01decoder(BitArray bitArray) {
        super(bitArray);
    }

    protected final void encodeCompressedGtin(StringBuilder stringBuilder, int n) {
        stringBuilder.append("(01)");
        int n2 = stringBuilder.length();
        stringBuilder.append('9');
        this.encodeCompressedGtinWithoutAI(stringBuilder, n, n2);
    }

    protected final void encodeCompressedGtinWithoutAI(StringBuilder stringBuilder, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            int n4 = this.getGeneralDecoder().extractNumericValueFromBitArray(n + 10 * n3, 10);
            if (n4 / 100 == 0) {
                stringBuilder.append('0');
            }
            if (n4 / 10 == 0) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n4);
            ++n3;
        }
        AI01decoder.appendCheckDigit(stringBuilder, n2);
    }

    private static void appendCheckDigit(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 13) {
            int n4 = stringBuilder.charAt(n3 + n) - 48;
            n2 += (n3 & 1) == 0 ? 3 * n4 : n4;
            ++n3;
        }
        if ((n2 = 10 - n2 % 10) == 10) {
            n2 = 0;
        }
        stringBuilder.append(n2);
    }
}

