/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import oz.viewer.ui.df.DFUtils;

public class DFRoundRectFrameLayout
extends FrameLayout {
    static final float DEFAULT_RAD_DP = 6.0f;
    private static final int DEFAULT_RECT_COLOR = 0x33FFFFFF;
    private static final int DEFAULT_RECT_BORDER_COLOR = -855638017;
    private static final float DEFAULT_RECT_BORDER_WIDTH = 1.0f;
    private ImageView mImageView;
    private float mRadDP;
    private int mRectColor;
    private int mRectBorderColor;
    private float mRectBorderWidth;

    public DFRoundRectFrameLayout(Context context, int n) {
        super(context);
        this.init();
        if (n != 0) {
            this.mImageView.setImageResource(n);
        }
    }

    public void setImageResource(Drawable drawable2) {
        if (drawable2 != null) {
            this.mImageView.setBackground(drawable2);
        }
    }

    public DFRoundRectFrameLayout(Context context, Drawable drawable2) {
        super(context);
        this.init();
        this.setImageResource(drawable2);
    }

    private void init() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setScaleType(this.getScaleType());
        this.addImageView(this.mImageView);
        this.setRad(6.0f);
        this.setRectColor(0x33FFFFFF);
        this.setBorderColor(-855638017);
        this.setBorderWidth(1.0f);
        this.initExtra();
        this.applyRect();
    }

    public ImageView getImageView() {
        return this.mImageView;
    }

    protected ImageView.ScaleType getScaleType() {
        return ImageView.ScaleType.CENTER;
    }

    protected void addImageView(ImageView imageView) {
        this.addView((View)imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
    }

    protected void initExtra() {
    }

    public void setRad(float f2) {
        this.mRadDP = f2;
    }

    public float getRad() {
        return this.mRadDP;
    }

    public void setRectColor(int n) {
        this.mRectColor = n;
    }

    public void setBorderColor(int n) {
        this.mRectBorderColor = n;
    }

    public void setBorderWidth(float f2) {
        this.mRectBorderWidth = f2;
    }

    public void applyRect() {
        this.getBackgroundView().setBackground(this.createDrawable());
    }

    protected View getBackgroundView() {
        return this;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mImageView.setEnabled(bl);
    }

    protected Drawable createDrawable() {
        return DFRoundRectFrameLayout.getGDNormalFrame(this.getContext(), this.mRectColor, this.mRectBorderColor, this.mRectBorderWidth, this.mRadDP);
    }

    protected static GradientDrawable getGDNormalFrame(Context context, int n, int n2, float f2, float f3) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(n);
        gradientDrawable.setStroke(DFUtils.toDP(context, f2), n2);
        gradientDrawable.setCornerRadius((float)DFUtils.toDP(context, f3));
        return gradientDrawable;
    }
}

