/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.graphics.PointF;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import oz.viewer.ui.edit.ACanvasCommentView;

public class ACanvasCommentView$OZCommentPath {
    public ArrayList commentPoint = new ArrayList();
    private int m_pathColor;
    private int m_commentMode;
    private boolean isFromJson;
    private float m_pathStroke;
    public float m_scaledStrokeSize;
    final /* synthetic */ ACanvasCommentView this$0;

    public ACanvasCommentView$OZCommentPath(ACanvasCommentView aCanvasCommentView, float f2, float f3) {
        this.this$0 = aCanvasCommentView;
        this.commentPoint.add(new PointF(f2, f3));
        this.isFromJson = false;
    }

    public ACanvasCommentView$OZCommentPath(ACanvasCommentView aCanvasCommentView, JSONObject jSONObject) {
        this.this$0 = aCanvasCommentView;
        this.isFromJson = true;
        this.parse(jSONObject);
    }

    public void add(float f2, float f3) {
        this.commentPoint.add(new PointF(f2, f3));
    }

    public int getSize() {
        return this.commentPoint.size();
    }

    public PointF getAt(int n) {
        return (PointF)this.commentPoint.get(n);
    }

    public void setColor(int n) {
        this.m_pathColor = n;
    }

    public int getColor() {
        return this.m_pathColor;
    }

    public void setStroke(float f2) {
        this.m_pathStroke = f2;
    }

    public float getStroke() {
        return this.m_pathStroke;
    }

    public void setMode(int n) {
        this.m_commentMode = n;
    }

    public int getMode() {
        return this.m_commentMode;
    }

    public boolean isFromJson() {
        return this.isFromJson;
    }

    private void parse(JSONObject jSONObject) {
        block8: {
            try {
                if (jSONObject != null) {
                    if (jSONObject.getString("type").equalsIgnoreCase("comment")) {
                        int n = jSONObject.getInt("penmode");
                        float f2 = (float)jSONObject.getDouble("penwidth");
                        int n2 = jSONObject.getInt("pencolor");
                        this.setMode(n);
                        this.m_scaledStrokeSize = f2;
                        this.setStroke(f2);
                        this.setColor((n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >> 16);
                        if (jSONObject.get("path") instanceof JSONArray) {
                            JSONArray jSONArray = (JSONArray)jSONObject.get("path");
                            int n3 = jSONArray.length();
                            for (int j = 0; j < n3; ++j) {
                                String string = jSONArray.get(j).toString();
                                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                                String[] stringArray = new String[stringTokenizer.countTokens()];
                                int n4 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string2 = stringTokenizer.nextToken();
                                    string2 = string2.toLowerCase();
                                    string2 = string2.trim();
                                    stringArray[n4++] = string2;
                                }
                                if (stringArray.length != 2) {
                                    throw new Exception();
                                }
                                float f3 = Float.parseFloat(stringArray[0]);
                                float f4 = Float.parseFloat(stringArray[1]);
                                this.commentPoint.add(new PointF(f3, f4));
                            }
                        }
                        break block8;
                    }
                    throw new Exception("not CommentType");
                }
                throw new Exception("not CommentType");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public JSONObject serialize() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"comment");
            jSONObject.put("penmode", this.getMode());
            jSONObject.put("penwidth", (double)this.getStroke());
            jSONObject.put("pencolor", (this.getColor() & 0xFF) << 16 | this.getColor() & 0xFF00 | (this.getColor() & 0xFF0000) >> 16);
            JSONArray jSONArray = new JSONArray();
            for (int j = 0; j < this.commentPoint.size(); ++j) {
                PointF pointF = (PointF)this.commentPoint.get(j);
                jSONArray.put((Object)String.format(Locale.ENGLISH, "%f,%f", Float.valueOf(pointF.x), Float.valueOf(pointF.y)));
            }
            jSONObject.put("path", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public boolean isIntersect(PointF pointF, PointF pointF2) {
        PointF pointF3;
        if (this.commentPoint.size() == 1) {
            float f2 = 2.0f;
            pointF3 = null;
            PointF pointF4 = new PointF(((PointF)this.commentPoint.get((int)0)).x, ((PointF)this.commentPoint.get((int)0)).y);
            pointF4.x += f2;
            pointF4.y += f2;
            if (this.isIntersectBetweenTwoLines(pointF, pointF2, (PointF)this.commentPoint.get(0), pointF4, pointF3)) {
                return true;
            }
            pointF4 = new PointF(((PointF)this.commentPoint.get((int)0)).x, ((PointF)this.commentPoint.get((int)0)).y);
            pointF4.x -= f2;
            pointF4.y -= f2;
            if (this.isIntersectBetweenTwoLines(pointF, pointF2, (PointF)this.commentPoint.get(0), pointF4, pointF3)) {
                return true;
            }
        }
        if (this.commentPoint.size() > 1) {
            for (int j = 0; j < this.commentPoint.size() - 1; ++j) {
                pointF3 = null;
                if (!this.isIntersectBetweenTwoLines(pointF, pointF2, (PointF)this.commentPoint.get(j), (PointF)this.commentPoint.get(j + 1), pointF3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIntersectBetweenTwoLines(PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4, PointF pointF5) {
        double d2 = (pointF4.y - pointF3.y) * (pointF2.x - pointF.x) - (pointF4.x - pointF3.x) * (pointF2.y - pointF.y);
        if (d2 == 0.0) {
            return false;
        }
        double d3 = (pointF4.x - pointF3.x) * (pointF.y - pointF3.y) - (pointF4.y - pointF3.y) * (pointF.x - pointF3.x);
        double d4 = (pointF2.x - pointF.x) * (pointF.y - pointF3.y) - (pointF2.y - pointF.y) * (pointF.x - pointF3.x);
        double d5 = d3 / d2;
        double d6 = d4 / d2;
        if (d5 < 0.0 || d5 > 1.0 || d6 < 0.0 || d6 > 1.0) {
            return false;
        }
        return d3 != 0.0 || d4 != 0.0;
    }
}

