package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

/**
 * 利用規約に同意するで取得するテキストを格納するJSON
 */
public class TermsOfUseJson extends AcmsCommonJSON {
    public String message;
    public TermsOfUseJson(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException, JSONException {
        super.parse(json);
        message = getString(json, "message", null);
    }
}
