package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;

public class UserUpdateJSON extends AcmsCommonJSON {

    public ShopMemberDto shopMemberDto;

    public UserUpdateJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject UserInfoJson = json.getJSONObject(ABookCommConstants.KEY.BODY);
        if (UserInfoJson == null) { return; }

        shopMemberDto = new ShopMemberDto();
        ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        JSONArray groupIdJsonArray = (JSONArray) UserInfoJson.get(ABookCommConstants.KEY.GROUP_IDS);
        for (int i = 0; i < groupIdJsonArray.length(); i++) {
            groupIdList.add(groupIdJsonArray.getInt(i));
        }
        shopMemberDto.groupIdList = groupIdList;
    }
}

