package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ACMSのAPIに渡す共通的なパラメータを格納します。ACMSのAPIのパラメータ用クラスを作成するときはこのクラスを継承してください。<br>
 * ただし、このクラスはログイン状態の確認用として使われる {@link ArchiveRequestParameters#sid} を持っているため、ログイン用のパラメータ {@link MobileLoginParameters} は、このクラスを継承する必要はありません。
 * @author Lee-mk
 * @version 1.0.0
 */
public class ArchiveRequestParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private String updatedDate;

	/**
	 * {@link ArchiveRequestParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
	 * @since 1.0.0
	 */
	public ArchiveRequestParameters(String sid, String cmd, String updatedDate) {
		this.sid = sid;
		this.cmd = cmd;
		this.updatedDate = updatedDate;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	public String getUpdatedDate() {
		return updatedDate;
	}

}
