package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * @author Lee-mk
 * @version 1.0.0
 */
public class InviteUsersParameters extends HttpParameterObject {
	/**
	 * セッションID
	 * @since 1.0.0
	 */
	private String sid;
	private String cmd;
	private Integer newRoomId;
	private String newRoomName;
	private String loginIdList;


	/**
	 * {@link InviteUsersParameters} のインスタンスを初期化します。
	 * @param sid
	 * @param cmd
	 * @param roomId
	 * @param newRoomName
	 * @param loginIdList
	 * @since 1.0.0
	 */
	public InviteUsersParameters(String sid, String cmd, Integer newRoomId, String newRoomName, String loginIdList) {
		this.sid = sid;
		this.cmd = cmd;
		this.newRoomId = newRoomId;
		this.newRoomName = newRoomName;
		this.loginIdList = loginIdList;
	}

	/**
	 * セッションIDを返します。
	 * @return ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public String getSid() {
		return sid;
	}

	/**
	 * コマンドを返します。
	 * @return コマンド。
	 * @since 1.0.0
	 */
	public String getCmd() {
		return cmd;
	}

	/**
	 * roomIdを返します。
	 * @return roomId。
	 * @since 1.0.0
	 */
	public Integer getNewRoomId() {
		return newRoomId;
	}

	/**
	 * newRoomNameを返します。
	 * @return newRoomName。
	 * @since 1.0.0
	 */
	public String getNewRoomName() {
		return newRoomName;
	}

	/**
	 * loginIdListを返します。
	 * @return loginIdList。
	 * @since 1.0.0
	 */
	public String getLoginIdList() {
		return loginIdList;
	}
}
