package jp.agentec.abook.abv.bl.data.dao;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.CollaborationDto;
import jp.agentec.adf.util.CollectionUtil;
import jp.agentec.adf.util.StringUtil;

public class ArchiveDao extends AbstractCommunicationDao {

	/**
	 * {@link ArchiveDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ArchiveDao() {
	}

	@Override
	protected ArchiveDto convert(Cursor cursor) {
		ArchiveDto dto = new ArchiveDto();

		int column = cursor.getColumnIndex("archive_id");
		if (column != -1) {
			dto.archiveId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("archive_name");
		if (column != -1) {
			dto.archiveName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("archive_date");
		if (column != -1) {
			dto.archiveDate = cursor.getString(column);
		}
		column = cursor.getColumnIndex("archive_type");
		if (column != -1) {
			dto.archiveType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("room_id");
		if (column != -1) {
			dto.roomId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("room_name");
		if (column != -1) {
			dto.roomName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("save_user_id");
		if (column != -1) {
			dto.saveUserId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("attend_user_ids");
		if (column != -1) {
			dto.attendUserIds = cursor.getString(column);
		}
		column = cursor.getColumnIndex("collaboration_detail_id");
		if (column != -1) {
			dto.collaborationDetailId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("file_path");
		if (column != -1) {
			dto.filePath = cursor.getString(column);
		}
		return dto;
	}

	public ArchiveDto getArchive(int archiveId) {
		ArchiveDto list = rawQueryGetDto("select * from t_archive where archive_id = ?", new String[]{""+ archiveId}, ArchiveDto.class);
		return list;
	}

	public List<ArchiveDto> getAllArchive() {
		List<ArchiveDto> list = rawQueryGetDtoList("select * from t_archive ", null, ArchiveDto.class);
		return list;
	}

	public List<Integer> getExistArchiveIds() {
		List<Integer> list = rawQueryGetIntegerList("select archive_id from t_archive ", null);
		return list;
	}

	public List<ArchiveDto> getArchiveListByName(String[] keywords) {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT archive_id");
		sql.append("        ,archive_name");
		sql.append("        ,archive_date");
		sql.append("        ,archive_type");
		sql.append("        ,room_id");
		sql.append("        ,save_user_id");
		sql.append("        ,attend_user_ids");
		sql.append(" FROM t_archive ");
		ArrayList<String> whereSqlList = new ArrayList<String>();
		for (String keyword : keywords) {
			if(StringUtil.isNullOrEmpty(keyword)){
				continue;
			}
			String whereSql = "archive_name LIKE '%"+keyword+"%'";
			whereSqlList.add(whereSql);
		}
		if (CollectionUtil.isNotEmpty(whereSqlList)) {
			sql.append("WHERE " + StringUtil.join(" AND ", whereSqlList));
		}
		List<ArchiveDto> list = rawQueryGetDtoList(sql.toString(), null, ArchiveDto.class);
		return list;
	}

	public void insertArchive(ArchiveDto dto) {
		insert("insert or ignore into t_archive (archive_id, archive_name, archive_date, archive_type, room_id, save_user_id, attend_user_ids, collaboration_detail_id, file_path) values (?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public void insertArchiveList(List<ArchiveDto> archiveDtoList) {
		try {
			beginTransaction();
			for (ArchiveDto archiveDto : archiveDtoList) {
				insertArchive(archiveDto);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("insertArchive failed.", e);
			throw new RuntimeException(e);
		}
	}

	public void deleteArchiveList(List<ArchiveDto> archiveDtoList) {
		try {
			beginTransaction();
			for (ArchiveDto archiveDto : archiveDtoList) {
				deleteArchive(archiveDto);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteArchive failed.", e);
			throw new RuntimeException(e);
		}
	}

	public boolean updateArchive(ArchiveDto dto) {
		long count = update("update t_archive set  archive_name=?, archive_type=?, archive_date=?, collaboration_detail_id=? where archive_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void updateArchiveInfoList(List<ArchiveDto> archiveDtoList) {
		try {
			beginTransaction();
			for (ArchiveDto archiveDto : archiveDtoList) {
				updateArchive(archiveDto);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteArchive failed.", e);
			throw new RuntimeException(e);
		}
	}

	public boolean updateArchiveDetailInfo(ArchiveDto dto) {
		long count = update("update t_archive set room_name=? where archive_id=?", new String[]{"" + dto.roomName, "" + dto.archiveId});
		return count > 0;
	}

	public void deleteArchive(ArchiveDto archiveDto) {
		delete("t_archive", "archive_id=?", archiveDto.getKeyValues());
	}


	public void deleteArchiveAllData() {
		try {
			beginTransaction();
			delete("t_archive", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteArchive failed.", e);
			throw new RuntimeException(e);
		}
	}

}
