package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.TaskDto;

/**
 * Created by leej on 2018/08/31.
 */

public class TaskDao extends AbstractDao {

    private static final String TAG = "TaskDao";

    /*package*/ TaskDao() {
    }

    @Override
    protected TaskDto convert(Cursor cursor) {
        TaskDto dto = new TaskDto();

        int column = cursor.getColumnIndex("task_key");
        if (column != -1) {
            dto.taskKey = cursor.getString(column);
        }
        column = cursor.getColumnIndex("task_id");
        if (column != -1) {
            dto.taskId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("operation_id");
        if (column != -1) {
            dto.operationId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("task_code");
        if (column != -1) {
            dto.taskCode = cursor.getString(column);
        }
        column = cursor.getColumnIndex("task_status");
        if (column != -1) {
            dto.taskStatus = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("task_hotspot_info");
        if (column != -1) {
            dto.taskHotSpotInfo = cursor.getString(column);
        }
        column = cursor.getColumnIndex("del_flg");
        if (column != -1) {
            dto.delFlg = toBool(cursor.getInt(column));
        }
        column = cursor.getColumnIndex("task_has_Authority");
        if (column != -1) {
            dto.taskHasAuthority = toBool(cursor.getInt(column));
        }
        column = cursor.getColumnIndex("task_name");
        if (column != -1) {
            dto.taskName = cursor.getString(column);
        }
        column = cursor.getColumnIndex("phase_no");
        if (column != -1) {
            dto.phaseNo = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("phase_status");
        if (column != -1) {
            dto.phaseStatus = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("process_status");
        if (column != -1) {
            dto.processStatus = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("process_key");
        if (column != -1) {
            dto.processKey = cursor.getString(column);
        }

        return dto;
    }

    public List<TaskDto> selectTaskByOperationId(Long operationId) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? and del_flg = 0 ", new String[]{"" + operationId}, TaskDto.class);
    }

    public List<TaskDto> selectTaskByOperationId(Long operationId, boolean deleteFlg) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? and del_flg = ? ", new String[]{"" + operationId, "" + (deleteFlg ? 1 : 0)}, TaskDto.class);
    }

    public List<TaskDto> selectTaskGroupByProcessKeyByOperationId(Long operationId) {
        return rawQueryGetDtoList("select *, min(phase_no) as min_phase_no  from t_task where operation_id = ? and del_flg = 0 group by process_key order by rowid asc", new String[]{"" + operationId}, TaskDto.class);
    }


    public List<TaskDto> selectTaskByOperationIdOrderByPhaseNo(Long operationId) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? and del_flg = 0 order by processKey asc, phaseNo asc", new String[]{"" + operationId}, TaskDto.class);
    }

    public List<TaskDto> selectAllTaskByOperationId(Long operationId) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? ", new String[]{"" + operationId}, TaskDto.class);
    }

    public TaskDto getTaskByTaskKey(String taskKey) {
        return rawQueryGetDto("select * from t_task where task_key=?", new String[]{"" + taskKey}, TaskDto.class);
    }

    public List<TaskDto> getTaskByProcessKey(String processKey) {
        return rawQueryGetDtoList("select * from t_task where process_key = ?", new String[]{processKey}, TaskDto.class);
    }

    public TaskDto getTaskByProcessKey(String processKey, Integer phaseNo) {
        return rawQueryGetDto("select * from t_task where process_key = ? and phase_no = ?", new String[]{"" + processKey, "" + phaseNo}, TaskDto.class);
    }

    public void insert(TaskDto dto) {
        insert("insert into t_task "
                        + "(task_key, "
                        + "task_id, "
                        + "operation_id, "
                        + "task_code, "
                        + "task_status, "
                        + "task_hotspot_info, "
                        + "task_name, "
                        + "phase_no, "
                        + "phase_status, "
                        + "process_key, "
                        + "process_status) "
                        + "values "
                        + "(?,?,?,?,?,?,?,?,?,?,?)",
                dto.getInsertValues());
    }

    public boolean update(TaskDto dto) {
        long count = update("update t_task "
                        + "set "
                        + "task_id=?, "
                        + "operation_id=?, "
                        + "task_code=?, "
                        + "task_status=?, "
                        + "task_hotspot_info=?, "
                        + "del_flg=?, "
                        + "task_name=?, "
                        + "phase_no=?, "
                        + "phase_status=?, "
                        + "process_status=?, "
                        + "process_key=? "
                        + "where task_key=?",
                dto.getUpdateValues());
        return count > 0;
    }

    public boolean updateStatus(String processKey, Integer phaseNo, Integer processStatus, Integer phaseStatus) {
        long count = update("update t_task "
                        + "set "
                        + "process_status=?, "
                        + "phase_status=? "
                        + "where process_key=? "
                        + "and phase_no=?",
                new String[]{"" + processStatus, "" + phaseStatus,  processKey, "" + phaseNo});
        return count > 0;
    }

    /**
     * 作業削除（連続作業でない場合）
     * @param taskKey
     */
    public void deleteTaskData(String taskKey) {
        String[] keyValues = new String[]{""+ taskKey};
        delete("t_task", "task_key=?", keyValues);
        delete("t_task_report", "task_key=?", keyValues);
        delete("t_task_report_items", "task_key=?", keyValues);
        delete("t_task_report_send", "task_key=?", keyValues);
    }
    /**
     * 作業削除(連続作業用)
     * @param taskKey
     */
    public void deleteTaskData(String taskKey, String processKey) {
        String[] keyValues = new String[]{""+ taskKey};
        delete("t_task", "task_key=?", keyValues);
        delete("t_task_report", "task_key=?", keyValues);
        delete("t_task_report_items", "task_key=?", keyValues);
        delete("t_task_report_send", "task_key=?", keyValues);
        delete("t_task_report_approval", "process_key=?", new String[]{processKey});
    }
    /**
     * 作業削除
     * @param dto
     */
    public void delete(TaskDto dto) {
        delete("t_task", "task_key=?", dto.getKeyValues());
        delete("t_task_report", "task_key=?", dto.getKeyValues());
        delete("t_task_report_items", "task_key=?", dto.getKeyValues());
        delete("t_task_report_send", "task_key=?", dto.getKeyValues());
        if (dto.processKey != null) { //連続作業の承認情報
            delete("t_task_report_approval", "process_key=?", new String[]{dto.processKey});
        }
    }
}