package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.adf.util.StringUtil;


/**
 * AbookComm専用のグループマスターテーブルです。
 * @author Lee mk
 * @version 1.1.1
 */
public class MChatGroup extends SQLiteTableScript {

	public MChatGroup() {
		super();
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since DatabaseVersions.Ver1_0_0
		sql.append(" CREATE TABLE m_chat_group ( ");
		sql.append("      group_id INTEGER NOT NULL ");
		sql.append("      , parent_group_id INTEGER NOT NULL ");
		sql.append("      , group_name VARCHAR(64) NOT NULL ");
		sql.append("      , favorite_register_date VARCHAR2(64) ");
		sql.append("      , PRIMARY KEY (group_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		sql.append(" CREATE INDEX idx_chat_group_1 ON m_chat_group ( ");
		sql.append("        parent_group_id ");
		sql.append(" )  ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
