package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

public class TCollaboration extends SQLiteTableScript {

    public TCollaboration() {
    };

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" create table t_collaboration ( ");
        sql.append("        collaboration_id INTEGER NOT NULL ");
        sql.append("      , chat_message_id INTEGER NOT NULL ");
        sql.append("      , PRIMARY KEY (collaboration_id)");
        sql.append(" ) ");

        ddl.add(sql.toString());

        return ddl;
    }

    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_3_000) {
            ddl.addAll(getCreateScript(newVersion));
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
        return null;
    }
}
