package jp.agentec.abook.abv.bl.dto;

import jp.agentec.adf.core.CloneableObject;

/**
 * Dtoクラスはこのクラスを継承します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public abstract class AbstractDto extends CloneableObject implements Comparable<AbstractDto> {
	/**
	 * このインスタンスが持っているデータの中で、キーとなる値を返します。
	 * @return キー値の配列を返します。
	 * @since 1.0.0
	 */
	public abstract String[] getKeyValues();
	
	/**
	 * 指定したdtoのキー値とこのインスタンスのキー値が一致するか確認します。
	 * @param dto テストするインスタンスです。
	 * @return　キー値が一致すればtrueを返します。
	 * @since 1.0.0
	 */
	public boolean equals(AbstractDto dto) {
		boolean result = true;
		
		if (dto != null) {
			String[] key1 = getKeyValues();
			String[] key2 = dto.getKeyValues();
			
			if (key1 != null && key2 != null && key1.length == key2.length) {
				for (int i = 0; i < key1.length; i++) {
					if (!key1[i].equals(key2[i])) {
						result = false;
						break;
					}
				}
			} else {
				result = false;
			}
		} else {
			result = false;
		}
		
		return result;
	}
	
	@Override
	public boolean equals(Object o) {
		boolean result;
		
		if (o instanceof AbstractDto) {
			result = equals((AbstractDto)o);
		} else {
			result = super.equals(o);
		}
		
		return result;
	}
	
	@Override
	public int compareTo(AbstractDto dto) {
		int result = 1;

		String[] key1 = getKeyValues();
		String[] key2 = dto.getKeyValues();

        if (key1 == null && key2 == null) {
            return 0;
        }

        if (key1 == null) {
            return -1;
        }
        if (key2 == null) {
            return 1;
        }

        if (key1.length > key2.length) {
            result = 1;
        } else if (key1.length < key2.length) {
            result = -1;
        } else if (key1.length == key2.length) {
            result = 0;
        } else {
            for (int i = 0; i < key1.length; i++) {
                result = key1[i].compareTo(key2[i]);

                if (result != 0) {
                    //	キーが同じであれば、次のキーを比較する。
                    break;
                }
            }
        }

		return result;
	}

	public abstract Object[] getInsertValues();

	public Object[] getUpdateValues() {
		return null;
	}
}
