package jp.agentec.adf.util;

import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.IOException;

import jp.agentec.adf.util.FileUtil;

import org.junit.Test;

public class FileUtilTest {

	@Test
	public void testCreateDirectory() {
		String path = "c:\\Users\\macrojin\\Documents\\1\\1\\1111.txt";
		try {
			FileUtil.createNewFile(path);
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testGetParentPath() {
		String path = "c:\\Users\\macrojin\\Documents\\1\\1\\1111.txt";
		try {
			System.out.println(FileUtil.getParentPath(path));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testGetFilenameWithoutExt() {
		String path1 = "c:\\Users\\macrojin\\Documents\\1\\1\\1111.txt";
		String path2 = "1111.txt";
		
		System.out.println("1:" + FileUtil.getFileName(path1));
		System.out.println("2:" + FileUtil.getFilenameWithoutExt(path1));
		
		System.out.println("3:" + FileUtil.getFileName(path2));
		System.out.println("4:" + FileUtil.getFilenameWithoutExt(path2));
		
		assertTrue(true);
	}
	
	@Test
	public void testGetWritableFileName() {
		String path = "c:\\Users\\macrojin\\Documents\\1\\dl3.zip";
		
		try {
			System.out.println(FileUtil.getWritableFileName(path));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testGetWritableDirectoryName() {
		String path = "c:\\Users\\macrojin\\Documents\\1\\3";
		
		try {
			System.out.println(FileUtil.getWritableDirectoryName(path, true));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testCopyMove() {
		String path1 = "c:\\Users\\macrojin\\Documents\\1\\1.zip";
		String path2 = "c:\\Users\\macrojin\\Documents\\1\\2\\2.zip";
		
		boolean result = FileUtil.move(path1, path2, true);
		System.out.println(result);
		
		String path3 = "c:\\Users\\macrojin\\Documents\\1\\4";
		String path4 = "c:\\Users\\macrojin\\Documents\\1\\3\\test";
		
		result = FileUtil.move(path3, path4, true);
		System.out.println(result);
	}
	
	@Test
	public void testGetFileSize() {
		System.out.println(FileUtil.getFileSize(null));
	}
	
	@Test
	public void testGetChildDirectories() {
		String path1 = "c:\\Users\\macrojin\\Documents\\1\\";
		File[] c = FileUtil.getChildDirectories(new File(path1));
		if (c != null) {
			for (File file : c) {
				System.out.println(file.getPath());
			}
		}
	}
	
	@Test
	public void testDelete() {
		String path1 = "c:\\Users\\macrojin\\Documents\\1\\2\\";
		boolean result = FileUtil.delete(path1);
		assertTrue(result);
	}
	
	@Test
	public void getHexDump() throws IOException {
		String path = "d:/var/a.jpg";
		int length = 100;
		System.out.println(FileUtil.getHexDump(path, length));
	}
	
}
