package jp.agentec.abook.abv.ui.common.util;

import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;

import jp.agentec.abook.abv.bl.common.log.Logger;

public class PatternStringUtil {

	// メッセージをパターン化してResourceのIndexを返す
	public static int patternToInt(Context context, int key, int pattern) {
		String entryName = context.getResources().getResourceEntryName(key);
		try {
			Logger.d("tetetet " + context.getResources().getString(context.getResources().getIdentifier(String.format(entryName + "_%d", pattern), "string", context.getPackageName())));
			if (pattern > 0) {
				return context.getResources().getIdentifier(String.format(entryName + "_%d", pattern), "string", context.getPackageName());
			} else {
				return context.getResources().getIdentifier(entryName, "string", context.getPackageName());
			}
		} catch (Exception e) {
			return context.getResources().getIdentifier(entryName, "string", context.getPackageName());
		}
	}

	// メッセージをパターン化してResourceのValueを返す
	public static String patternToString(Context context, int key, int pattern) {
		String entrayName = "";
		try {
			entrayName = context.getResources().getResourceEntryName(key);
			if (pattern > 0) {
				return context.getResources().getString(context.getResources().getIdentifier(String.format(entrayName + "_%d", pattern), "string", context.getPackageName()));
			} else {
				return context.getResources().getString(context.getResources().getIdentifier(entrayName, "string", context.getPackageName()));
			}
		} catch (Exception e) {
			Logger.e("getboolean", "notfound : " + e.getMessage());
			return context.getResources().getString(context.getResources().getIdentifier(entrayName, "string", context.getPackageName()));
		}
	}
}
