package jp.agentec.abook.abv.ui.home.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.app.PictureInPictureParams;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import androidx.annotation.RequiresApi;
import android.util.Log;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.Toast;

import org.json.adf.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.CreatedRoomJSON;
import jp.agentec.abook.abv.bl.acms.client.json.MessageInfoListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.UserInviteResultJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.MeetingDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.CommunicationLogic;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.data.ChatData;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVAuthenticatedActivity;
import jp.agentec.abook.abv.ui.common.activity.ABVContentViewActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.helper.VideoEncoder;
import jp.agentec.abook.abv.ui.home.view.ChatWebView;
import jp.agentec.abook.abv.ui.home.view.ChatWebViewDelegate;
import jp.agentec.abook.abv.ui.home.view.FullscreenableChromeClient;
import jp.agentec.abook.abv.ui.viewer.activity.CommunicationWebViewActivity;
import jp.agentec.adf.util.StringUtil;

import static jp.agentec.abook.abv.bl.common.constant.ABookCommConstants.DEFAULT_CHECKSUM;

/**
 * Created by AIS-NB-048 on 2019/07/31.
 */

public class ChatWebViewActivity extends CommunicationWebViewActivity implements ChatWebViewDelegate {
    private ChatWebView mChatWebView;
    private ProgressDialog chatProgressDialog;
    private String chatWebviewUrl;

    private final String TAG = "ChatWebViewActivity";

    private ValueCallback<Uri[]> mUploadMessage;

    private ChatData chatData;
    private String selectedUserIdList;
    private String mSkey;
    private boolean startPIP = false; // PIPモードを開始していたらtrue;
    private boolean isActivityStop = false; // onResume で　tru onStop で false
    private String collaborationType = null;
    private String meetingId = null;

    private String encodedFilePath;

    private MeetingManager meetingManager = MeetingManager.getInstance();
    private AlertDialog myAlertDialog;

    private BroadcastReceiver receiver;

    private final CommunicationLogic communicationLogic = AbstractLogic.getLogic(CommunicationLogic.class);

    private boolean needHostAlert = false;
    private boolean mIsInPictureInPictureMode = false;
    public Long getRoomID() {
        return chatData.roomId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
        initializeWebView();
        FrameLayout layout = new FrameLayout(this);
        FrameLayout.LayoutParams param = new FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT
        );
        setContentView(mChatWebView, param);
    }

    private void initializeWebView() {
        initiateDatas(getIntent()); // intentのデータから、chatDataを作成
        setupChatWebView();
        registJSReactor();
        addDownloadListener();
        observeNetworkChange();
        loadWebViewResource();
        setupDefaultChatWebViewURL();
    }

    private void initiateDatas(Intent intent) {
        communicationLogic.setPackagePath(getFilesDir().getAbsolutePath() + "/");
        chatData = ChatData.getInstance();
        chatData.setSid(intent.getStringExtra(ABookCommConstants.KEY.SID));
        chatData.setRoomID(intent.getLongExtra(ABookCommConstants.KEY.ROOM_ID, 0));
        chatData.roomName = intent.getStringExtra(ABookCommConstants.KEY.ROOM_NAME);
        //ルーム名をDBから取得
        Integer integerRoomId = Integer.parseInt(chatData.roomId.toString());
        ChatRoomDto dto = communicationLogic.getChatRoom(integerRoomId);
        if (dto != null) {
            chatData.roomName = dto.chatRoomName;
        }
        chatData.roomType = intent.getStringExtra(ABookCommConstants.KEY.ROOM_TYPE);
        chatData.loginId = intent.getStringExtra(ABookCommConstants.KEY.LOGIN_ID);
        chatData.shopName = intent.getStringExtra(ABookCommConstants.KEY.SHOP_NAME);
        chatData.setStrCollaborationType(intent.getStringExtra(ABookCommConstants.KEY.COLLABORATION_TYPE));
        chatData.setIsOnline(false);
        chatData.setContext(ChatWebViewActivity.this);
        chatData.setIsMobile(!isNormalSize());

        // どのアクティビティから遷移してきたか保存
        baseActivityName = intent.getStringExtra(AppDefType.ChatPushMessageKey.baseActivityName);
    }

    private void setupChatWebView() {
        mChatWebView = new ChatWebView(ChatWebViewActivity.this);
        mChatWebView.configue(chatData);
        mChatWebView.delegate = this;
    }

    private void setupDefaultChatWebViewURL() {
        //ネットワークがない場合専用のページを表示。
        ShopMemberDto myInfo = communicationLogic.getMyShopMemberDto();
        if (myInfo != null) {
            chatData.shopMemberId = myInfo.shopMemberId;
        }
        chatWebviewUrl = ABookCommConstants.NETWORK_ERROR_PLACE_HOLDER;
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            registChatRoomPageLoader();
            Logger.d("DEVICE_NOT_CONNECTED_NETWORK:");
            return;
        }
        boolean isSIDValid = false;
        try {
            isSIDValid = AcmsClient.getInstance(chatData.shopName, ABVEnvironment.getInstance().networkAdapter).checkSid(chatData.sid);
        } catch (Exception e) {
            Logger.d("SID_CHECK_ERROR");
        }

        if (!isSIDValid) { return; }

        chatData.setIsOnline(true);
        chatWebviewUrl = ABookCommConstants.CHAT_PAGE_URL;
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    chatData.updateMyInfoFromServer();
                    chatData.updateAllGroupInfo();
                    chatData.updateFavoriteInfo();
                    chatData.shopMemberId = communicationLogic.getMyShopMemberDto().shopMemberId;
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                registChatRoomPageLoader();
                            } catch (Exception e) {
                                Logger.d("registChatRoomPageLoader Error");
                            }
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                    Logger.d("Update error");
                }
            }
        });
    }

    private void registChatRoomPageLoader() {
        // 最後のチャットのルーム名
        String lastRoomName = PreferenceUtil
                .getUserPref(
                        getApplicationContext(),
                        AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME,
                        ""
                );
        // 最後のチャットのルーム
        String lastRoomId = PreferenceUtil
                .getUserPref(
                        getApplicationContext(),
                        AppDefType.UserPrefKey.CHAT_LAST_ROOMID,
                        ""
                );

        String fixedParam = "&platform=android&isMobile=true&chatServerUrl="
                + ABVEnvironment.getInstance().websocketServerHttpUrl;
        //ページをロード
        if (chatData.roomId != 0 && chatData.roomName != null) {  // by push message
            try {
                mChatWebView.updateRoomList();
            } catch (Exception e) {
                e.printStackTrace();
            }
            Integer integerRoomId = Integer.parseInt(chatData.roomId.toString());
            if (StringUtil.isNullOrEmpty(chatData.roomType)) {
                ChatRoomDto dto = communicationLogic.getChatRoom(integerRoomId);
                if (dto != null) {
                    chatData.roomType = dto.type.toString();
                }
            }
            if (StringUtil.isNullOrEmpty(chatData.getStrCollaborationType())) {
                String parameterData = "sid=" + chatData.sid
                        + "&loginId=" + chatData.loginId
                        + "&shopName=" + chatData.shopName
                        + "&roomId=" + chatData.roomId
                        + "&roomName=" + chatData.roomName
                        + fixedParam;
                mChatWebView.postUrl(ABookCommConstants.CHAT_ROOM_PAGE_URL, parameterData.getBytes());
            } else {
                chatData.setCollaborationJoinFlg(ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.INVITE);
                try {
                    AcmsClient
                            .getInstance(ABVEnvironment.getInstance().networkAdapter)
                            .joinCollaboration(chatData.sid, chatData.roomId.intValue());
                } catch (NetworkDisconnectedException | AcmsException e) {
                    e.printStackTrace();
                }
                moveCollaborationScreen(Integer.parseInt(chatData.getStrCollaborationType()));
            }
        } else {  // Chat
            if (lastRoomName.length() > 0 && lastRoomId.length() > 0) {
                String parameterData = "sid=" + chatData.sid
                        + "&loginId=" + chatData.loginId
                        + "&shopName=" + chatData.shopName
                        + "&roomId=" + lastRoomId
                        + "&roomName=" + lastRoomName
                        + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            } else {
                String parameterData = "sid=" + chatData.sid
                        + "&loginId=" + chatData.loginId
                        + "&shopName=" + chatData.shopName
                        + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            }
        }
    }

    private void registJSReactor() {
        mChatWebView.setWebChromeClient(new FullscreenableChromeClient(this) {

            @Override
            @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
            public void onPermissionRequest(final PermissionRequest request) {
                request.grant(request.getResources());
            }

            @Override
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                boolean result = false;
                // 画像が選択された場合
                if (fileChooserParams.getAcceptTypes()[0].toLowerCase().contains(ABookKeys.IMAGE)) {
                    result = startCameraIntent(ABookCommConstants.ABOOK_CHECK_TASK_IMAGE, "Camera", ABookKeys.IMAGE, true);
                    // 動画が選択された場合
                } else if (fileChooserParams.getAcceptTypes()[0].toLowerCase().contains(ABookKeys.VIDEO)) {
                    result = startCameraIntent(ABookCommConstants.ABOOK_CHECK_TASK_VIDEO, "Video", ABookKeys.VIDEO, true);
                }
                if (result) {
                    if (mUploadMessage != null) {
                        mUploadMessage.onReceiveValue(null);
                    }
                    mUploadMessage = filePathCallback;
                }
                return result;
            }

            // WebView内のAlert Dialogを処理する
            // message.equals で、 fermi側のHTMLを解析して、処理を分けている。
            @Override
            public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
                mChatWebView.extendHeartBeatIfNeeded();

                if (myAlertDialog != null && myAlertDialog.isShowing()) {
                    result.confirm();
                    return true;
                }
                if (message.equals("server error Ocurred")) {
                    message = getString(R.string.msg_error_chat_server);
                } else if (message.equals("Disconnected from the server")) {
                    message = getString(R.string.msg_error_chat_disconnected);
                } else if (message.equals("connect_error")) {
                    message = getString(R.string.msg_error_chat_connect);
                } else if (message.equals("Room not found")) {
                    message = getString(R.string.msg_error_chat_room_not_found);
                } else if (message.equals("ServerError 500")) {
                    message = getString(R.string.msg_error_chat_500);
                } else if (message.equals("error chat join")) {
                    message = getString(R.string.msg_error_chat_join);
                } else if (message.equals("Message length error")) {
                    message = getString(R.string.msg_error_chat_text_length);
                    // #36130 start
                } else if (message.equals("Input RoomName")) {
                    message = getString(R.string.msg_error_chat_input_roomname);
                    // #36130 end
                    // #36142
                } else if (message.equals("Please enter room name less than 20 characters")) {
                    message = getString(R.string.msg_error_chat_room_name_too_long);
                } else if (message.equals("InvalidSpecialCharacterRoomName")) {
                    message = getString(R.string.msg_error_chat_name_has_invalid_character);
                } else if (message.equals("SC_FORBIDDEN")) {
                    message = getString(R.string.msg_error_chat_room_sc_forbidden);
                } else if (message.contains("Send owner complete")) {
                    mChatWebView.hideNameCardInCollaboaration();
                    result.confirm();
                    return true;
                } else if (message.contains("REJECT for owner user")) {
                    mChatWebView.hideNameCardInCollaboaration();
                    mChatWebView.hideHostRequestModal();
                    mChatWebView.hideNameCardInCollaboaration();
                    message = getString(R.string.msg_rejected_by_host);
                } else if (message.contains("Invalid Parameters")) {
                    message = getString(R.string.msg_invalid_parameters);
                } else if (message.contains("사용 가능한 카메라 기기를 찾을수 없습니다")) {
                    message = getString(R.string.not_found_camera);
                } else if (message.contains("Exception while creating MediaRecorder")) {
                    message = getString(R.string.error_fail_record);
                }

                final String tempMessage = message;

                ABookAlertDialog dialog = AlertDialogUtil
                        .createAlertDialog(ChatWebViewActivity.this, R.string.app_name);
                dialog.setMessage(message);
                dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        // サーバと接続された場合、チャット画面を閉じる

                        if (tempMessage.equals(getString(R.string.msg_error_chat_disconnected))
                                || tempMessage.equals(getString(R.string.msg_error_chat_room_sc_forbidden)))
                        {
                            mChatWebView.leaveRoom();
                            finish();
                        } else if (tempMessage.equals(getString(R.string.msg_error_chat_join))) {
                            finish();
                        } else if (tempMessage.equals(getString(R.string.msg_invalid_parameters))) {
                            if (chatData.roomId != null) {
                                joinRoom(chatData.roomId.toString(), chatData.roomName);
                            } else {
                                mChatWebView.loadUrl(ABookCommConstants.CHAT_PAGE_URL);
                            }
                        } else if (tempMessage.equals(getString(R.string.error_fail_record))) {
                            mChatWebView.recordFinished();
                        }
                    }
                });

                //myAlertDialog = dialog; TODO: ダイアログの表示タイミングの調整が必要。
                if (!isFinishing() && !message.equals("false")) {
                    dialog.show();
                }
                result.confirm();
                return true;
            }

            // WebView内のConfirm Dialogを処理する
            // message.equals で、 fermi側のHTMLを解析して、処理を分けている。
            @Override
            public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
                if (mIsInPictureInPictureMode) {
                    final ABookAlertDialog dialog = AlertDialogUtil
                            .createAlertDialog(activityHandlingHelper.getCurrentActivity(), R.string.app_name);
                    dialog.setMessage(R.string.msg_fail_collaboration_pip_change_host);
                    //PIP状態ではホスト変更できません。PIPを解除してください。
                    dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            result.cancel();

                        }
                    });
                    //PIPモード画面が「戻る」ではなく、小さく全画面モードにされる問題対応
                    mChatWebView.removePIPIndicator();
                    dialog.show();
                    return true;
                }

                if (message.equals("Do you want to leave this room?")) {
                    message = getString(R.string.msg_chat_confirm_exit);
                } else if (message.equals("Do you want to remove selected members from the list?")) {
                    message = getString(R.string.msg_chat_confirm_member);
                    // #36128
                } else if (message.equals("Do you want to delete this room?")) {
                    message = getString(R.string.msg_chat_confirm_delete);
                }  else if (message.equals("error_already_exist_same_user")) {
                    message = getString(R.string.msg_error_already_exist_same_room);
                } else if (message.equals("방장 권한을 전달 받으시겠습니까?")){
                    message = getString(R.string.msg_confirm_send_host_change);
                    if (chatData.getHostRequestFlg() == 1) {
                        mChatWebView.penOff();
                        mChatWebView.hideHostRequestModal();
                        mChatWebView.hideNameCardInCollaboaration();
                        if (meetingManager.isConnected() && meetingManager.isSubscribed()) {
                            sendPromoteRequest();
                        }
                        result.confirm();
                        return true;
                    }
                } else if (message.equals("캡쳐한 사진을 공유 하시겠습니까?")) {
                    message = getString(R.string.msg_confirm_share_image);
                } else if (message.contains("Create room anyway?")) {
                    message = getString(R.string.msg_destroy_exist_collaboration);
                }
                final ABookAlertDialog confirmAlert = AlertDialogUtil
                        .createAlertDialog(ChatWebViewActivity.this, R.string.app_name);
                confirmAlert.setMessage(message);
                if (message.equals(getString(R.string.msg_error_already_exist_same_room))) {
                    confirmAlert.setButton(
                            DialogInterface.BUTTON_POSITIVE,
                            getResources().getString(R.string.move),
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    result.confirm();
                                }
                            }
                    );
                } else if (message.equals(getString(R.string.msg_confirm_send_host_change))){
                    confirmAlert.setButton(
                            DialogInterface.BUTTON_POSITIVE,
                            getResources().getString(R.string.confirm),
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    mChatWebView.penOff();
                                    mChatWebView.hideHostRequestModal();
                                    mChatWebView.hideNameCardInCollaboaration();
                                    if (meetingManager.isConnected() && meetingManager.isSubscribed()) {
                                        sendPromoteRequest();
                                    }
                                    result.confirm();
                                }
                            }
                    );
                } else {
                    confirmAlert.setButton(
                            DialogInterface.BUTTON_POSITIVE,
                            getResources().getString(R.string.confirm),
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    result.confirm();
                                }
                            }
                    );
                }
                confirmAlert.setButton(
                        DialogInterface.BUTTON_NEGATIVE,
                        getResources().getString(R.string.cancel),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                result.cancel();
                            }
                        }
                );
                confirmAlert.setCancelable(false);
                showAlertDialog(confirmAlert);
                if (message.equals(getString(R.string.msg_confirm_send_host_change))
                        || message.contains(getString(R.string.host_confirm))
                        || message.equals(getString(R.string.msg_confirm_share_image)))
                {
                    Thread thread = new Thread(new Runnable() {
                        @Override
                        public void run() {
                            TimerTask task = new TimerTask(){
                                @Override
                                public void run() {
                                    result.cancel();
                                    confirmAlert.dismiss();
                                }
                            };

                            Timer timer = new Timer();
                            timer.schedule(task, 30000);
                        }
                    });
                    thread.start();
                }
                return true;
            }
        });
    }

    private void addDownloadListener() {
        mChatWebView.setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(
                    String url, String userAgent,
                    String contentDisposition, String mimetype,
                    long contentLength)
            {
                Uri uri = Uri.parse(url);
                DownloadManager.Request request = new DownloadManager.Request(uri);

                final String fileName = uri.getQueryParameter("fileName");

                //------------------------COOKIE!!------------------------
                String cookies = CookieManager.getInstance().getCookie(url);
                request.addRequestHeader("cookie", cookies);
                //------------------------COOKIE!!------------------------
                request.addRequestHeader("User-Agent", userAgent);
                request.setTitle(fileName);
                request.allowScanningByMediaScanner();
                request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED); //Notify client once download is completed!
                request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName);
                DownloadManager dm = (DownloadManager) getSystemService(DOWNLOAD_SERVICE);
                if (dm != null) {
                    dm.enqueue(request);
                }
                Toast.makeText(
                        getApplicationContext(),
                        getString(R.string.download_start), //To notify the Client that the file is being downloaded
                        Toast.LENGTH_LONG
                ).show();
            }
        });
    }

    private void observeNetworkChange() {
        // ブロードキャストレシーバーの追加
        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                ConnectivityManager connectivityManager = (ConnectivityManager) getApplicationContext()
                        .getSystemService(Context.CONNECTIVITY_SERVICE);

                if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(intent.getAction())) {
                    mChatWebView.hideLoadingIndicator();
                }

                if (intent.getAction().equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
                        chatData.setIsOnline(false);
                        mChatWebView.refreshForOffline();
                    } else {
                        chatData.setIsOnline(true);
                        mChatWebView.refreshForOnline();
                        if (
                                mChatWebView.getUrl() != null &&
                                        (mChatWebView.getUrl().equals(ABookCommConstants.CHAT_ROOM_PAGE_URL) ||
                                                mChatWebView.getUrl().equals(ABookCommConstants.CHAT_PAGE_URL) ||
                                                mChatWebView.getUrl().equals(ABookCommConstants.CONTACT_URL) ||
                                                mChatWebView.getUrl().equals(ABookCommConstants.ARCHIVE_URL) ||
                                                mChatWebView.getUrl().indexOf(ABookCommConstants.ARCHIVE_DETAIL_URL) != -1)
                        ) {
                            mChatWebView.windowReload();
                        }
                    }
                }
            }
        };
        // レシーバーオブジェクトの生成
        IntentFilter tempIntent = new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE);
        tempIntent.addAction(WifiManager.NETWORK_STATE_CHANGED_ACTION);
        tempIntent.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            registerReceiver(receiver, tempIntent, RECEIVER_EXPORTED);
        } else {
            registerReceiver(receiver, tempIntent);
        }
    }

    private void loadWebViewResource() {
        mChatWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onLoadResource(WebView view, String url) {

                if (url.contains("profileFileName")) {
                    Uri uri = Uri.parse(url);
                    String fileName = uri.getQueryParameter("profileFileName");
                    String filePath = getFilesDir().getAbsolutePath() + "/" + fileName;
                    Logger.d(TAG, filePath);

                    File file = new File(filePath);
                    NetworkTask networkTask = new NetworkTask(url, filePath);
                    networkTask.execute();
                } else if (url.contains("/file/getImage") && !url.contains(".mp4")) {
                    Uri uri = Uri.parse(url);
                    String fileName = uri.getQueryParameter("fileName");
                    String filePath = getFilesDir().getAbsolutePath() + "/" + fileName;
                    Logger.d(TAG, filePath);

                    File file = new File(filePath);
                    NetworkTask networkTask = new NetworkTask(url, filePath);
                    networkTask.execute();
                } else {
                    super.onLoadResource(view, url);
                }
            }

            @Override
            public void onReceivedError(WebView view, int errorCode,
                                        String description, String failingUrl) {

                if (errorCode == ERROR_HOST_LOOKUP) {
                    mChatWebView.removeView(view);
                    view.removeAllViews();
                    mChatWebView.reload();
                    mChatWebView.loadUrl(ABookCommConstants.NETWORK_ERROR_PLACE_HOLDER);
                }
                Logger.d("WEB_VIEW_ERROR", "error code:" + errorCode + " - " + description);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Logger.d("url", "url : " + url);

                Uri uri = Uri.parse(url);
                String fileName = new File(Objects.requireNonNull(uri.getPath())).getName();

                // イメージをダウンロードする(png, jpg, jpeg, mp4, mov)
                if (url.toLowerCase().endsWith(".png")
                        || url.toLowerCase().endsWith(".jpg")
                        || url.toLowerCase().endsWith(".jpeg")
                        || url.toLowerCase().endsWith(".mov")
                        || url.toLowerCase().endsWith(".mp4"))
                {
                    view.loadUrl("javascript:Common.showLoadingIndicator()");
                    DownloadManager mdDownloadManager = (DownloadManager) getSystemService(Context.DOWNLOAD_SERVICE);
                    DownloadManager.Request request = new DownloadManager.Request(Uri.parse(url));
                    File destinationFile = new File(Environment.getExternalStorageDirectory(), fileName);
                    request.setDescription("Downloading ...");
                    request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
                    request.setDestinationUri(Uri.fromFile(destinationFile));
                    assert mdDownloadManager != null;
                    mdDownloadManager.enqueue(request);
                } else {  // その他のファイルはurlのみ確認
                    Logger.d("download ", "download URL :" + url);
                }
                return false;
            }
        });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
        chatData.setIsMobile(!isNormalSize());
    }

    public void showCommunicationChatMenuDialog() {
        showCommunicationMenuDialog();
    }

    // 保存するファイルをjpgに固定する
    public String getFileName(String url) {
        return System.currentTimeMillis() + ".jpg";
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Uri dataUri = null;
        if (data != null && resultCode == RESULT_OK) {
            String dataString = data.getDataString();
            if (dataString != null) {
                dataUri = Uri.parse(dataString);
            }
        }

        if (requestCode == ABookCommConstants.ABOOK_CHECK_TASK_IMAGE) {
            activityResultReceivedImage(dataUri);
        } else if (requestCode == ABookCommConstants.ABOOK_CHECK_TASK_VIDEO) {
            activityResultReceivedMovie(dataUri);
        }

        mUploadMessage = null;
    }

    private void activityResultReceivedImage(Uri dataUri) {
        if (mUploadMessage == null) {
            return;
        }
        // 画像
        try {
            if (dataUri == null) {
                dataUri = imageUri;
            }
            Uri responseUri = attachmentImageProcessing(dataUri);
            if (responseUri != null) {
                mUploadMessage.onReceiveValue(new Uri[]{responseUri});
            } else {
                mUploadMessage.onReceiveValue(null);
            }
        } catch (Exception e) {
            Logger.e(TAG, e);
            mUploadMessage.onReceiveValue(null);
            ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
        }
    }

    private void activityResultReceivedMovie(Uri dataUri) {
        if (mUploadMessage == null) {
            return;
        }
        if (dataUri != null) {
            mChatWebView.showLoadingIndicator();

            Cursor cursor = getContentResolver().query(dataUri, null, null, null, null);
            cursor.moveToNext();

            final String filePath = cursor.getString(cursor.getColumnIndex("_data"));
            cursor.close();

            Runnable r = new Runnable() {
                @Override
                public void run() {
                    try {
                        //CallBack
                        Runnable callBack = new Runnable() {
                            @Override
                            public void run() {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        mChatWebView.finishedVideoEncoding(encodedFilePath);
                                    }
                                });
                            }
                        };
                        Context c = getApplicationContext();
                        File file = new File(filePath);
                        encodedFilePath = new VideoEncoder().changeResolution(file, callBack);
                    } catch (Throwable throwable) {
                        mChatWebView.failedVideoEncoding();
                    }
                }
            };
            r.run();
        }
        mUploadMessage.onReceiveValue(null);
    }

    /**
     * 作業一覧へ遷移
     *
     */
    public void backToHome() {
        mChatWebView.leaveRoom();
        exitAndDeleteMeetingRoom();
        finish();

        // 戻るの作業一覧か、関連資料のどちらかのActivityのみ
        // デフォルトでは、作業一覧に戻る
        Intent intent = new Intent();
        if (OperationRelatedContentActivity.class.getName().equals(baseActivityName)) {
            intent.setClass(ChatWebViewActivity.this, OperationRelatedContentActivity.class);
        } else {
            intent.setClass(ChatWebViewActivity.this, OperationListActivity.class);
        }
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_CLEAR_TOP);
        intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, ChatWebViewActivity.class.getName());
        startActivity(intent, NaviConsts.Left);
    }

    /**
     * 以前の関連資料（共通）の画面を終了する
     */
    public void finishBeforeContentListActivity() {
        OperationRelatedContentActivity beforeActiryty = activityHandlingHelper.getActivity(OperationRelatedContentActivity.class);
        if (beforeActiryty != null) {
            beforeActiryty.finish();
        }
    }

    /**
     * PIPモードから元にもどる
     */
    public void finishPIPMode() {
        if (startPIP) {
            //既存WebViewのページリセットする。
            mChatWebView.loadBlank();
            Intent intent = new Intent();
            intent.setClass(this, ChatWebViewActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            intent.putExtra(ABookCommConstants.KEY.SID, chatData.sid);
            intent.putExtra(ABookCommConstants.KEY.ROOM_ID, chatData.roomId);
            intent.putExtra(ABookCommConstants.KEY.ROOM_NAME, chatData.roomName);
            intent.putExtra(ABookCommConstants.KEY.ROOM_TYPE, chatData.roomType);
            intent.putExtra(ABookCommConstants.KEY.LOGIN_ID, chatData.loginId);
            intent.putExtra(ABookCommConstants.KEY.SHOP_NAME, chatData.shopName);
            intent.putExtra(AppDefType.ChatPushMessageKey.baseActivityName, baseActivityName);
            activityHandlingHelper.getCurrentActivity().startActivity(intent);
            collaborationType = Integer.toString(0);
            startPIP = false;
            finish();
        }
    }

    public void exitAndDeleteMeetingRoom() {
        if (meetingManager.isConnected() && meetingManager.isOwner()) {
            try {
                meetingManager.deleteMeeting();
            } catch (Exception e) {
                Logger.e(TAG, "showMeetingExitDialog deleteMeeting error", e);
            }
        }
        meetingManager.close();
        activityHandlingHelper.saveMeetingInfo(null, null, null, false);
    }

    public void startContentListActivity(boolean isOwner) {
        Activity targetActivity = activityHandlingHelper.getCurrentActivity();
        if (targetActivity instanceof ChatWebViewActivity) {
            Stack<ABVAuthenticatedActivity> stack = activityHandlingHelper.getCurrentActivityStack();
            if (stack.size() > 1){
                targetActivity = stack.get(stack.size()-2);
            }
        }
        Intent intent = new Intent();
        intent.setClass(targetActivity, OperationRelatedContentActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
        targetActivity.startActivity(intent);
    }
    public void connectMeetingServer() throws Exception {
        meetingManager = MeetingManager.getInstance();
        mSkey = meetingManager.getSessionKey(true);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    public void moveCollaborationScreen(Integer collaborationType) {
        if (collaborationType.equals(ABookCommConstants.FLAG.COLLABORATION_TYPE.DOCUMENT) && !isValidVersion()) {
            mChatWebView.showAlert("getLocalizedString('not_support_version')");
            return;
        }
        chatData.setJoinCollaborationType(collaborationType);
        mChatWebView.loadChatViewUrl(ABookCommConstants.COLLABORATION_PAGE_URL);
    }

    public boolean deleteFavoriteGroup(String groupId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .deleteFavoriteGroup(chatData.sid, Integer.parseInt(groupId));

        if (!result) {
            return false;
        }

        List<Integer> deleteFavoriteList = new ArrayList<Integer>();
        deleteFavoriteList.add(Integer.parseInt(groupId));
        communicationLogic.deleteavoriteGroup(deleteFavoriteList);
        return true;
    }

    @Override
    public void onPictureInPictureModeChanged (boolean isInPictureInPictureMode, Configuration newConfig) {
        mIsInPictureInPictureMode = isInPictureInPictureMode;
        if (isInPictureInPictureMode) {
            // true になったら、PIPのインディケーターを消す
            mChatWebView.removePIPIndicator();
            return;
        }

        if (isActivityStop) {
            mChatWebView.exitCollaboration();
        }
        mChatWebView.addPIPIndicator();
        if (!meetingManager.isConnected()) {
            mChatWebView.addPIPButton();
        }
    }

    // 共通資料画面表示
    public void showCommonContent() {
        Intent intent = new Intent();
        intent.setClass(ChatWebViewActivity.this, OperationRelatedContentActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Left);
    }

    private void showChatWebViewProgressPopup() {
        if (chatProgressDialog == null) {
            chatProgressDialog = new ProgressDialog(this);
            chatProgressDialog.setMessage(getResources().getString(R.string.progress));
            chatProgressDialog.setIndeterminate(true);
            chatProgressDialog.setCancelable(false);
            if (chatProgressDialog.getWindow() != null) {
                chatProgressDialog.getWindow().setFormat(PixelFormat.TRANSPARENT);
            }
        }

        if (chatProgressDialog != null && !chatProgressDialog.isShowing() && !isFinishing()) {
            chatProgressDialog.show();
        }
    }

    private void closeChatWebViewProgressPopup() {
        if (chatProgressDialog != null && chatProgressDialog.isShowing()) {
            try {
                chatProgressDialog.dismiss();
            } catch (Exception e) {
                Logger.e(TAG, "closeProgressPopup error. ", e);  // ignore
            }
        }
    }

    @Override
    public void chatWebViewNeedsShowProgressBar() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                showChatWebViewProgressPopup();
            }
        });
    }

    @Override
    public void chatWebViewNeedsDismissProgressBar() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                closeChatWebViewProgressPopup();
            }
        });
    }

    public class NetworkTask extends AsyncTask<Void, Void, Bitmap> {

        private String url;
        private String filePath;
        private ContentValues values;
        private Bitmap mBitmap;
        public NetworkTask(String url, String filePath) {

            this.url = url;
            this.filePath = filePath;
        }

        @Override
        protected Bitmap doInBackground(Void... params) {
            try {
                mBitmap =BitmapFactory.decodeStream((InputStream) new URL(url).getContent());
            } catch (IOException e) {
                e.printStackTrace();
            }
            return mBitmap;
        }

        @Override
        protected void onPostExecute(Bitmap resultBitmap) {
            super.onPostExecute(resultBitmap);
            try {
                if (resultBitmap == null) {
                    return;
                }
                File f = new File(filePath);

                f.createNewFile();

                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                resultBitmap.compress(Bitmap.CompressFormat.PNG, 0, bos);
                byte[] bitmapData = bos.toByteArray();

                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bitmapData);
                fos.flush();
                fos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onResume() {
        isActivityStop = false; // activity動いている
        super.onResume();
        if (mChatWebView.getUrl() != null && mChatWebView.getUrl().equals(ABookCommConstants.CHAT_ROOM_PAGE_URL)) {
            mChatWebView.socketCheck();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        isActivityStop = true; // activity 停止
    }

    @Override
    public void onDestroy(){
        exitAndDeleteMeetingRoom();
        super.onDestroy();
        if (receiver != null) {
            unregisterReceiver(receiver);
            receiver = null;
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean eventPrevent = false;
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            backToHome();
            eventPrevent = true;
        }
        return eventPrevent;
    }

    public boolean isValidVersion() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.O;
    }

    public void sendPromoteRequest() {
        ABVContentViewActivity contentViewActivity = ActivityHandlingHelper.getInstance().getContentViewActivity();
        JSONObject json = new JSONObject();
        json.put(MeetingManager.ID, meetingManager.getSkey());
        json.put(MeetingManager.LOGIN_ID, ABVDataCache.getInstance().getMemberInfo().loginId);
        meetingManager.sendWs(
                MeetingManager.CMD_PRESENTERREQUEST,
                contentViewActivity != null ? contentViewActivity.getContentId() : 0,
                null,
                null,
                json
        );
    }

    public void setSelectedUserIdList(String userList) {
        selectedUserIdList = userList;
    }

    public String getSelectedUserList() {
        String userList = communicationLogic.getUserList(selectedUserIdList);
        Log.d("getSelectedUserList " , userList );
        return userList;
    }

    public void updateMyInfo() throws NetworkDisconnectedException, AcmsException {
        chatData.updateMyInfoFromServer();
    }

    public void updateGroupUser() throws NetworkDisconnectedException, AcmsException {
        chatData.updateGroupInfoFromServer();
    }

    public void createChatRoom(
            String roomType,
            String userIdList,
            String encodedRoomName,
            String screenFlg,
            boolean isVoice)
            throws NetworkDisconnectedException, AcmsException
    {
        CreatedRoomJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .createRoom(chatData.sid, roomType, userIdList, encodedRoomName, chatData.loginId);
        if (ABookCommConstants.FLAG.SCREEN_FLG.MAKE_ROOM.equals(Integer.parseInt(screenFlg))) {
            final ChatRoomDto chatRoomDto = communicationLogic.getChatRoom(resultJson.chatRoomDto.chatRoomId);
            if (chatRoomDto != null) {
                mChatWebView.displayExistRoom(chatRoomDto.chatRoomId);
                return;
            }
        }
        communicationLogic.insertChatRoom(resultJson.chatRoomDto);
        communicationLogic.addUserInRoom(StringUtil.join(",", userIdList, chatData.shopMemberId.toString()), resultJson.chatRoomDto.chatRoomId);
        final Integer chatRoomId = resultJson.chatRoomDto.chatRoomId;
        final String chatRoomName = resultJson.chatRoomDto.chatRoomName;
        if (isVoice) {
            chatData.roomId = chatRoomId.longValue();
            chatData.roomName = chatRoomName;
            mChatWebView.startAudioCollaboration();
        } else {
            joinRoom(chatRoomId.toString(), chatRoomName);
        }
    }

    public void changeRoomName(String changeRoomName) throws NetworkDisconnectedException, AcmsException {
        chatData.changeRoomName(changeRoomName);
        chatData.joinRoom(chatData.roomId.toString(), changeRoomName);
        mChatWebView.loadChatViewUrl(ABookCommConstants.CHAT_ROOM_PAGE_URL);
    }

    public void joinRoom(String joinRoomId, String joinRoomName) {
        if (!StringUtil.isNullOrEmpty(this.collaborationType) && !StringUtil.isNullOrEmpty(this.meetingId)
                && this.collaborationType.equals(Integer.toString(ABookCommConstants.FLAG.COLLABORATION_TYPE.DOCUMENT))) {
            if (startPIP) {
                finishPIPMode();
            }
        }
        chatData.joinRoom(joinRoomId, joinRoomName);
        mChatWebView.loadChatViewUrl(ABookCommConstants.CHAT_ROOM_PAGE_URL);
    }

    public void roomDisplayOff(){
        communicationLogic.roomDisplayOff(chatData.roomId.intValue(), ABookCommConstants.FLAG.ROOM_VIEW_FLAG.INVISIBLE);
        mChatWebView.loadChatViewUrl(ABookCommConstants.CHAT_PAGE_URL);
    }

    public void inviteUsers(String userIds) throws NetworkDisconnectedException, AcmsException {
        final UserInviteResultJSON result = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .inviteUsers(chatData.sid, chatData.roomId.intValue(), chatData.roomName, userIds);
        if (result.roomId == null) {
            communicationLogic.addUserInRoom(userIds, chatData.roomId.intValue());
            mChatWebView.loadChatViewUrl(ABookCommConstants.CHAT_ROOM_PAGE_URL);
        } else {
            mChatWebView.displayExistRoom(result.roomId);
        }
    }

    public String getRoomType() {
        return chatData.roomType;
    }

    public String getBeforeRoomType() {
        return chatData.getBeforeRoomType();
    }

    public void clearBeforeRoomType() {
        chatData.setBeforeRoomType(null);
    }

    public void updateMessages(String roomId) throws NetworkDisconnectedException, AcmsException {
        SharedPreferences pref = getSharedPreferences(ABookCommConstants.TAG, MODE_PRIVATE);
        String lastUpdatedDate = pref.getString(ABookCommConstants.KEY.MESSAGE_UPDATED_DATE + roomId, DEFAULT_CHECKSUM);
        MessageInfoListJSON resultJson = AcmsClient
                .getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getMessages(chatData.sid, roomId, null, lastUpdatedDate);
        for (ChatMessageDto chatMessageDto : resultJson.chatMessageDtoArrayList) {
            chatMessageDto.chatRoomId = Integer.parseInt(roomId);
        }
        communicationLogic.insertMessageList(resultJson.chatMessageDtoArrayList);
        communicationLogic.insertShopMember(resultJson.shopMemberDtoArrayList);
        chatData.updateUnreadCount();
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(ABookCommConstants.KEY.MESSAGE_UPDATED_DATE + roomId, resultJson.updateDate);
        editor.commit();
    }

    public String searchMessages(String keyword, String userList) {
        return communicationLogic.searMessages(chatData.roomId.intValue(), keyword, userList);
    }

    public String getFavoriteUsersNotInRoom() {
        return communicationLogic.getFavoriteUsersNotInRoom(chatData.roomId.intValue());
    }

    public String getMyGroupUsersNotInRoom() {
        return communicationLogic.getMyGroupUsersNotInRoom(chatData.roomId.intValue());
    }

    public String getMyGroupShopMemberNotInRoomByName(String keywords) {
        return communicationLogic.getMyGroupUserNotInRoomByName(keywords, chatData.roomId.intValue());
    }

    public String getAllGroupShopMemberNotInRoomByName(String keywords) {
        return communicationLogic.getAllGroupShopMemberNotInRoomByName(keywords, chatData.roomId.intValue());
    }

    public void updateUserInfo(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        chatData.updateUserInfoFromServer(shopMemberId);
    }

    public String getGroupInfoForAddUser(String groupId) {
        return communicationLogic.getGroupSearchDataForAddUser(Integer.parseInt(groupId), chatData.roomId.intValue());
    }

    public boolean addFavoriteUser(String shopMemberId) throws AcmsException {
        if (!validateFavoriteLimit()) {
            return false;
        }

        try {
            return chatData.insertFavoriteUser(shopMemberId);
        } catch (NetworkDisconnectedException e) {
            mChatWebView.showAlert(getString(R.string.msg_eroor_network_offline));
        }

        return false;
    }

    public boolean removeFavoriteUser(String shopMemberId) throws AcmsException {
        try {
            return chatData.deleteFavoriteUser(shopMemberId);
        } catch (NetworkDisconnectedException e) {
            mChatWebView.showAlert(getString(R.string.msg_eroor_network_offline));
        }
        return false;
    }

    public boolean addFavoriteGroup(String groupId) throws  AcmsException {
        if (!validateFavoriteLimit()) {
            return false;
        }

        try {
            return chatData.insertFavoriteGroup(groupId);
        } catch (NetworkDisconnectedException e) {
            mChatWebView.showAlert(getString(R.string.msg_eroor_network_offline));
        }

        return false;
    }

    public boolean removeFavoriteGroup(String groupId) throws AcmsException {
        try {
            return deleteFavoriteGroup(groupId);
        } catch (NetworkDisconnectedException e) {
            mChatWebView.showAlert(getString(R.string.msg_eroor_network_offline));
        }
        return false;
    }

    public void updateFavorite() throws NetworkDisconnectedException, AcmsException {
        chatData.updateFavoriteInfo();
    }

    private boolean validateFavoriteLimit() {
        Integer favoriteCount = communicationLogic.getFavoriteCount();
        if (favoriteCount >= ABookCommConstants.SIZE.MAX_FAVORITE_COUNT) {
            mChatWebView.showAlert(getString(R.string.msg_error_favorites_100_over));
            return false;
        }
        return true;
    }

    public int createContentView() {
        finishBeforeContentListActivity();
        Integer meetingId = null;
        meetingManager.close();
        try {
            connectMeetingServer();
            List<MeetingDto> meetingList= meetingManager.getMeetingList(mSkey);
            for (MeetingDto meeting : meetingList) {
                if (meeting.title.equals("Collaboration__" + chatData.roomId) && meetingManager.isOwner()) {
                    meetingManager.deleteMeeting(meeting.meetingId, mSkey);
                }
            }
            meetingId = meetingManager.createMeeting(mSkey, "Collaboration_" + chatData.roomId, chatData.roomId.toString());
            meetingManager.join(meetingId, mSkey, chatData.roomId.toString(), true);
            meetingManager.setCollaboration(true);
        } catch (Exception e) {
            mChatWebView.showAlert(getString(R.string.msg_error_connection_error_meeting_room));
        }
        startPIPMode();
        startContentListActivity(true);
        return meetingId;
    }

    public void startContentView() {
        finishBeforeContentListActivity();
        meetingManager.close();
        try {
            connectMeetingServer();
            List<MeetingDto> meetingList = meetingManager.getMeetingList(mSkey);
            meetingManager.join(chatData.joinMeetingId, mSkey, chatData.roomId.toString(), false);
            meetingManager.setCollaboration(true);
        } catch (Exception e) {
            mChatWebView.showAlert(getString(R.string.msg_error_connection_error_meeting_room));
        }
        startPIPMode();
        startContentListActivity(false);
    }

    public void joinMeetingRoom(int newMeetingId) {
        if (meetingManager.isConnected()) {
            // すでに会議室に入室していたら、何もしない。
            return;
        }
        finishBeforeContentListActivity();
        startPIPMode();
        meetingManager.close();
        try {
            connectMeetingServer();
            List<MeetingDto> meetingList = meetingManager.getMeetingList(mSkey);
            meetingManager.join(chatData.joinMeetingId, mSkey, chatData.roomId.toString(), false);
            meetingManager.setCollaboration(true);
        } catch (Exception e) {
            mChatWebView.showAlert(getString(R.string.msg_error_connection_error_meeting_room));
        }
        startContentListActivity(false);
    }
    /**
     * PIPモードに変更
     */
    public void startPIPMode() {
        if (!mIsInPictureInPictureMode) {
            PictureInPictureParams.Builder mPipBuilder = new PictureInPictureParams.Builder();
            enterPictureInPictureMode(mPipBuilder.build());
            startPIP = true;
        }
    }

    public void exitPIPmode() {
        finishPIPMode();
    }

    public void exitMeetingRoom() {
        exitAndDeleteMeetingRoom();
        finishPIPMode();

        //関連資料画面閉じる
        ActivityHandlingHelper.getInstance().finishCollaborationOperationRelatedContentActivity();
        //コンテンツ閲覧画面閉じる
        ActivityHandlingHelper.getInstance().finishAllContentViewActivity();
        mIsInPictureInPictureMode = false;
    }

    public void finishPIP() {
        finishPIPMode();
    }

    public void setExitHostAlert() {
        needHostAlert = true;
    }

    public boolean getExitHostAlert() {
        if (needHostAlert) {
            needHostAlert = false;
            return true;
        }
        return needHostAlert;
    }

    public void joinCollaboration(String collaborationType, String meetingId) throws NetworkDisconnectedException, AcmsException {
        this.collaborationType = collaborationType;
        this.meetingId = meetingId;
        chatData.joinCollaboration(collaborationType, meetingId);
        moveCollaborationScreen(Integer.parseInt(collaborationType));
    }

    public void startCollaboration(String collaborationType) {
        chatData.setCollaborationJoinFlg(ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.CREATE);
        moveCollaborationScreen(Integer.parseInt(collaborationType));
    }

    public void saveVisitRoomInfo(String roomId, String roomName) {
        // 最後のチャットのルーム名
        PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, roomName);
        // 最後のチャットのルーム
        PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, roomId);
    }

    /**
     * プッシュメッセージ受信し、既にChatWebViewActivityが表示中の時、WebViewリロードする。
     * @param roomId ルームID
     * @param roomName ルーム名
     * @param collaborationType 協業タイプ
     */
    public void reloadRoomViewCollaboration(Long roomId, String roomName, String collaborationType) {
        chatData.roomId = roomId;
        chatData.roomName = roomName;
        chatData.setStrCollaborationType(collaborationType);
        registChatRoomPageLoader();
    }
}
