/**
 * ActionButton
 * @author Jang
 */
package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.ImageButton;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;

public class ActionButton extends ImageButton implements OnTouchListener {
    private static final String TAG = "ActionButton";
	private int arrayIndex = 0;
	private List<String> fileNames;

	private String text;
	private Paint paint;

	public ActionButton(Context context) {
		super(context);
		fileNames = new ArrayList<>();
		setOnTouchListener(this);
	}
	
	@Override
	public boolean onTouch(View v, MotionEvent event) {
		switch (event.getAction()) {
		case MotionEvent.ACTION_DOWN:
			ActionButton.this.getBackground().setColorFilter(0xFFCCCCCC, PorterDuff.Mode.MULTIPLY);
			break;
		case MotionEvent.ACTION_UP:
			ActionButton.this.getBackground().setColorFilter(null);
			break;
		}
		return false;
	}
	
	public void setFileNames(List<String> fileNames) {
		this.fileNames = fileNames;
	}
	
	public String getFileName(int index) {
		return fileNames.get(index);
	}
	
	public int nextIndex() {
		arrayIndex++;
		if (fileNames != null && fileNames.size() <= arrayIndex) {
			arrayIndex = 0;
		}
		return arrayIndex;
	}
	
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		boolean result = super.onTouchEvent(event);
		Logger.d("ActionButton", "[onTouchEvent]:result=" + result + ", parent=" + getParent());
		return !((ZoomRelativeLayout)getParent()).isZooming();// Zoomの際にはボタンを無効にする
	}

	public void setText(String str) {
		text = str;

		paint = new Paint();
		paint.setFlags(Paint.ANTI_ALIAS_FLAG);
		paint.setTextAlign(Paint.Align.LEFT);
		paint.setTextSize(18);
		paint.setColor(Color.DKGRAY);
		paint.setStyle(Paint.Style.FILL);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		super.onDraw(canvas);

		if (text == null) {
			Logger.d(TAG, "text is null.");
			return;
		}

		int w = 10;
		int h = this.getMeasuredHeight();

		canvas.drawText(text, w, h/2, paint);
	}
}
