package jp.agentec.abook.abv.ui.viewer.view;

import jp.agentec.abook.abv.cl.helper.ContentMarkingFileHelper;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.MotionEvent;
import android.widget.ImageView;
import android.widget.Toast;

/**
 * マーキングを描写するクラスです。 このクラスはタッチイベントを取得しません。
 * 
 * @author tauchi
 * 
 */
public class MarkingView extends ImageView {

	private long contentId;
	private int pageNum;
	private boolean markingExist;
	private Context context;

	public MarkingView(Context context, long contentId, int pageNum) {
		super(context);
		this.context = context;
		this.contentId = contentId;
		this.pageNum = pageNum;

		setMarkingFile();
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent event) {
		return false;
	}

	// ロード
	private void setMarkingFile() {
		try {
			ContentMarkingFileHelper contentMarkingService = new ContentMarkingFileHelper();
			Bitmap bitmap = contentMarkingService.getMarkingFile(contentId, pageNum);
			
			// ファイルが読み込めない場合、マーキングの存在フラグをtrue
			//noinspection VariableNotUsedInsideIf
            markingExist = bitmap != null;
			setImageBitmap(bitmap);
			setScaleType(ImageView.ScaleType.FIT_XY);
		} catch (Exception e) {
			ABVToastUtil.showMakeText(context, String.format(context.getResources().getString(R.string.load_fail), context.getResources().getString(R.string.marking_file_is)), Toast.LENGTH_SHORT);
		}
	}

	public boolean isMarkingExist() {
		return markingExist;
	}

	public int getPageNum() {
		return pageNum;
	}

	public void reLoad() {
		setMarkingFile();
		invalidate();
	}
}
