/*
 * Decompiled with CFR 0.152.
 */
package oz.api.custom;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import oz.api.custom.IOZDateTimePickerInfo;
import oz.api.custom.OZInputCompCmd;
import oz.api.custom.OZInputCompInfo;
import oz.main.OZStorage;

public class OZDateTimePickerInfo
extends OZInputCompInfo
implements IOZDateTimePickerInfo {
    public static final String K_DTP_MAX_DATE = "dtp_max_date";
    public static final String K_DTP_MIN_DATE = "dtp_min_date";
    public static final String K_DTP_PATTERN = "dtp_pattern";

    public OZDateTimePickerInfo(OZInputCompCmd oZInputCompCmd, int n, JSONObject jSONObject, JSONObject jSONObject2) {
        super(oZInputCompCmd, n, jSONObject, jSONObject2);
    }

    public long getMaxDate() {
        return this.getObject().optLong(K_DTP_MAX_DATE);
    }

    public long getMinDate() {
        return this.getObject().optLong(K_DTP_MIN_DATE);
    }

    public String getPattern() {
        return this.getObject().optString(K_DTP_PATTERN);
    }

    public String makeValueString(long l) {
        String string = this.getPattern();
        if (string != null) {
            if (string.startsWith("date_")) {
                string = string.substring(5);
            } else if (string.startsWith("d_")) {
                string = string.substring(2);
            } else if (string.startsWith("D_")) {
                string = string.substring(2);
            } else if (string.equalsIgnoreCase("STRING")) {
                string = "yyyy-MM-dd";
            }
            return new SimpleDateFormat(string, OZStorage.getViewerLocale()).format(new Date(l));
        }
        return null;
    }

    public long getDate() {
        String string;
        String string2 = this.getValue();
        if (string2 != null && !string2.isEmpty() && (string = this.getPattern()) != null) {
            if (string.startsWith("date_")) {
                string = string.substring(5);
            } else if (string.startsWith("d_")) {
                string = string.substring(2);
            } else if (string.startsWith("D_")) {
                string = string.substring(2);
            } else if (string.equalsIgnoreCase("STRING")) {
                string = "yyyy-MM-dd";
            }
            try {
                Date date = new SimpleDateFormat(string, OZStorage.getViewerLocale()).parse(string2);
                if (date != null) {
                    return date.getTime();
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return 0L;
    }

    public void setDate(long l) {
        this.setValue(this.makeValueString(l));
    }
}

