/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Color;
import org.json.JSONException;
import org.json.JSONObject;
import oz.client.shape.ui.EFormComponent;
import oz.client.shape.ui.ICImagePickerEform;
import oz.client.shape.ui.ICSignPadWndEform;

public class EFormComponentManager {
    public static EFormComponent getEFormComponent(Context context, String string, Object object) {
        EFormComponent eFormComponent = null;
        if ("SignPad".equalsIgnoreCase(string)) {
            eFormComponent = new ICSignPadWndEform(context);
            EFormComponentManager.setSignPadOption(eFormComponent, object);
        } else if ("Seal".equalsIgnoreCase(string)) {
            eFormComponent = new ICImagePickerEform(context);
            EFormComponentManager.setSealOption((ICImagePickerEform)eFormComponent, object);
        }
        return eFormComponent;
    }

    private static JSONObject toJSONObject(Object object) {
        JSONObject jSONObject = null;
        if (object instanceof JSONObject) {
            jSONObject = (JSONObject)object;
        } else {
            try {
                jSONObject = new JSONObject(object.toString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    private static float getPositiveFloat(float f2) {
        return Math.max(0.0f, f2);
    }

    private static float getOptionFloat(Object object, float f2) {
        float f3 = f2;
        if (object != null) {
            if (object instanceof Float) {
                f3 = ((Float)object).floatValue();
            } else if (object instanceof Integer) {
                f3 = ((Integer)object).intValue();
            } else if (object instanceof Double) {
                f3 = (float)((Double)object).doubleValue();
            } else {
                String string = object.toString();
                try {
                    f3 = Float.valueOf(string).floatValue();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return f3;
    }

    private static int getOptionColor(Object object, int n) {
        int n2 = n;
        if (object != null) {
            String string = object.toString();
            n2 = Color.parseColor((String)string);
        }
        return n2;
    }

    private static int getNonAlphaColor(int n) {
        return 0xFF000000 | n;
    }

    private static void setSignPadOption(ICSignPadWndEform iCSignPadWndEform, Object object) {
        JSONObject jSONObject;
        if (object != null && (jSONObject = EFormComponentManager.toJSONObject(object)) != null) {
            Object object2;
            if (jSONObject.has("backgroundColor")) {
                try {
                    iCSignPadWndEform.getOptions().backgroundColor = EFormComponentManager.getNonAlphaColor(EFormComponentManager.getOptionColor(jSONObject.get("backgroundColor"), -1));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("text")) {
                try {
                    object2 = jSONObject.get("text");
                    if (object2 != null) {
                        iCSignPadWndEform.getOptions().text = object2.toString();
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("penThick")) {
                try {
                    iCSignPadWndEform.getOptions().penThick = EFormComponentManager.getPositiveFloat(EFormComponentManager.getOptionFloat(jSONObject.get("penThick"), 1.0f));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("penColor")) {
                try {
                    iCSignPadWndEform.getOptions().penColor = EFormComponentManager.getNonAlphaColor(0xFF000000 | EFormComponentManager.getOptionColor(jSONObject.get("penColor"), -16777216));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("textSizeType")) {
                try {
                    object2 = jSONObject.get("textSizeType");
                    if (object2 != null) {
                        String string = object2.toString();
                        if (string.equalsIgnoreCase("big")) {
                            iCSignPadWndEform.getOptions().textSizeScale = 1.0f;
                        } else if (string.equalsIgnoreCase("normal")) {
                            iCSignPadWndEform.getOptions().textSizeScale = 0.6666667f;
                        } else if (string.equalsIgnoreCase("small")) {
                            iCSignPadWndEform.getOptions().textSizeScale = 0.4f;
                        }
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("showBorder")) {
                try {
                    iCSignPadWndEform.getOptions().showBorder = (Boolean)jSONObject.get("showBorder");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            iCSignPadWndEform.updateOptions();
        }
    }

    private static void setSealOption(ICImagePickerEform iCImagePickerEform, Object object) {
        JSONObject jSONObject;
        if (object != null && (jSONObject = EFormComponentManager.toJSONObject(object)) != null) {
            Object object2;
            if (jSONObject.has("backgroundColor")) {
                try {
                    iCImagePickerEform.getOptions().backgroundColor = EFormComponentManager.getNonAlphaColor(EFormComponentManager.getOptionColor(jSONObject.get("backgroundColor"), -1));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("borderColor")) {
                try {
                    object2 = jSONObject.get("borderColor");
                    if (object2 != null) {
                        iCImagePickerEform.getOptions().borderColor = EFormComponentManager.getNonAlphaColor(EFormComponentManager.getOptionColor(jSONObject.get("borderColor"), -1));
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("processType")) {
                try {
                    object2 = jSONObject.get("processType");
                    if (object2 != null) {
                        iCImagePickerEform.getOptions().processType = object2.toString();
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("jpgQuality")) {
                try {
                    iCImagePickerEform.getOptions().jpgQuality = Math.round(EFormComponentManager.getPositiveFloat(EFormComponentManager.getOptionFloat(jSONObject.get("jpgQuality"), 1.0f)));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("maxDpi")) {
                try {
                    iCImagePickerEform.getOptions().maxDpi = Math.round(EFormComponentManager.getPositiveFloat(EFormComponentManager.getOptionFloat(jSONObject.get("maxDpi"), 1.0f)));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            if (jSONObject.has("showBorder")) {
                try {
                    iCImagePickerEform.getOptions().showBorder = (Boolean)jSONObject.get("showBorder");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }
}

