/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.json.JSONException;
import org.json.JSONObject;
import oz.client.shape.ui.ICSginPadWndExtend;
import oz.client.shape.ui.ICSignPadWndSimple$1;
import oz.client.shape.ui.OZSignView;

public class ICSignPadWndSimple
extends ICSginPadWndExtend {
    private static final int ID_SIGN = 257464100;
    private String mText = "";
    private int mTextColor = -16777216;
    private int mTextGravity = 17;
    private int mBackgroundColor = -1;
    private int mBackgroundAlpha = 255;
    private int mPenColor = -16777216;
    private float mPenThick = 1.0f;
    private float mFontSize = 10.0f;
    private float mTextSizeScale = 1.0f;
    private boolean mIsKeepBackgroundColor = false;
    private boolean mIsTracingOutline = false;
    private int mGuideLineShapeType = 1;
    private String mCustomUIJSONString = null;
    private FrameLayout mView = new FrameLayout(this.getContext());
    private float mCompWidth;
    private float mCompHeight;
    private int mLastWidth;
    private int mLastHeight;
    private boolean isEmptyComponentTextSize = false;
    private View.OnTouchListener mListener = null;
    OZSignView signView;

    public ICSignPadWndSimple(Context context) {
        super(context);
    }

    public OZSignView getSimplerSignView() {
        return this.signView;
    }

    public void clearSimpleSignView() {
        if (this.signView != null) {
            ViewGroup viewGroup = (ViewGroup)this.signView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)this.signView);
            }
            this.signView = null;
        }
        this.mView.removeAllViews();
        this.mView = null;
    }

    public void setProperty(String string, int n, int n2, int n3, int n4, float f2, float f3, float f4, float f5) {
        this.mText = string;
        this.mTextColor = n;
        this.mTextGravity = n2;
        this.mBackgroundColor = (n3 & 0xFF) << 16 | n3 & 0xFF00 | (n3 & 0xFF0000) >> 16;
        this.mPenColor = n4;
        this.mPenThick = f2;
        this.mCompWidth = f3;
        this.mCompHeight = f4;
        this.mTextSizeScale = f5;
    }

    public void setProperty(String string, int n, int n2, int n3, int n4, float f2, float f3, float f4, float f5, boolean bl, boolean bl2, int n5, int n6, float f6) {
        this.mText = string;
        this.mTextColor = n;
        this.mTextGravity = n2;
        this.mBackgroundColor = (n3 & 0xFF) << 16 | n3 & 0xFF00 | (n3 & 0xFF0000) >> 16;
        this.mPenColor = n4;
        this.mPenThick = f2;
        this.mCompWidth = f3;
        this.mCompHeight = f4;
        this.mTextSizeScale = f5;
        this.mIsKeepBackgroundColor = bl;
        this.mIsTracingOutline = bl2;
        this.mGuideLineShapeType = n5;
        this.mBackgroundAlpha = n6;
        this.mFontSize = f6;
    }

    public FrameLayout getSimpleSignPadView(int n, int n2) {
        this.clearInputComponentView();
        this.getInputComponentViewDispose();
        this.mLastWidth = n;
        this.mLastHeight = n2;
        this.setComponentText(this.mText);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setBackgroundColor(0);
        this.signView = new OZSignView(this.getContext(), this, this.mCompWidth, this.mCompHeight, this.mLastWidth, this.mLastHeight);
        if (this.mListener != null) {
            this.signView.setOnTouchListener(this.mListener);
        }
        this.signView.setId(257464100);
        frameLayout.addView((View)this.signView);
        this.mView.addView((View)frameLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mLastWidth, this.mLastHeight));
        return this.mView;
    }

    public void setEnable(boolean bl) {
        if (this.signView != null) {
            this.signView.setOnTouchListener(new ICSignPadWndSimple$1(this, bl));
        }
    }

    public void getInputComponentViewDispose() {
        this.mView.removeAllViews();
    }

    public boolean isInputComponentViewCreated() {
        return this.mView.findViewById(257464100) != null;
    }

    public void clearInputComponentView() {
        if (this.isInputComponentViewCreated()) {
            OZSignView oZSignView = (OZSignView)this.mView.findViewById(257464100);
            oZSignView.clear();
        }
    }

    public String getComponentData() {
        String string = null;
        if (this.hasSignPathData()) {
            String string2 = this.getImagePathData();
            boolean bl = this.checkFittoFrame(string2);
            string = !bl ? this.makeFitToFrameString(0, this.getImagePathData(), this.mLastWidth, this.mLastHeight) : this.getImagePathData();
        }
        return string;
    }

    public void setComponentData(String string) {
        this.setSimpleSingViewPath(string, this.getCompOriginalWidth(), this.getCompOriginalHeight(), this.mLastWidth, this.mLastHeight, this.signView.getSignScale() * this.getSignPenThick().getThickness());
    }

    public void setCustomUIJSON(String string) {
        this.mCustomUIJSONString = string;
    }

    public void updateOptions() {
        this.getSignPenThick().setThickness(0, this.mPenThick, false);
        this.setSignPenColor(this.mPenColor);
    }

    public void updateOptions(int n) {
        this.getSignPenThick().setThickness(n, this.mPenThick, false);
        this.getSignPenThick().setSelected(n);
        this.setSignPenColor(this.mPenColor);
    }

    public boolean isTextBold() {
        return false;
    }

    public int getSignModeType() {
        return 4;
    }

    public int getSignViewType() {
        return 2;
    }

    public boolean isTracingOutLine() {
        return this.mIsTracingOutline;
    }

    public float getSignTextSize() {
        return this.mFontSize;
    }

    public float getComponentTextScale() {
        return this.mTextSizeScale;
    }

    public int getComponentTextColor() {
        return this.mTextColor;
    }

    public int getComponentBackGroundColor() {
        return this.mBackgroundColor;
    }

    public int getComponentGravity() {
        return 17;
    }

    public boolean isInputRender() {
        return true;
    }

    public void clearNativeBitmap() {
    }

    public void flushInputControls() {
    }

    public int getComponentBackGroundAlpha() {
        return this.mBackgroundAlpha;
    }

    public void setImageBitmap(boolean bl) {
    }

    public float getPageViewZoomScale() {
        return 1.0f;
    }

    public boolean isKeepRatioSign() {
        return true;
    }

    public boolean isSignPadKeepBackgroundColor() {
        return this.mIsKeepBackgroundColor;
    }

    public int getGuideLineShapeType() {
        return this.mGuideLineShapeType;
    }

    protected String getCustomUIJSONString() {
        return this.mCustomUIJSONString;
    }

    private boolean checkFittoFrame(String string) {
        try {
            String string2 = "data:image/ozvp;#100:";
            string = string.substring(string2.length());
            int n = string.indexOf(":");
            String string3 = string.substring(0, n);
            int n2 = Integer.parseInt(string3);
            String string4 = string.substring(n + 1, n + 1 + n2);
            JSONObject jSONObject = new JSONObject(string4);
            return !jSONObject.getBoolean("keepratio");
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public boolean isEmptyComponentTextSize() {
        return this.isEmptyComponentTextSize;
    }

    public void setEmptyComponentTextSize(boolean bl) {
        this.isEmptyComponentTextSize = bl;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mListener = onTouchListener;
    }
}

