/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListView;
import oz.client.shape.ui.OZFileListView$1;
import oz.client.shape.ui.OZFileListView$2;
import oz.client.shape.ui.OZFileListView$Dragging;
import oz.client.shape.ui.OZFileListView$DropListener;

public class OZFileListView
extends ListView {
    private static final String LOG_TAG = "OZFileListView";
    private static final int END_OF_LIST_POSITION = -2;
    private OZFileListView$DropListener mDropListener;
    private int draggingItemHoverPosition;
    private int dragStartPosition;
    private int mUpperBound;
    private int mLowerBound;
    private int touchSlop;
    private OZFileListView$Dragging dragging;
    private GestureDetector longPressDetector;

    public OZFileListView(Context context) {
        this(context, null);
    }

    public OZFileListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
    }

    public OZFileListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.longPressDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new OZFileListView$1(this));
        this.setOnItemLongClickListener(new OZFileListView$2(this));
    }

    private int myPointToPosition(int n, int n2) {
        if (n2 < 0) {
            return this.getFirstVisiblePosition();
        }
        Rect rect = new Rect();
        int n3 = this.getChildCount();
        for (int j = 0; j < n3; ++j) {
            View view = this.getChildAt(j);
            view.getHitRect(rect);
            if (!rect.contains(n, n2)) continue;
            return this.getFirstVisiblePosition() + j;
        }
        if (n >= rect.left && n < rect.right && n2 >= rect.bottom) {
            return -2;
        }
        return -1;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = false;
        int n = 0x10000003;
        int n2 = motionEvent.getAction();
        if (n2 == 0) {
            ImageView imageView;
            View view;
            float f2;
            float f3 = motionEvent.getX();
            int n3 = this.pointToPosition((int)f3, (int)(f2 = motionEvent.getY()));
            if (n3 != -1 && (view = this.getChildAt(n3 - this.getFirstVisiblePosition())) != null && (imageView = (ImageView)view.findViewById(n)) != null) {
                Rect rect = new Rect();
                Rect rect2 = new Rect();
                imageView.getGlobalVisibleRect(rect);
                this.getGlobalVisibleRect(rect2);
                if (rect.contains((int)f3 + rect2.left, (int)f2 + rect2.top)) {
                    bl = true;
                }
            }
            if (!bl) {
                return super.onTouchEvent(motionEvent);
            }
        }
        if (this.longPressDetector.onTouchEvent(motionEvent)) {
            return true;
        }
        if (this.dragging == null || this.mDropListener == null) {
            return super.onTouchEvent(motionEvent);
        }
        n = motionEvent.getAction();
        switch (motionEvent.getAction()) {
            case 1: 
            case 3: {
                this.dragging.stop();
                this.dragging = null;
                if (this.mDropListener != null) {
                    if (this.draggingItemHoverPosition == -2) {
                        this.mDropListener.drop(this.dragStartPosition, this.getCount() - 1);
                    } else if (this.draggingItemHoverPosition != -1) {
                        this.mDropListener.drop(this.dragStartPosition, this.draggingItemHoverPosition);
                    }
                }
                this.resetViews();
                break;
            }
            case 0: 
            case 2: {
                n2 = (int)motionEvent.getX();
                int n4 = (int)motionEvent.getY();
                this.dragging.drag(n2, n4);
                int n5 = this.dragging.calculateHoverPosition();
                if (n5 == -1) break;
                if (n == 0 || n5 != this.draggingItemHoverPosition) {
                    this.draggingItemHoverPosition = n5;
                    this.doExpansion();
                }
                this.scrollList(n4);
            }
        }
        return true;
    }

    private void doExpansion() {
        View view;
        int n = this.draggingItemHoverPosition - this.getFirstVisiblePosition();
        if (this.draggingItemHoverPosition >= this.dragStartPosition) {
            ++n;
        }
        Log.v((String)LOG_TAG, (String)("Dragging item hovers over position " + this.draggingItemHoverPosition + ", expand item at index " + n));
        View view2 = this.getChildAt(this.dragStartPosition - this.getFirstVisiblePosition());
        int n2 = 0;
        while ((view = this.getChildAt(n2)) != null) {
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            int n3 = -2;
            if (view.equals(view2)) {
                n3 = 1;
            } else if (n2 == n) {
                n3 = view.getHeight();
            }
            layoutParams.height = n3;
            view.setLayoutParams(layoutParams);
            ++n2;
        }
    }

    private void resetViews() {
        int n = 0;
        while (true) {
            View view;
            if ((view = this.getChildAt(n)) == null) {
                this.layoutChildren();
                view = this.getChildAt(n);
                if (view == null) break;
            }
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.height = -2;
            view.setBackgroundColor(0);
            view.setLayoutParams(layoutParams);
            ++n;
        }
    }

    private void resetScrollBounds(int n) {
        int n2 = this.getHeight();
        if (n >= n2 / 3) {
            this.mUpperBound = n2 / 3;
        }
        if (n <= n2 * 2 / 3) {
            this.mLowerBound = n2 * 2 / 3;
        }
    }

    private void scrollList(int n) {
        this.resetScrollBounds(n);
        int n2 = this.getHeight();
        int n3 = 0;
        if (n > this.mLowerBound) {
            n3 = n > (n2 + this.mLowerBound) / 2 ? 16 : 4;
        } else if (n < this.mUpperBound) {
            int n4 = n3 = n < this.mUpperBound / 2 ? -16 : -4;
        }
        if (n3 != 0) {
            View view;
            int n5 = this.pointToPosition(0, n2 / 2);
            if (n5 == -1) {
                n5 = this.pointToPosition(0, n2 / 2 + this.getDividerHeight() + 64);
            }
            if ((view = this.getChildAt(n5 - this.getFirstVisiblePosition())) != null) {
                int n6 = view.getTop();
                this.setSelectionFromTop(n5, n6 - n3);
            }
        }
    }

    public void setDropListener(OZFileListView$DropListener oZFileListView$DropListener) {
        this.mDropListener = oZFileListView$DropListener;
    }

    static /* synthetic */ OZFileListView$Dragging access$000(OZFileListView oZFileListView) {
        return oZFileListView.dragging;
    }

    static /* synthetic */ OZFileListView$Dragging access$002(OZFileListView oZFileListView, OZFileListView$Dragging oZFileListView$Dragging) {
        oZFileListView.dragging = oZFileListView$Dragging;
        return oZFileListView.dragging;
    }

    static /* synthetic */ int access$102(OZFileListView oZFileListView, int n) {
        oZFileListView.draggingItemHoverPosition = n;
        return oZFileListView.draggingItemHoverPosition;
    }

    static /* synthetic */ int access$202(OZFileListView oZFileListView, int n) {
        oZFileListView.dragStartPosition = n;
        return oZFileListView.dragStartPosition;
    }

    static /* synthetic */ int access$100(OZFileListView oZFileListView) {
        return oZFileListView.draggingItemHoverPosition;
    }

    static /* synthetic */ int access$302(OZFileListView oZFileListView, int n) {
        oZFileListView.mUpperBound = n;
        return oZFileListView.mUpperBound;
    }

    static /* synthetic */ int access$400(OZFileListView oZFileListView) {
        return oZFileListView.touchSlop;
    }

    static /* synthetic */ int access$502(OZFileListView oZFileListView, int n) {
        oZFileListView.mLowerBound = n;
        return oZFileListView.mLowerBound;
    }

    static /* synthetic */ int access$600(OZFileListView oZFileListView, int n, int n2) {
        return oZFileListView.myPointToPosition(n, n2);
    }

    static /* synthetic */ int access$200(OZFileListView oZFileListView) {
        return oZFileListView.dragStartPosition;
    }
}

