/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import org.json.JSONException;
import org.json.JSONObject;
import oz.client.shape.ui.ICSignPadWnd;

public class OZSignPadBackgroundView
extends View {
    public static final int LINESIZE = 4;
    public static final int LINESIZE_HALF = 2;
    private ICSignPadWnd mParent;
    private Paint mPaint;
    private RectF mRectF;
    private boolean mIsAnimationEffect;
    private AnimationSet mAnimation;

    public OZSignPadBackgroundView(Context context, ICSignPadWnd iCSignPadWnd) {
        super(context);
        this.mParent = iCSignPadWnd;
        this.mPaint = new Paint(1);
        this.mRectF = new RectF();
    }

    public ICSignPadWnd getICParent() {
        return this.mParent;
    }

    public boolean isAnimationEffect() {
        return this.mIsAnimationEffect;
    }

    public void setAnimationEffect(boolean bl) {
        this.mIsAnimationEffect = bl;
    }

    private void initAnimation() {
        if (this.mAnimation == null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setDuration(1000L);
            alphaAnimation.setRepeatMode(2);
            alphaAnimation.setRepeatCount(-1);
            this.mAnimation = new AnimationSet(true);
            this.mAnimation.addAnimation((Animation)alphaAnimation);
        }
    }

    public void setAnimations(boolean bl) {
        if (bl) {
            this.initAnimation();
            if (this.getAnimation() != this.mAnimation) {
                this.setAnimation((Animation)this.mAnimation);
                this.startAnimation((Animation)this.mAnimation);
            }
        } else {
            Animation animation = this.getAnimation();
            if (animation != null) {
                animation.cancel();
                animation.reset();
            }
            this.setAnimation(null);
        }
    }

    public void onDraw(Canvas canvas) {
        if (this.getICParent() != null) {
            if (this.isSetCustomUIComp()) {
                return;
            }
            this.mPaint.setColor(this.getICParent().getSignPadBorderColor());
            this.mPaint.setStrokeWidth(4.0f);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            if (this.isAnimationEffect()) {
                if (!this.getICParent().isShowThis() && (this.getICParent().isSignModePadLikeKeepRatio() || this.getICParent().isSignModePadLikeScrollable() || this.getICParent().nativeIsSetSignPadHighLightColor())) {
                    this.mPaint.setAlpha(50);
                    this.setAnimations(false);
                } else {
                    this.mPaint.setAlpha(255);
                    this.setAnimations(true);
                }
            }
            this.mRectF.set((float)this.getLeft(), (float)this.getTop(), (float)this.getRight(), (float)this.getBottom());
            this.mRectF.inset(2.0f, 2.0f);
            canvas.drawRect(this.mRectF, this.mPaint);
        }
    }

    public boolean isSetCustomUIComp() {
        String string;
        if (!this.getICParent().isSignModeZoom() && (string = this.getICParent().getCustomUIComp()) != null && !string.isEmpty()) {
            try {
                JSONObject jSONObject;
                int n;
                JSONObject jSONObject2 = new JSONObject(string);
                if (!jSONObject2.isNull("signview") && (n = Integer.parseInt((jSONObject = jSONObject2.getJSONObject("signview")).getString("borderthick"))) >= 1) {
                    return true;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return false;
    }
}

