/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.widget.FrameLayout;
import oz.viewer.ui.df.DFUtils;

public class ImageMergeFrameLayout
extends FrameLayout {
    private Rect mSelectedRect;
    private Paint mSelectedRectPaint;

    public ImageMergeFrameLayout(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSelectedRect != null && !this.mSelectedRect.isEmpty()) {
            canvas.drawRect(this.mSelectedRect, this.getSelectedRectPaint());
        }
    }

    private Paint getSelectedRectPaint() {
        if (this.mSelectedRectPaint == null) {
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(Color.rgb((int)41, (int)148, (int)255));
            paint.setStrokeWidth(DFUtils.toDP_F(this.getContext(), 7.0f));
            this.mSelectedRectPaint = paint;
        }
        return this.mSelectedRectPaint;
    }

    public void drawSelectedRect(Rect rect) {
        if (rect != this.mSelectedRect) {
            this.mSelectedRect = rect;
            this.postInvalidate();
        }
    }
}

