/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oz.client.shape.ui.OZInputComponent;
import oz.client.shape.ui.imgmerge.ImageMergeFrameLayout;
import oz.client.shape.ui.imgmerge.ImageMergeItemBitmap;
import oz.client.shape.ui.imgmerge.ImageMergeItemImageView;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutBase;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutType1;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutType2;
import oz.client.shape.ui.imgmerge.ImageMergeItemLayoutType4;
import oz.client.shape.ui.imgmerge.ImageMergeManager$1;
import oz.client.shape.ui.imgmerge.ImageMergeManager$2;
import oz.client.shape.ui.imgmerge.ImageMergeManager$ImageMergeIneterface;
import oz.client.shape.ui.imgmerge.ImageMergeView;
import oz.viewer.ui.df.DFUtils;

public class ImageMergeManager
implements View.OnClickListener {
    public static final int IMM_TYPE_ROTATE = 0;
    public static final int IMM_TYPE_IMAGE_MERGE = 1;
    public static final int[] TEMPLETE_LIST = new int[]{2, 4};
    private ImageMergeManager$ImageMergeIneterface mInterface;
    private Context mContext;
    private Bitmap mBitmap;
    private int mViewType;
    private int mCompType;
    private String mImageType;
    private Dialog mDialog;
    private int mTargetWidth;
    private int mTargetHeight;
    private boolean mIsVertical = true;
    private ArrayList mItems;
    private int mSelected;
    private int mAddTargetIndex;
    private ImageMergeItemLayoutBase mPaperLayout;
    private byte[] mData = new byte[10];
    private int mEditPosition = -1;
    private boolean mEdited = false;

    public ImageMergeManager(Context context, ImageMergeManager$ImageMergeIneterface imageMergeManager$ImageMergeIneterface, int n, Bitmap bitmap, String string, int n2) {
        this._init(context, imageMergeManager$ImageMergeIneterface, n, bitmap, 0, string, n2);
    }

    public ImageMergeManager(Context context, ImageMergeManager$ImageMergeIneterface imageMergeManager$ImageMergeIneterface) {
        this._init(context, imageMergeManager$ImageMergeIneterface, 0, null, 1, null, -1);
    }

    private void _init(Context context, ImageMergeManager$ImageMergeIneterface imageMergeManager$ImageMergeIneterface, int n, Bitmap bitmap, int n2, String string, int n3) {
        this.mContext = context;
        this.mInterface = imageMergeManager$ImageMergeIneterface;
        this.mCompType = n;
        this.mImageType = string;
        this.mBitmap = bitmap;
        this.mViewType = n2;
        this.mEditPosition = n3;
        OZInputComponent.lockDeviceRotation(this.mContext);
        this.mItems = new ArrayList(4);
        this.mItems.add(new ImageMergeItemBitmap(null));
        this.mItems.add(new ImageMergeItemBitmap(null));
        this.mItems.add(new ImageMergeItemBitmap(null));
        this.mItems.add(new ImageMergeItemBitmap(null));
        this.mSelected = -1;
    }

    private void setSelected(int n) {
        if (this.mItems.size() > n && n > -1) {
            this.mSelected = n;
            this.updateBottomButtons(true);
        } else {
            this.mSelected = -1;
            this.clearSelectedRect();
            this.updateBottomButtons(false);
        }
        this.updateCompleteButton();
    }

    public void setSelected(Object object) {
        if (object == null) {
            this.setSelected(-1);
        } else {
            this.setSelected(this.mItems.indexOf(object));
        }
    }

    public void setAddTargetIndex(Object object) {
        this.mAddTargetIndex = object == null ? -1 : this.mItems.indexOf(object);
    }

    public ImageMergeItemBitmap getSelectedItem() {
        if (this.hasSelectedItem()) {
            return (ImageMergeItemBitmap)this.mItems.get(this.mSelected);
        }
        return null;
    }

    public ImageMergeItemBitmap getAddTargetItem() {
        if (this.hasAddTargetItem()) {
            return (ImageMergeItemBitmap)this.mItems.get(this.mAddTargetIndex);
        }
        return null;
    }

    public boolean hasSelectedItem() {
        return this.mSelected > -1;
    }

    public boolean hasAddTargetItem() {
        return this.mAddTargetIndex > -1;
    }

    public Context getContext() {
        return this.mContext;
    }

    public List getItems() {
        return this.mItems;
    }

    public void setProperty(int n, int n2) {
        this.mTargetWidth = n;
        this.mTargetHeight = n2;
        this.mIsVertical = this.mTargetWidth <= this.mTargetHeight;
    }

    public void showDialog() {
        ImageMergeView imageMergeView = null;
        if (this.mViewType == 0) {
            imageMergeView = new ImageMergeView(this.mContext, this.mTargetWidth, this.mTargetHeight, this.mViewType, this.mCompType, this.mBitmap);
        } else if (this.mViewType == 1) {
            imageMergeView = new ImageMergeView(this.mContext, this.mTargetWidth, this.mTargetHeight, this.mViewType, TEMPLETE_LIST);
        }
        this.mDialog = DFUtils.makeFullScreenDialog(this.getContext(), imageMergeView);
        this.initView();
        this.setOnClickListener(this.mDialog, 3, this);
        this.setOnClickListener(this.mDialog, 4, this);
        this.setOnClickListener(this.mDialog, 7, this);
        this.setOnClickListener(this.mDialog, 8, this);
        this.setOnClickListener(this.mDialog, 14, this);
        this.setOnClickListener(this.mDialog, 15, this);
        this.setOnClickListener(this.mDialog, 16, this);
        this.setOnClickListener(this.mDialog, 17, this);
        this.setOnClickListener(this.mDialog, 18, this);
        this.mDialog.getWindow().setSoftInputMode(19);
        this.mDialog.show();
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)new ImageMergeManager$1(this));
    }

    public void dismissDialog() {
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    private void initView() {
        if (this.mViewType == 0) {
            this.updateItemLayout1();
        } else if (this.mViewType == 1) {
            View view = this.mDialog.findViewById(ImageMergeView.DIVISION_LIST[0]);
            if (view != null) {
                view.setSelected(true);
            }
            this.updateItemLayout2();
        }
    }

    private void setOnClickListener(Dialog dialog, int n, View.OnClickListener onClickListener) {
        View view;
        if (dialog != null && (view = dialog.findViewById(n)) != null) {
            view.setOnClickListener(onClickListener);
        }
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 3: {
                this.cancelBtn();
                break;
            }
            case 4: {
                this.completeBtn();
                break;
            }
            case 7: {
                if (!this.updateDivisionButtons(view)) break;
                this.mEdited = true;
                this.updateItemLayout2();
                break;
            }
            case 8: {
                if (!this.updateDivisionButtons(view)) break;
                this.mEdited = true;
                this.updateItemLayout4();
                break;
            }
            case 14: {
                this.mEdited = true;
                this.rotateImage(false);
                break;
            }
            case 15: {
                this.mEdited = true;
                this.rotateImage(true);
                break;
            }
            case 16: {
                this.mEdited = true;
                this.aspectFit();
                break;
            }
            case 17: {
                this.mEdited = true;
                this.aspectFill();
                break;
            }
            case 18: {
                this.mEdited = true;
                this.clearImage();
            }
        }
    }

    private boolean updateDivisionButtons(View view) {
        if (view.isSelected()) {
            return false;
        }
        for (int n : ImageMergeView.DIVISION_LIST) {
            View view2 = this.mDialog.findViewById(n);
            if (view != view2) {
                view2.setSelected(false);
                continue;
            }
            view2.setSelected(true);
        }
        return true;
    }

    private Bitmap drawCanvas(View view) {
        Bitmap bitmap = null;
        if (this.mViewType == 0) {
            bitmap = this.getRotateBitmap(view);
        } else if (this.mViewType == 1) {
            bitmap = this.getMergeBitmap(view);
        }
        return bitmap;
    }

    private Bitmap getRotateBitmap(View view) {
        Matrix matrix;
        ImageMergeItemBitmap imageMergeItemBitmap = this.getSelectedItem();
        Bitmap bitmap = imageMergeItemBitmap.getBitmap();
        if (imageMergeItemBitmap.getDegree() != 0) {
            matrix = new Matrix();
            matrix.postRotate((float)imageMergeItemBitmap.getDegree());
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        if (imageMergeItemBitmap.getAspectStyle() == ImageView.ScaleType.CENTER_CROP) {
            Matrix matrix2 = matrix = new Rect(0, 0, this.mTargetWidth, this.mTargetHeight);
            float f2 = bitmap.getWidth();
            float f3 = bitmap.getHeight();
            float f4 = f2 / (float)matrix.width();
            float f5 = f3 / (float)matrix.height();
            float f6 = Math.min(f4, f5);
            if (f4 <= f5) {
                matrix2.right = Math.round(f2);
                matrix2.bottom = Math.round(Math.round(f3 / 2.0f) + Math.round((float)matrix.height() * f6 / 2.0f));
            } else {
                matrix2.right = Math.round(Math.round(f2 / 2.0f) + Math.round((float)matrix.width() * f6 / 2.0f));
                matrix2.bottom = Math.round(f3);
            }
            matrix2.left = Math.round(f2 - (float)matrix2.right);
            matrix2.top = Math.round(f3 - (float)matrix2.bottom);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)Math.max(0, matrix2.left), (int)Math.max(0, matrix2.top), (int)Math.min(bitmap.getWidth(), matrix2.width()), (int)Math.min(bitmap.getHeight(), matrix2.height()));
        }
        return bitmap;
    }

    private Bitmap getMergeBitmap(View view) {
        Size size;
        int n;
        int n2;
        int n3 = this.mTargetWidth;
        int n4 = this.mTargetHeight;
        if (this.mPaperLayout.getDivision() == 1) {
            n4 /= 2;
        } else if (this.mPaperLayout.getDivision() == 2) {
            n3 /= 2;
        } else if (this.mPaperLayout.getDivision() == 3) {
            n3 /= 2;
            n4 /= 2;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        List list = this.getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ImageMergeItemBitmap imageMergeItemBitmap : list) {
            Object object;
            if (imageMergeItemBitmap == null) continue;
            View view2 = view.findViewWithTag((Object)imageMergeItemBitmap);
            if (view2 != null && view2 instanceof ImageMergeItemImageView) {
                object = (ImageMergeItemImageView)view2;
                ((ImageMergeItemImageView)((Object)object)).setIgnoreDefaultBitmapDraw(true);
                arrayList.add(object);
            }
            if ((object = imageMergeItemBitmap.getBitmap()) == null) continue;
            n2 = imageMergeItemBitmap.getDegree();
            n5 = object.getWidth();
            n6 = object.getHeight();
            if (Math.abs(n2) == 90 || Math.abs(n2) == 270) {
                n5 = object.getHeight();
                n6 = object.getWidth();
            }
            ImageView.ScaleType scaleType = imageMergeItemBitmap.getAspectStyle();
            int n9 = n5;
            n = n6;
            if (scaleType == ImageView.ScaleType.FIT_CENTER) {
                if (n3 / n5 > n4 / n6) {
                    n9 = n6 * n3 / n4;
                } else {
                    n = n5 * n4 / n3;
                }
            } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
                if (n3 / n5 > n4 / n6) {
                    n = n5 * n4 / n3;
                } else {
                    n9 = n6 * n3 / n4;
                }
            }
            n7 = Math.max(n7, n9);
            n8 = Math.max(n8, n);
        }
        int n10 = n7;
        int n11 = n8;
        if (this.mPaperLayout.getDivision() == 1) {
            n11 *= 2;
        } else if (this.mPaperLayout.getDivision() == 2) {
            n10 *= 2;
        } else if (this.mPaperLayout.getDivision() == 3) {
            n10 *= 2;
            n11 *= 2;
        }
        n5 = n10;
        n6 = n11;
        int n12 = n10;
        int n13 = n11;
        n2 = view.getWidth();
        int n14 = view.getHeight();
        if (n2 == 0) {
            n2 = 1;
        }
        if (n14 == 0) {
            n14 = 1;
        }
        if ((size = this.mInterface.getMergeImageMaxSize(n12, n13)) != null && size.getWidth() > 0 && size.getHeight() > 0) {
            n12 = size.getWidth();
            n13 = size.getHeight();
        }
        n = 4000;
        int n15 = Math.max(n12, n13);
        if (n15 > n) {
            float f2 = (float)n15 / (float)n;
            n12 = (int)((float)n12 / f2);
            n13 = (int)((float)n13 / f2);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n12, (int)n13, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float f3 = (float)n12 / (float)n2;
        float f4 = (float)n13 / (float)n14;
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(f3, f4);
        canvas.drawColor(-1);
        view.draw(canvas);
        for (ImageMergeItemImageView imageMergeItemImageView : arrayList) {
            imageMergeItemImageView.setIgnoreDefaultBitmapDraw(false);
        }
        return bitmap;
    }

    private void setPaperLayout(int n, boolean bl) {
        View view = this.mDialog.findViewById(11);
        ImageMergeItemLayoutType2 imageMergeItemLayoutType2 = null;
        if (view != null) {
            ImageMergeFrameLayout imageMergeFrameLayout = (ImageMergeFrameLayout)view;
            switch (n) {
                case 0: {
                    imageMergeItemLayoutType2 = new ImageMergeItemLayoutType1(imageMergeFrameLayout, bl);
                    break;
                }
                case 1: {
                    imageMergeItemLayoutType2 = new ImageMergeItemLayoutType2(imageMergeFrameLayout, bl);
                    break;
                }
                case 2: {
                    imageMergeItemLayoutType2 = new ImageMergeItemLayoutType4(imageMergeFrameLayout, bl);
                }
            }
        }
        if (this.mPaperLayout != null) {
            this.mPaperLayout.removeItemLayout(this);
        }
        this.mPaperLayout = imageMergeItemLayoutType2;
        if (this.mPaperLayout != null) {
            this.mPaperLayout.addItemLayout(this, this.mTargetWidth, this.mTargetHeight);
        }
    }

    private void updateItemLayout1() {
        this.setPaperLayout(0, this.mIsVertical);
        this.setSelected(0);
        this.setRotateToolbar();
        this.updateItemImageView(this.mBitmap);
    }

    private void updateItemLayout2() {
        this.setPaperLayout(1, this.mIsVertical);
        this.setSelected(-1);
    }

    private void updateItemLayout4() {
        this.setPaperLayout(2, this.mIsVertical);
        this.setSelected(-1);
    }

    private void setRotateToolbar() {
        this.hideDivisionBar();
        this.hideClearBtn();
    }

    private void hideDivisionBar() {
        View view = this.mDialog.findViewById(6);
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private void hideClearBtn() {
        View view = this.mDialog.findViewById(18);
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private void cancelBtn() {
        if (this.mDialog != null) {
            this.mInterface.cancel();
            this.mDialog.dismiss();
        }
    }

    private void completeBtn() {
        if (this.mDialog != null) {
            View view = this.mDialog.findViewById(12);
            Bitmap bitmap = this.drawCanvas(view);
            int n = bitmap.getWidth() * bitmap.getHeight();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            if (this.mViewType == 0) {
                if (this.mImageType.equalsIgnoreCase("PNG")) {
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)byteArrayOutputStream);
                } else {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream);
                }
                this.mData = byteArrayOutputStream.toByteArray();
            } else if (this.mViewType == 1) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)byteArrayOutputStream);
                this.mData = byteArrayOutputStream.toByteArray();
            }
            this.mInterface.setValue(this.mData, this.mData.length);
            this.mDialog.dismiss();
        }
    }

    private void rotateImage(boolean bl) {
        View view;
        View view2;
        ImageMergeItemBitmap imageMergeItemBitmap = this.getSelectedItem();
        if (imageMergeItemBitmap != null && (view2 = (view = this.mDialog.findViewById(10)).findViewWithTag((Object)imageMergeItemBitmap)) != null && view2 instanceof ImageMergeItemImageView) {
            if (bl) {
                ((ImageMergeItemImageView)view2).rotateClockWise();
            } else {
                ((ImageMergeItemImageView)view2).rotateCounterClockWise();
            }
        }
    }

    private void clearImage() {
        ImageMergeItemBitmap imageMergeItemBitmap = this.getSelectedItem();
        if (imageMergeItemBitmap != null) {
            imageMergeItemBitmap.setBitmap(null);
            View view = this.mDialog.findViewById(10);
            ImageMergeItemImageView imageMergeItemImageView = (ImageMergeItemImageView)view.findViewWithTag((Object)imageMergeItemBitmap);
            if (imageMergeItemImageView != null && imageMergeItemImageView instanceof ImageMergeItemImageView) {
                imageMergeItemImageView.updateWithItem(imageMergeItemBitmap);
                this.setSelected(-1);
            }
        }
    }

    private void aspectFit() {
        View view;
        View view2;
        ImageMergeItemBitmap imageMergeItemBitmap = this.getSelectedItem();
        if (imageMergeItemBitmap != null && (view2 = (view = this.mDialog.findViewById(10)).findViewWithTag((Object)imageMergeItemBitmap)) != null && view2 instanceof ImageMergeItemImageView) {
            ((ImageMergeItemImageView)view2).aspectFit();
        }
    }

    private void aspectFill() {
        View view;
        View view2;
        ImageMergeItemBitmap imageMergeItemBitmap = this.getSelectedItem();
        if (imageMergeItemBitmap != null && (view2 = (view = this.mDialog.findViewById(10)).findViewWithTag((Object)imageMergeItemBitmap)) != null && view2 instanceof ImageMergeItemImageView) {
            ((ImageMergeItemImageView)view2).aspectFill();
        }
    }

    public void drawSelectedRect(View view) {
        if (this.mPaperLayout != null) {
            this.mPaperLayout.select(view);
        }
    }

    public void clearSelectedRect() {
        this.drawSelectedRect(null);
    }

    public void updateBottomButtons(boolean bl) {
        if (this.mDialog != null) {
            for (int j = 0; j < ImageMergeView.BOTTOM_BUTTON_LIST.length; ++j) {
                ImageView imageView = (ImageView)this.mDialog.findViewById(ImageMergeView.BOTTOM_BUTTON_LIST[j]);
                imageView.setEnabled(bl);
            }
        }
    }

    public void updateCompleteButton() {
        boolean bl = false;
        View view = this.mItems.iterator();
        while (view.hasNext()) {
            ImageMergeItemBitmap imageMergeItemBitmap = (ImageMergeItemBitmap)view.next();
            if (imageMergeItemBitmap.getBitmap() == null) continue;
            bl = true;
        }
        if (this.mDialog != null && (view = this.mDialog.findViewById(4)) != null) {
            if (bl) {
                ((TextView)view).setTextColor(-16776961);
            } else {
                ((TextView)view).setTextColor(Color.argb((int)66, (int)0, (int)0, (int)255));
            }
            view.setEnabled(bl);
        }
    }

    public void updateItemImageView(Bitmap bitmap) {
        ImageMergeItemBitmap imageMergeItemBitmap = this.getAddTargetItem();
        if (imageMergeItemBitmap != null) {
            imageMergeItemBitmap.setBitmap(bitmap);
            View view = this.mDialog.findViewById(10);
            ImageMergeItemImageView imageMergeItemImageView = (ImageMergeItemImageView)view.findViewWithTag((Object)imageMergeItemBitmap);
            if (imageMergeItemImageView != null && imageMergeItemImageView instanceof ImageMergeItemImageView) {
                imageMergeItemImageView.updateWithItem(imageMergeItemBitmap);
            }
            this.setSelected(imageMergeItemBitmap);
            this.drawSelectedRect((View)imageMergeItemImageView);
        }
        this.mAddTargetIndex = -1;
    }

    public void postUpdateItemImageView(Bitmap bitmap) {
        ImageMergeManager$2 imageMergeManager$2 = new ImageMergeManager$2(this, bitmap);
        View view = null;
        if (this.mDialog != null) {
            view = this.mDialog.findViewById(9);
        }
        if (view != null) {
            view.postDelayed((Runnable)imageMergeManager$2, 150L);
        } else {
            this.updateItemImageView(bitmap);
        }
    }

    public int getEditPosition() {
        return this.mEditPosition;
    }

    public boolean isEdited() {
        return this.mEdited;
    }

    static /* synthetic */ Context access$000(ImageMergeManager imageMergeManager) {
        return imageMergeManager.mContext;
    }
}

