/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui.imgmerge;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import oz.client.shape.ui.imgmerge.ImageMergeFrameLayout;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.df.DFUtils;

public class ImageMergeView
extends FrameLayout {
    private Context mContext;
    public static final int IMV_ID_ROOT_LAYOUT = 0;
    public static final int IMV_ID_LINEAR_LAYOUT = 1;
    public static final int IMV_ID_TOPBAR_LAYOUT = 2;
    public static final int IMV_ID_TOPBAR_CANCEL = 3;
    public static final int IMV_ID_TOPBAR_COMPLETE = 4;
    public static final int IMV_ID_TOPBAR_TITLE = 5;
    public static final int IMV_ID_DIVISION_LAYOUT = 6;
    public static final int IMV_ID_DIVISION_2 = 7;
    public static final int IMV_ID_DIVISION_4 = 8;
    public static final int IMV_ID_CONTENT_LAYOUT = 9;
    public static final int IMV_ID_CONTENT_BACKGROUND_FRAMELAYOUT = 10;
    public static final int IMV_ID_CONTENT_ITEM_LAYOUT_CONTENT_FRAMELAYOUT = 11;
    public static final int IMV_ID_CONTENT_ITEM_LAYOUT_PAPER_LINEARLAYOUT = 12;
    public static final int IMV_ID_BOTTOMBAR_LAYOUT = 13;
    public static final int IMV_ID_BOTTOMBAR_ROTATE_COUNTERCLOCKWISE = 14;
    public static final int IMV_ID_BOTTOMBAR_ROTATE_CLOCKWISE = 15;
    public static final int IMV_ID_BOTTOMBAR_ASPECT_FIT = 16;
    public static final int IMV_ID_BOTTOMBAR_ASPECT_FILL = 17;
    public static final int IMV_ID_BOTTOMBAR_CLEAR = 18;
    public static final int IMV_ID_CONTENT_IMAGE_VIEW_1 = 1001;
    public static final int IMV_ID_CONTENT_IMAGE_VIEW_2 = 1002;
    public static final int IMV_ID_CONTENT_IMAGE_VIEW_3 = 1003;
    public static final int IMV_ID_CONTENT_IMAGE_VIEW_4 = 1004;
    public static final int DP_TOPBAR_HEIGHT = 40;
    public static final int DP_DIVISION_HEIGHT = 60;
    public static final int DP_BOTTOMBAR_HEIGHT = 80;
    public static final int DP_PADDING_TOPTOOLBAR_TB = 3;
    public static final int DP_MARGIN_TOPBAR_LR = 20;
    public static final int DP_MARGIN_CONTENT_IMF_TOPNBOTTOM = 10;
    public static final int DP_MARGIN_CONTENT_IMF_LEFTNRIGHT = 10;
    public static final int DP_MARGIN_CONTENT_BASE_FRAMELAYOUT_LTRB = 10;
    public static final int DP_MARGIN_DIVISION_IV_LR = 10;
    public static final int DP_MARGIN_DIVISION_IV_TB = 10;
    public static final int DP_MARGIN_BOTTOMBAR_IV_LR = 7;
    public static final int DP_MARGIN_BOTTOMBAR_IV_TB = 10;
    public static final int DP_VIEWSIZE_DIVISIONBAR_IV = 45;
    public static final int DP_VIEWSIZE_BOTTOMBAR_IV = 60;
    public static final int DP_VIEWSIZE_DIALOG_ITEM_WIDTH = 130;
    public static final int DP_VIEWSIZE_DIALOG_ITEM_HEIGHT = 60;
    public static final int SP_TEXTSIZE_TOPBAR_CANCELNCOMPLETE = 18;
    public static final int SP_TEXTSIZE_TOPBAR_TITLE = 18;
    public static final int SP_TEXTSIZE_DIALOG_ITEM = 20;
    public static final int[] DIVISION_LIST = new int[]{7, 8};
    public static final int[] BOTTOM_BUTTON_LIST = new int[]{14, 15, 16, 17, 18};
    private int mViewType;
    LinearLayout mRootLinearLayout;
    private int[] mTempleteList;
    private int mWidth;
    private int mHeight;
    private boolean mIsVertical;

    public ImageMergeView(Context context, int n, int n2, int n3, int n4, Bitmap bitmap) {
        super(context);
        this.mContext = context;
        this.mWidth = n;
        this.mHeight = n2;
        this.mViewType = n3;
        this.mIsVertical = this.mWidth < this.mHeight;
        this.create();
    }

    public ImageMergeView(Context context, int n, int n2, int n3, int[] nArray) {
        super(context);
        this.mContext = context;
        this.mWidth = n;
        this.mHeight = n2;
        this.mViewType = n3;
        this.mTempleteList = nArray;
        this.mIsVertical = this.mWidth < this.mHeight;
        this.create();
    }

    private void create() {
        this.setBackgroundColor(-16711681);
        this.setId(0);
        this.mRootLinearLayout = new LinearLayout(this.mContext);
        this.mRootLinearLayout.setId(1);
        this.mRootLinearLayout.setOrientation(1);
        this.mRootLinearLayout.setBackgroundColor(-7829368);
        this.addView((View)this.mRootLinearLayout);
        this.createTopBar();
        this.createDivisionBar();
        this.createContentView();
        this.CreateBottonBar();
    }

    private void createTopBar() {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setId(2);
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundColor(Color.rgb((int)139, (int)189, (int)255));
        linearLayout.setGravity(17);
        float f2 = DFUtils.toSP(this.getContext(), 18.0f);
        float f3 = DFUtils.toSP(this.getContext(), 18.0f);
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        TextView textView = new TextView(this.mContext);
        textView.setId(3);
        textView.setText((CharSequence)OZAndroidResource.getResource("image.edit.cancel"));
        textView.setTextColor(-16776961);
        textView.setBackgroundColor(0);
        textView.setGravity(17);
        textView.setTextSize(2, 18.0f);
        TextView textView2 = new TextView(this.mContext);
        textView2.setId(5);
        if (this.mViewType == 0) {
            textView2.setText((CharSequence)OZAndroidResource.getResource("open.dlg.btn.edit"));
        } else if (this.mViewType == 1) {
            textView2.setText((CharSequence)OZAndroidResource.getResource("image.merge.title"));
        }
        textView2.setBackgroundColor(0);
        textView2.setGravity(17);
        textView2.setTextSize(2, 18.0f);
        TextView textView3 = new TextView(this.mContext);
        textView3.setId(4);
        textView3.setText((CharSequence)OZAndroidResource.getResource("image.edit.done"));
        textView3.setTextColor(-16776961);
        textView3.setBackgroundColor(0);
        textView3.setGravity(17);
        textView3.setTextSize(2, 18.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
        layoutParams.setMargins(n, 0, 0, 0);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -1);
        layoutParams2.setMargins(0, 0, n, 0);
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        linearLayout.addView((View)textView3, (ViewGroup.LayoutParams)layoutParams2);
        this.mRootLinearLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, DFUtils.toDP(this.mContext, 40.0f)));
    }

    private void createDivisionBar() {
        int n = DFUtils.toDP(this.mContext, 10.0f);
        int n2 = DFUtils.toDP(this.mContext, 45.0f);
        int n3 = DFUtils.toDP(this.mContext, 3.0f);
        int n4 = DFUtils.toDP(this.mContext, 60.0f) - n3;
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setId(6);
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundColor(-3355444);
        linearLayout.setGravity(80);
        LinearLayout linearLayout2 = new LinearLayout(this.mContext);
        linearLayout2.setOrientation(0);
        linearLayout2.setGravity(81);
        ImageView imageView = new ImageView(this.mContext);
        imageView.setId(7);
        imageView.setMinimumWidth(n2);
        imageView.setMinimumHeight(n2);
        imageView.setMaxWidth(n4);
        imageView.setMaxHeight(n4);
        if (this.mIsVertical) {
            imageView.setBackground(this.getImageSelectorDrawable(this.mContext, "icon_2_hori_enable.png", "icon_2_hori_disable.png"));
        } else {
            imageView.setBackground(this.getImageSelectorDrawable(this.mContext, "icon_2_vert_enable.png", "icon_2_vert_disable.png"));
        }
        ImageView imageView2 = new ImageView(this.mContext);
        imageView2.setId(8);
        imageView2.setMinimumWidth(n2);
        imageView2.setMinimumHeight(n2);
        imageView2.setMaxWidth(n4);
        imageView2.setMaxHeight(n4);
        imageView2.setBackground(this.getImageSelectorDrawable(this.mContext, "icon_4_enable.png", "icon_4_disable.png"));
        linearLayout2.addView((View)imageView, (ViewGroup.LayoutParams)this.getIconLayoutParam(n, 0, n, 0));
        linearLayout2.addView((View)imageView2, (ViewGroup.LayoutParams)this.getIconLayoutParam(n, 0, n, 0));
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, n4));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, DFUtils.toDP(this.mContext, 60.0f));
        this.mRootLinearLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    private void createContentView() {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setId(9);
        linearLayout.setOrientation(1);
        linearLayout.setBackgroundColor(-3355444);
        linearLayout.setGravity(17);
        ImageMergeFrameLayout imageMergeFrameLayout = new ImageMergeFrameLayout(this.mContext);
        imageMergeFrameLayout.setId(10);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        ImageMergeFrameLayout imageMergeFrameLayout2 = new ImageMergeFrameLayout(this.getContext());
        imageMergeFrameLayout2.setId(11);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-1, -1);
        imageMergeFrameLayout.addView((View)imageMergeFrameLayout2, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout.addView((View)imageMergeFrameLayout, (ViewGroup.LayoutParams)layoutParams);
        this.mRootLinearLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
    }

    private void CreateBottonBar() {
        int n = DFUtils.toDP(this.mContext, 7.0f);
        int n2 = DFUtils.toDP(this.mContext, 10.0f);
        int n3 = DFUtils.toDP(this.mContext, 60.0f);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setId(13);
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundColor(-1);
        linearLayout.setGravity(17);
        ImageView imageView = new ImageView(this.mContext);
        imageView.setId(14);
        imageView.setMinimumWidth(n3);
        imageView.setMinimumHeight(n3);
        imageView.setImageDrawable(this.getImageSelectorDrawable(this.mContext, "icon_rotate_left@2x.png"));
        ImageView imageView2 = new ImageView(this.mContext);
        imageView2.setId(15);
        imageView2.setMinimumWidth(n3);
        imageView2.setMinimumHeight(n3);
        imageView2.setImageDrawable(this.getImageSelectorDrawable(this.mContext, "icon_rotate_right@2x.png"));
        ImageView imageView3 = new ImageView(this.mContext);
        imageView3.setId(16);
        imageView3.setMinimumWidth(n3);
        imageView3.setMinimumHeight(n3);
        imageView3.setImageDrawable(this.getImageSelectorDrawable(this.mContext, "icon_aspectfit_enable@2x.png"));
        ImageView imageView4 = new ImageView(this.mContext);
        imageView4.setId(17);
        imageView4.setMinimumWidth(n3);
        imageView4.setMinimumHeight(n3);
        imageView4.setImageDrawable(this.getImageSelectorDrawable(this.mContext, "icon_aspectfill_enable@2x.png"));
        ImageView imageView5 = new ImageView(this.mContext);
        imageView5.setId(18);
        imageView5.setMinimumWidth(n3);
        imageView5.setMinimumHeight(n3);
        imageView5.setImageDrawable(this.getImageSelectorDrawable(this.mContext, "icon_remove@2x.png"));
        LinearLayout linearLayout2 = new LinearLayout(this.mContext);
        linearLayout2.addView((View)imageView, (ViewGroup.LayoutParams)this.getIconLayoutParam(n3, n3, n, n2, n, n2, 1));
        linearLayout2.addView((View)imageView2, (ViewGroup.LayoutParams)this.getIconLayoutParam(n3, n3, n, n2, n, n2, 1));
        linearLayout2.addView((View)imageView3, (ViewGroup.LayoutParams)this.getIconLayoutParam(n3, n3, n, n2, n, n2, 1));
        linearLayout2.addView((View)imageView4, (ViewGroup.LayoutParams)this.getIconLayoutParam(n3, n3, n, n2, n, n2, 1));
        linearLayout2.addView((View)imageView5, (ViewGroup.LayoutParams)this.getIconLayoutParam(n3, n3, n, n2, n, n2, 1));
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, DFUtils.toDP(this.mContext, 80.0f)));
        this.mRootLinearLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, DFUtils.toDP(this.mContext, 80.0f)));
    }

    public static BitmapDrawable getImageBitmapDrawable(Context context, String string) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)ImageMergeView.getImageDrawable(context, string);
        bitmapDrawable.getBitmap().setDensity(180);
        return bitmapDrawable;
    }

    public static Drawable getImageDrawable(Context context, String string) {
        Drawable drawable2 = null;
        try {
            drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open("resource/" + string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return drawable2;
    }

    private Drawable getImageSelectorDrawable(Context context, String string) {
        BitmapDrawable bitmapDrawable = ImageMergeView.getImageBitmapDrawable(this.mContext, string);
        BitmapDrawable bitmapDrawable2 = ImageMergeView.getImageBitmapDrawable(this.mContext, string);
        bitmapDrawable2.setTint(Color.argb((int)255, (int)119, (int)119, (int)119));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)bitmapDrawable2);
        stateListDrawable.addState(new int[]{16842908}, (Drawable)bitmapDrawable2);
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)bitmapDrawable2);
        stateListDrawable.addState(new int[0], (Drawable)bitmapDrawable);
        return stateListDrawable;
    }

    private Drawable getImageSelectorDrawable(Context context, String string, String string2) {
        BitmapDrawable bitmapDrawable = ImageMergeView.getImageBitmapDrawable(this.mContext, string);
        BitmapDrawable bitmapDrawable2 = ImageMergeView.getImageBitmapDrawable(this.mContext, string2);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)bitmapDrawable);
        stateListDrawable.addState(new int[]{16842908}, (Drawable)bitmapDrawable);
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)bitmapDrawable);
        stateListDrawable.addState(new int[0], (Drawable)bitmapDrawable2);
        return stateListDrawable;
    }

    private LinearLayout.LayoutParams getIconLayoutParam(int n, int n2, int n3, int n4) {
        return this.getIconLayoutParam(-2, -2, n, n2, n3, n4, 0);
    }

    private LinearLayout.LayoutParams getIconLayoutParam(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n, n2, (float)n7);
        layoutParams.setMargins(n3, n4, n5, n6);
        return layoutParams;
    }
}

