/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.keyframe;

import android.graphics.Matrix;
import android.graphics.PointF;
import java.util.Collections;
import oz.lottie.LottieProperty;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.FloatKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.animatable.AnimatableTransform;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.value.Keyframe;
import oz.lottie.value.LottieValueCallback;
import oz.lottie.value.ScaleXY;

public class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final Matrix skewMatrix1;
    private final Matrix skewMatrix2;
    private final Matrix skewMatrix3;
    private final float[] skewValues;
    private BaseKeyframeAnimation anchorPoint;
    private BaseKeyframeAnimation position;
    private BaseKeyframeAnimation scale;
    private BaseKeyframeAnimation rotation;
    private BaseKeyframeAnimation opacity;
    private FloatKeyframeAnimation skew;
    private FloatKeyframeAnimation skewAngle;
    private BaseKeyframeAnimation startOpacity;
    private BaseKeyframeAnimation endOpacity;

    public TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint() == null ? null : animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition() == null ? null : animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale() == null ? null : animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation() == null ? null : animatableTransform.getRotation().createAnimation();
        FloatKeyframeAnimation floatKeyframeAnimation = this.skew = animatableTransform.getSkew() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkew().createAnimation();
        if (this.skew != null) {
            this.skewMatrix1 = new Matrix();
            this.skewMatrix2 = new Matrix();
            this.skewMatrix3 = new Matrix();
            this.skewValues = new float[9];
        } else {
            this.skewMatrix1 = null;
            this.skewMatrix2 = null;
            this.skewMatrix3 = null;
            this.skewValues = null;
        }
        FloatKeyframeAnimation floatKeyframeAnimation2 = this.skewAngle = animatableTransform.getSkewAngle() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkewAngle().createAnimation();
        if (animatableTransform.getOpacity() != null) {
            this.opacity = animatableTransform.getOpacity().createAnimation();
        }
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    public void addAnimationsToLayer(BaseLayer baseLayer) {
        baseLayer.addAnimation(this.opacity);
        baseLayer.addAnimation(this.startOpacity);
        baseLayer.addAnimation(this.endOpacity);
        baseLayer.addAnimation(this.anchorPoint);
        baseLayer.addAnimation(this.position);
        baseLayer.addAnimation(this.scale);
        baseLayer.addAnimation(this.rotation);
        baseLayer.addAnimation(this.skew);
        baseLayer.addAnimation(this.skewAngle);
    }

    public void addListener(BaseKeyframeAnimation$AnimationListener baseKeyframeAnimation$AnimationListener) {
        if (this.opacity != null) {
            this.opacity.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.position != null) {
            this.position.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.scale != null) {
            this.scale.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.rotation != null) {
            this.rotation.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.skew != null) {
            this.skew.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
        if (this.skewAngle != null) {
            this.skewAngle.addUpdateListener(baseKeyframeAnimation$AnimationListener);
        }
    }

    public void setProgress(float f2) {
        if (this.opacity != null) {
            this.opacity.setProgress(f2);
        }
        if (this.startOpacity != null) {
            this.startOpacity.setProgress(f2);
        }
        if (this.endOpacity != null) {
            this.endOpacity.setProgress(f2);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.setProgress(f2);
        }
        if (this.position != null) {
            this.position.setProgress(f2);
        }
        if (this.scale != null) {
            this.scale.setProgress(f2);
        }
        if (this.rotation != null) {
            this.rotation.setProgress(f2);
        }
        if (this.skew != null) {
            this.skew.setProgress(f2);
        }
        if (this.skewAngle != null) {
            this.skewAngle.setProgress(f2);
        }
    }

    public BaseKeyframeAnimation getOpacity() {
        return this.opacity;
    }

    public BaseKeyframeAnimation getStartOpacity() {
        return this.startOpacity;
    }

    public BaseKeyframeAnimation getEndOpacity() {
        return this.endOpacity;
    }

    public Matrix getMatrix() {
        float f2;
        Object object;
        this.matrix.reset();
        if (this.position != null) {
            object = (PointF)this.position.getValue();
            if (((PointF)object).x != 0.0f || ((PointF)object).y != 0.0f) {
                this.matrix.preTranslate(((PointF)object).x, ((PointF)object).y);
            }
        }
        if (this.rotation != null && (f2 = this.rotation instanceof ValueCallbackKeyframeAnimation ? ((Float)this.rotation.getValue()).floatValue() : ((FloatKeyframeAnimation)this.rotation).getFloatValue()) != 0.0f) {
            this.matrix.preRotate(f2);
        }
        if (this.skew != null) {
            float f3 = this.skewAngle == null ? 0.0f : (float)Math.cos(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float f4 = this.skewAngle == null ? 1.0f : (float)Math.sin(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float f5 = (float)Math.tan(Math.toRadians(this.skew.getFloatValue()));
            this.clearSkewValues();
            this.skewValues[0] = f3;
            this.skewValues[1] = f4;
            this.skewValues[3] = -f4;
            this.skewValues[4] = f3;
            this.skewValues[8] = 1.0f;
            this.skewMatrix1.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = 1.0f;
            this.skewValues[3] = f5;
            this.skewValues[4] = 1.0f;
            this.skewValues[8] = 1.0f;
            this.skewMatrix2.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = f3;
            this.skewValues[1] = -f4;
            this.skewValues[3] = f4;
            this.skewValues[4] = f3;
            this.skewValues[8] = 1.0f;
            this.skewMatrix3.setValues(this.skewValues);
            this.skewMatrix2.preConcat(this.skewMatrix1);
            this.skewMatrix3.preConcat(this.skewMatrix2);
            this.matrix.preConcat(this.skewMatrix3);
        }
        if (this.scale != null && (((ScaleXY)(object = (ScaleXY)this.scale.getValue())).getScaleX() != 1.0f || ((ScaleXY)object).getScaleY() != 1.0f)) {
            this.matrix.preScale(((ScaleXY)object).getScaleX(), ((ScaleXY)object).getScaleY());
        }
        if (this.anchorPoint != null) {
            object = (PointF)this.anchorPoint.getValue();
            if (((PointF)object).x != 0.0f || ((PointF)object).y != 0.0f) {
                this.matrix.preTranslate(-((PointF)object).x, -((PointF)object).y);
            }
        }
        return this.matrix;
    }

    private void clearSkewValues() {
        int n = 0;
        while (n < 9) {
            this.skewValues[n] = 0.0f;
            ++n;
        }
    }

    public Matrix getMatrixForRepeater(float f2) {
        PointF pointF = this.position == null ? null : (PointF)this.position.getValue();
        ScaleXY scaleXY = this.scale == null ? null : (ScaleXY)this.scale.getValue();
        this.matrix.reset();
        if (pointF != null) {
            this.matrix.preTranslate(pointF.x * f2, pointF.y * f2);
        }
        if (scaleXY != null) {
            this.matrix.preScale((float)Math.pow(scaleXY.getScaleX(), f2), (float)Math.pow(scaleXY.getScaleY(), f2));
        }
        if (this.rotation != null) {
            float f3 = ((Float)this.rotation.getValue()).floatValue();
            PointF pointF2 = this.anchorPoint == null ? null : (PointF)this.anchorPoint.getValue();
            this.matrix.preRotate(f3 * f2, pointF2 == null ? 0.0f : pointF2.x, pointF2 == null ? 0.0f : pointF2.y);
        }
        return this.matrix;
    }

    public boolean applyValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (object == LottieProperty.TRANSFORM_ANCHOR_POINT) {
            if (this.anchorPoint == null) {
                this.anchorPoint = new ValueCallbackKeyframeAnimation(lottieValueCallback, new PointF());
            } else {
                this.anchorPoint.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_POSITION) {
            if (this.position == null) {
                this.position = new ValueCallbackKeyframeAnimation(lottieValueCallback, new PointF());
            } else {
                this.position.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_SCALE) {
            if (this.scale == null) {
                this.scale = new ValueCallbackKeyframeAnimation(lottieValueCallback, new ScaleXY());
            } else {
                this.scale.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_ROTATION) {
            if (this.rotation == null) {
                this.rotation = new ValueCallbackKeyframeAnimation(lottieValueCallback, Float.valueOf(0.0f));
            } else {
                this.rotation.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_OPACITY) {
            if (this.opacity == null) {
                this.opacity = new ValueCallbackKeyframeAnimation(lottieValueCallback, 100);
            } else {
                this.opacity.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_START_OPACITY && this.startOpacity != null) {
            if (this.startOpacity == null) {
                this.startOpacity = new ValueCallbackKeyframeAnimation(lottieValueCallback, 100);
            } else {
                this.startOpacity.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_END_OPACITY && this.endOpacity != null) {
            if (this.endOpacity == null) {
                this.endOpacity = new ValueCallbackKeyframeAnimation(lottieValueCallback, 100);
            } else {
                this.endOpacity.setValueCallback(lottieValueCallback);
            }
        } else if (object == LottieProperty.TRANSFORM_SKEW && this.skew != null) {
            if (this.skew == null) {
                this.skew = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe(Float.valueOf(0.0f))));
            }
            this.skew.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.TRANSFORM_SKEW_ANGLE && this.skewAngle != null) {
            if (this.skewAngle == null) {
                this.skewAngle = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe(Float.valueOf(0.0f))));
            }
            this.skewAngle.setValueCallback(lottieValueCallback);
        } else {
            return false;
        }
        return true;
    }
}

