/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oz.main.MainFrameView;
import oz.main.OZFileBrowser$1;
import oz.main.OZFileBrowserListView;
import oz.main.OZFileInfo;
import oz.viewer.ui.dlg.OZUtilView;

public class OZFileBrowser
extends FrameLayout {
    public String fileBrowserPath = "/";
    int WIDTHSIZE = 400;
    LinearLayout browserLayout;
    LinearLayout ll = null;
    EditText et1 = null;
    ImageButton backBtn = null;
    Context m_context;
    MainFrameView mFrameView;

    public OZFileBrowser(Context context, MainFrameView mainFrameView, String string) {
        super(context);
        this.m_context = context;
        this.fileBrowserPath = string;
        this.mFrameView = mainFrameView;
        this.browserLayout = new LinearLayout(context);
        this.browserLayout.setBackgroundColor(-1);
        this.browserLayout.setOrientation(1);
        this.addTopView(this.m_context, (ViewGroup)this.browserLayout);
        this.browserLayout.addView((View)this.centerView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.8f));
        this.addView((View)this.browserLayout);
    }

    private void addTopView(Context context, ViewGroup viewGroup) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setBackgroundColor(-7829368);
        linearLayout.setGravity(16);
        viewGroup.addView((View)linearLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.backBtn = new ImageButton(this.m_context);
        OZUtilView.setBackGround(this.backBtn, "resource/bt_up@2x.png");
        this.setBackButtonEnable();
        this.backBtn.setOnTouchListener((View.OnTouchListener)new OZFileBrowser$1(this));
        this.et1 = new EditText(this.m_context);
        this.et1.setFocusable(false);
        this.et1.setFocusableInTouchMode(false);
        this.et1.setBackgroundResource(17301529);
        this.et1.setText((CharSequence)this.fileBrowserPath);
        this.et1.setTextColor(-12303292);
        linearLayout.addView((View)this.backBtn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        linearLayout.addView((View)this.et1, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        TextView textView = new TextView(context);
        textView.setBackgroundColor(-1);
        viewGroup.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
    }

    public void refresh() {
        this.browserLayout.removeView((View)this.ll);
        this.ll.removeAllViews();
        this.browserLayout.addView((View)this.centerView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.8f));
        this.setBackButtonEnable();
    }

    public boolean prev() {
        String string = this.fileBrowserPath;
        int n = string.lastIndexOf("/");
        this.fileBrowserPath = n > 0 ? string.substring(0, n) : "/";
        this.et1.setText((CharSequence)this.fileBrowserPath);
        this.refresh();
        return true;
    }

    public ArrayList getFileList() {
        File file;
        int n;
        ArrayList<OZFileInfo> arrayList = new ArrayList<OZFileInfo>();
        File file2 = new File(this.fileBrowserPath);
        Object[] objectArray = file2.list();
        if (objectArray == null || objectArray.length == 0) {
            return arrayList;
        }
        File[] fileArray = file2.listFiles();
        Arrays.sort(objectArray);
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (int j = 0; j < fileArray.length; ++j) {
            hashMap.put(fileArray[j].getName(), fileArray[j]);
        }
        OZFileInfo oZFileInfo = null;
        for (n = 0; n < objectArray.length; ++n) {
            oZFileInfo = null;
            file = (File)hashMap.get(objectArray[n]);
            if (file == null || !file.isDirectory()) continue;
            oZFileInfo = new OZFileInfo(file.getName(), file.getAbsolutePath(), file.isDirectory());
            arrayList.add(oZFileInfo);
        }
        for (n = 0; n < objectArray.length; ++n) {
            oZFileInfo = null;
            file = (File)hashMap.get(objectArray[n]);
            if (file == null || file.isDirectory() || !file.getName().toLowerCase().endsWith(".ozd")) continue;
            oZFileInfo = new OZFileInfo(file.getName(), file.getAbsolutePath(), file.isDirectory());
            arrayList.add(oZFileInfo);
        }
        return arrayList;
    }

    private ViewGroup centerView() {
        this.ll = new LinearLayout(this.m_context);
        this.ll.setId(111);
        this.ll.setOrientation(1);
        this.ll.setBackgroundColor(-1);
        OZFileBrowserListView oZFileBrowserListView = new OZFileBrowserListView(this.m_context, this);
        oZFileBrowserListView.setData(this.getFileList());
        this.ll.addView((View)oZFileBrowserListView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.8f));
        TextView textView = new TextView(this.m_context);
        textView.setBackgroundColor(Color.rgb((int)66, (int)69, (int)74));
        this.ll.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        return this.ll;
    }

    private void setBackButtonEnable() {
        if ("/".equalsIgnoreCase(this.fileBrowserPath)) {
            this.backBtn.setEnabled(false);
        } else {
            this.backBtn.setEnabled(true);
        }
    }
}

