/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import oz.client.shape.ui.ICEditWnd;
import oz.main.OZNFCActivity$1;
import oz.main.OZNFCActivity$2;
import oz.main.OZNFCActivity$3;
import oz.main.OZNFCActivity$4;
import oz.main.OZNFCActivity$5;
import oz.main.OZNFCActivity$6;
import oz.main.OZStorage;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.dlg.OZLinearLayout;

public class OZNFCActivity
extends Activity {
    private static final String BG_SCAN_PATH = "resource/nfc.png";
    private static final String TEXT_SCAN_SCANNING = "nfc.scan.scanning";
    private static final String TEXT_SCAN_COMPLETE = "nfc.scan.complete";
    private static final String TEXT_ERROR_DISABLED = "nfc.error.disabled";
    private static final String TEXT_ERROR_NOT_SUPPORTED = "nfc.error.not_supported";
    public static boolean DEBUG = false;
    private ICEditWnd mRealWnd;
    private ICEditWnd mDummyWnd;
    private NfcAdapter mNfcAdapter;
    private PendingIntent mNfcPendingIntent;
    private IntentFilter[] mNfcTagFilters;
    private TextView mResultTextView;
    private JSONObject mResult;
    private boolean mIsWait;
    private boolean mIsNFCEnable;
    private Dialog mDialog;
    private LinearLayout mScanLayout;
    private LinearLayout mResultLayout;
    private Object mNFCLock = new Object();
    private boolean mIsClosed;

    private void closeActivity() {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            if (this.mRealWnd != null) {
                this.mRealWnd.NFCDispose();
            }
            this.finish();
        }
    }

    private boolean hasPermission(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 4096);
                if (packageInfo.requestedPermissions == null) break block3;
                for (String string2 : packageInfo.requestedPermissions) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView((View)new LinearLayout((Context)this));
        String string = null;
        if (this.getIntent() != null) {
            this.mDummyWnd = new ICEditWnd((Context)this);
            if (!this.mDummyWnd.setAttributesFromIntent(this.getIntent())) {
                this.mDummyWnd = null;
            }
            this.mRealWnd = ICEditWnd.getRequesterWnd(this.getIntent().getStringExtra("validation"));
        }
        if (!this.hasPermission("android.permission.NFC")) {
            string = "NFC permission denied";
            Log.e((String)"OZViewer", (String)"NFC permission denied, Check your AndroidManifest.xml");
        }
        if (this.mDummyWnd == null) {
            string = "Invalid access";
        } else if (string == null) {
            if (this.mRealWnd == null) {
                string = "Can not find component";
            } else {
                boolean bl = OZStorage.isSmallDevice((Context)this);
                float f2 = bl ? 0.6f : 1.0f;
                int n = OZStorage.DpToPx((Context)this, 320.0f * f2, true, true, true);
                int n2 = OZStorage.DpToPx((Context)this, 320.0f * f2, false, true, true);
                LinearLayout linearLayout = new LinearLayout((Context)this);
                linearLayout.setBackgroundColor(Color.rgb((int)0, (int)114, (int)194));
                linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n2));
                linearLayout.setOrientation(1);
                View view = new View((Context)this);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, (int)((float)OZStorage.padding_20 * f2));
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                linearLayout.addView(view);
                this.mScanLayout = new LinearLayout((Context)this);
                this.mScanLayout.setOrientation(1);
                linearLayout.addView((View)this.mScanLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
                LinearLayout linearLayout2 = new LinearLayout((Context)this);
                linearLayout2.setGravity(17);
                layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mScanLayout.addView((View)linearLayout2);
                ImageView imageView = new ImageView((Context)this);
                this.setImageViewAssetDrawable(imageView, BG_SCAN_PATH);
                layoutParams = new LinearLayout.LayoutParams(OZStorage.DpToPx((Context)this, 160.0f * f2, true), OZStorage.DpToPx((Context)this, 160.0f * f2, false));
                layoutParams.leftMargin = (int)((float)(OZStorage.padding_20 * 2) * f2);
                layoutParams.bottomMargin = (int)((float)OZStorage.padding_10 * f2);
                imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                linearLayout2.addView((View)imageView);
                TextView textView = new TextView((Context)this);
                textView.setGravity(17);
                textView.setText((CharSequence)OZAndroidResource.getResource(TEXT_SCAN_SCANNING));
                textView.setTextColor(-1);
                textView.setTextSize(2, 24.0f * f2);
                textView.setSingleLine();
                layoutParams = new LinearLayout.LayoutParams(-1, -2);
                layoutParams.bottomMargin = (int)((float)OZStorage.padding_20 * f2);
                textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mScanLayout.addView((View)textView);
                this.mResultLayout = new LinearLayout((Context)this);
                this.mResultLayout.setOrientation(1);
                this.mResultLayout.setVisibility(8);
                linearLayout.addView((View)this.mResultLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
                View view2 = new View((Context)this);
                layoutParams = new LinearLayout.LayoutParams(-1, (int)((float)OZStorage.padding_20 * f2));
                view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                linearLayout.addView(view2);
                TextView textView2 = new TextView((Context)this);
                textView2.setGravity(17);
                textView2.setText((CharSequence)OZAndroidResource.getResource(TEXT_SCAN_COMPLETE));
                textView2.setTextColor(-1);
                textView2.setTextSize(2, 24.0f * f2);
                textView2.setSingleLine();
                layoutParams = new LinearLayout.LayoutParams(-1, -2);
                textView2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mResultLayout.addView((View)textView2);
                View view3 = new View((Context)this);
                layoutParams = new LinearLayout.LayoutParams(-1, (int)((float)OZStorage.padding_20 * f2));
                view3.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mResultLayout.addView(view3);
                OZLinearLayout oZLinearLayout = new OZLinearLayout((Context)this);
                oZLinearLayout.setOrientation(1);
                layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                layoutParams.leftMargin = (int)((float)OZStorage.padding_20 * f2);
                layoutParams.rightMargin = (int)((float)OZStorage.padding_20 * f2);
                oZLinearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mResultLayout.addView((View)oZLinearLayout);
                this.mResultTextView = new TextView((Context)this);
                this.mResultTextView.setTextColor(-16777216);
                this.mResultTextView.setTextSize(2, 20.0f * f2);
                this.mResultTextView.setPadding(OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10, OZStorage.padding_10);
                this.mResultTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                this.mResultTextView.setSingleLine(false);
                this.mResultTextView.setImeOptions(0x40000000);
                ScrollView scrollView = new ScrollView((Context)this);
                scrollView.addView((View)this.mResultTextView);
                layoutParams = new LinearLayout.LayoutParams(-1, -1);
                scrollView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                oZLinearLayout.addView((View)scrollView);
                this.mDialog = this.mDummyWnd.openNFCDialog((View)linearLayout, n, n2, new OZNFCActivity$1(this), new OZNFCActivity$2(this), new OZNFCActivity$3(this), new OZNFCActivity$4(this), new OZNFCActivity$5(this));
            }
        }
        if (string != null) {
            if (DEBUG) {
                Toast.makeText((Context)this, (CharSequence)string, (int)0).show();
            }
            this.closeActivity();
        } else {
            new Handler().postDelayed((Runnable)new OZNFCActivity$6(this), 500L);
        }
    }

    private void scanStart() {
        if (this.initNFC()) {
            this.mIsWait = true;
            this.mScanLayout.setVisibility(0);
            this.mResultLayout.setVisibility(8);
            this.mResultTextView.setText((CharSequence)"");
            this.startNFC();
        }
    }

    private void scanStop() {
        this.mIsWait = false;
        try {
            this.mDialog.findViewById(65534).setVisibility(0);
            this.mScanLayout.setVisibility(8);
            this.mResultLayout.setVisibility(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopNFC() {
        if (this.mNfcAdapter != null && this.mIsNFCEnable) {
            try {
                this.mNfcAdapter.disableForegroundDispatch((Activity)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIsNFCEnable = false;
        }
    }

    private void startNFC() {
        if (this.initNFC() && this.mNfcAdapter != null) {
            this.mResult = new JSONObject();
            try {
                this.mNfcAdapter.enableForegroundDispatch((Activity)this, this.mNfcPendingIntent, this.mNfcTagFilters, (String[][])null);
                this.mIsNFCEnable = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean initNFC() {
        boolean bl = false;
        if (this.mNfcAdapter == null) {
            this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        }
        if (this.mNfcAdapter != null) {
            if (this.mNfcPendingIntent == null) {
                int n = 0x2000000;
                this.mNfcPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)n);
                IntentFilter intentFilter = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
                intentFilter.addAction("android.nfc.action.TAG_DISCOVERED");
                IntentFilter intentFilter2 = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
                try {
                    intentFilter2.addAction("android.nfc.action.TAG_DISCOVERED");
                    intentFilter2.addDataType("*/*");
                }
                catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                    malformedMimeTypeException.printStackTrace();
                }
                this.mNfcTagFilters = new IntentFilter[]{intentFilter, intentFilter2};
            }
            if (!this.mNfcAdapter.isEnabled()) {
                if (!this.mIsClosed) {
                    Toast.makeText((Context)this, (CharSequence)OZAndroidResource.getResource(TEXT_ERROR_DISABLED), (int)1).show();
                    Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
                    this.startActivity(intent);
                    this.closeActivity();
                }
            } else {
                bl = true;
            }
        } else if (!this.mIsClosed) {
            Toast.makeText((Context)this, (CharSequence)OZAndroidResource.getResource(TEXT_ERROR_NOT_SUPPORTED), (int)0).show();
            this.closeActivity();
        }
        return bl;
    }

    protected void onResume() {
        this.startNFC();
        super.onResume();
    }

    protected void onPause() {
        this.stopNFC();
        super.onPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Object object = this.mNFCLock;
        synchronized (object) {
            Ndef ndef;
            Tag tag;
            if (this.mIsWait && (tag = (Tag)(intent != null ? intent.getParcelableExtra("android.nfc.extra.TAG") : null)) != null && (ndef = Ndef.get((Tag)tag)) != null) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("maxsize", ndef.getMaxSize());
                    jSONObject.put("type", (Object)ndef.getType());
                    jSONObject.put("writable", ndef.isWritable());
                    jSONObject.put("canmakereadonly", ndef.canMakeReadOnly());
                    jSONObject.put("serial", (Object)OZNFCActivity.byteArrayToHexString(tag.getId()).toUpperCase());
                    this.mResult.put("info", (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                JSONArray jSONArray = new JSONArray();
                String[] stringArray = tag.getTechList();
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        jSONArray.put((Object)stringArray[j]);
                    }
                }
                JSONArray jSONArray2 = new JSONArray();
                Parcelable[] parcelableArray = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
                if (parcelableArray != null) {
                    for (int j = 0; j < parcelableArray.length; ++j) {
                        this.setReadTagData((NdefMessage)parcelableArray[j], jSONArray2);
                    }
                }
                try {
                    this.mResult.put("techlist", (Object)jSONArray);
                    this.mResult.put("ndefmessage", (Object)jSONArray2);
                    String string = this.mResult.toString();
                    String string2 = this.mRealWnd.nativeOnNFCFilter(string);
                    if (!string2.isEmpty()) {
                        Toast.makeText((Context)this, (CharSequence)string2, (int)0).show();
                    } else {
                        this.scanStop();
                        string2 = this.mRealWnd.nativeGetNFCReplaceValue();
                        this.mRealWnd.nativeOnChange(string2.isEmpty() ? string : string2);
                        if (this.mRealWnd.nativeGetNFCAutoClose()) {
                            this.closeActivity();
                        } else {
                            this.mResultTextView.setText((CharSequence)this.mRealWnd.m_original_text);
                        }
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }

    private static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        String string = new String();
        for (int j = 0; j < n; ++j) {
            string = string + Integer.toHexString(byArray[j] >> 4 & 0xF);
            string = string + Integer.toHexString(byArray[j] & 0xF);
        }
        return string;
    }

    private void setReadTagData(NdefMessage ndefMessage, JSONArray jSONArray) {
        if (ndefMessage != null) {
            NdefRecord[] ndefRecordArray;
            for (NdefRecord ndefRecord : ndefRecordArray = ndefMessage.getRecords()) {
                JSONObject jSONObject = new JSONObject();
                JSONObject jSONObject2 = new JSONObject();
                if (ndefRecord.getTnf() != 1 || !Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT) && !Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_URI)) continue;
                byte[] byArray = ndefRecord.getPayload();
                String string = "UTF-8";
                int n = 0;
                if (byArray.length > 0) {
                    string = (byArray[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
                    n = byArray[0] & 0x3F;
                }
                String string2 = "";
                try {
                    string2 = new String(ndefRecord.getPayload(), n + 1, byArray.length - n - 1, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                try {
                    jSONObject2.put("text", (Object)string2);
                    jSONObject2.put("base64", (Object)new String(Base64.encode((byte[])byArray, (int)0)));
                    jSONObject.put("payload", (Object)jSONObject2);
                    jSONObject.put("mime-type", (Object)OZNFCActivity.toMimeType(ndefRecord));
                    jSONArray.put((Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }

    private static String toMimeType(NdefRecord ndefRecord) {
        switch (ndefRecord.getTnf()) {
            case 1: {
                if (Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_TEXT)) {
                    return "text/plain";
                }
                if (!Arrays.equals(ndefRecord.getType(), NdefRecord.RTD_URI)) break;
                return "text/plain";
            }
            case 2: {
                String string = new String(ndefRecord.getType());
                return OZNFCActivity.normalizeMimeType(string);
            }
        }
        return null;
    }

    private static String normalizeMimeType(String string) {
        if (string == null) {
            return null;
        }
        int n = (string = string.trim().toLowerCase(Locale.US)).indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void setImageViewAssetDrawable(ImageView imageView, String string) {
        try {
            Drawable drawable2 = OZStorage.getDrawable(this.getResources().getAssets().open(string));
            if (drawable2 != null) {
                imageView.setImageDrawable(drawable2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    static /* synthetic */ ICEditWnd access$000(OZNFCActivity oZNFCActivity) {
        return oZNFCActivity.mRealWnd;
    }

    static /* synthetic */ void access$100(OZNFCActivity oZNFCActivity) {
        oZNFCActivity.scanStart();
    }

    static /* synthetic */ ICEditWnd access$200(OZNFCActivity oZNFCActivity) {
        return oZNFCActivity.mDummyWnd;
    }

    static /* synthetic */ void access$300(OZNFCActivity oZNFCActivity) {
        oZNFCActivity.closeActivity();
    }
}

