/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oz.client.shape.ui.ICEditWnd;
import oz.client.shape.ui.ICImagePickerWnd;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.ICVideoPlayerWnd;
import oz.client.shape.ui.OZInputComponent;
import oz.main.MainFrameView;
import oz.main.OZPageView$1;
import oz.main.OZPageView$2;
import oz.main.OZPageView$3;
import oz.main.OZPageView$4;
import oz.main.OZPageView$5;
import oz.main.OZPageView$6;
import oz.main.OZPageView$7;
import oz.main.OZPageView$8;
import oz.main.OZPageView$OZGestureListener;
import oz.main.OZPageView$OZInputComponentBitmapHolder;
import oz.main.OZPageView$OZScaleListener;
import oz.main.OZPageView$OnFindCompWndListener;
import oz.main.OZPageView$OnGetCompTypeListener;
import oz.main.OZPageView$OnTouchUpInsideListener;
import oz.main.OZPageView$PageViewDrawingWork;
import oz.main.OZPageView$PageViewHandler;
import oz.main.OZPageView$TimerThread;
import oz.main.OZPreviewView;
import oz.main.OZStorage;
import oz.main.VelocityDecelerator;
import oz.resource.OZAndroidResource;
import oz.util.OZPrintHelper;
import oz.viewer.ui.dlg.OZAlertMsgUI;
import oz.viewer.ui.dlg.OZSaveView;
import oz.viewer.ui.dlg.OZSaveViewFlipper;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.OZOverlayLayout;

public class OZPageView
extends FrameLayout
implements SurfaceHolder.Callback,
Runnable {
    private static final String LOG_TAG = "OZViewer";
    public static final int OZGRAPHIC_TYPE_ANDROID = 0;
    public static final int OZGRAPHIC_TYPE_SKIA = 1;
    public static boolean USE_RGB565 = false;
    private OZInputComponent _openComponent = null;
    private OZInputComponent _videoPlayingComponent = null;
    private Paint mClipPaint;
    private Paint mHighlightClipPaint;
    private MainFrameView mMainFrame;
    private AtomicBoolean isforce = new AtomicBoolean(false);
    private boolean flag_eventLock = false;
    private Thread thread;
    private OZPageView$TimerThread timer;
    private OZSaveViewFlipper svf = null;
    private OZPrintHelper helper;
    private float m_scrollX = 0.0f;
    private float m_scrollY = 0.0f;
    private float m_maxScrollX = 0.0f;
    private float m_maxScrollY = 0.0f;
    private float m_offsetX = 10.0f;
    private float m_offsetY = 10.0f;
    private float m_minScale = 0.2f;
    private float m_maxScale = 10.0f;
    private SurfaceHolder m_holder;
    private SurfaceHolder mHighlightHolder;
    private boolean mHighlightSurfaceReady;
    private boolean mHighlightSurfaceEmpty;
    private SurfaceView mViewerSurface;
    private SurfaceView mHighlightSurface;
    private OZPageView$PageViewHandler mHandler;
    SparseArray previews = new SparseArray();
    int m_previewPosition;
    int m_previewRealPosition;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mDownTouchX;
    private float mDownTouchY;
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mGestureDetector;
    private float mScaleFactor = 1.0f;
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId = -1;
    boolean isEvent = true;
    boolean isNotEvent = false;
    boolean isDragging = false;
    boolean isScrolling = false;
    boolean isExit = false;
    public Object _eventLock;
    boolean isActive = true;
    private boolean isFirst = true;
    private boolean isZooming = false;
    public boolean isDeviceRotation = false;
    public int m_screenOldWidth;
    public int m_screenOldHeight;
    public static boolean m_isHardwareAccelerated;
    public boolean m_isPrevNextBtnClicked;
    boolean m_needsDisplay = false;
    public int _isIgnoreScrollEvent = 0;
    public boolean _isSignPadAnimation = false;
    private ArrayList animationHolder = new ArrayList();
    private boolean _nowAnimation = false;
    private ViewGroup mCompWnd;
    float old_height = 0.0f;
    float old_width = 0.0f;
    float m_width;
    float m_height;
    private int m_old_height_diff;
    private int m_height_diff;
    int __canDraw = 0;
    private int m_userOffsetX;
    private int m_userOffsetY;
    private HashMap m_clipAreas = new HashMap();
    private OZInputComponent m_fullScreenComp;
    private Rect m_fullScreenClipRect;
    private boolean m_isFullScreenClip;
    boolean isSignPadAndImagePicker;
    public boolean m_isInputMode = true;
    public int m_nDragMode = -1;
    public boolean m_bEditMode = false;
    float m_position_x;
    float m_position_y;
    boolean isScrolled;
    public ICEditWnd findShowEdit;
    boolean isFling = false;
    protected VelocityTracker mVelocity;
    protected VelocityDecelerator mVelocityDecelerator;
    ImageView imageEffectView = null;
    OZPageView _this = this;
    int m_color_red = -1;
    int m_color_green = -1;
    int m_color_blue = -1;
    boolean _isAnimation = false;
    float old_px = Float.NaN;
    float old_py = Float.NaN;
    boolean isLongPress;
    boolean isButtonDown;
    float button_x;
    float button_y;
    private boolean isForceRepaintWhenIgnoreScroll = false;

    public static native int getGraphicType();

    public static native void setGraphicType(int var0);

    public static native boolean isGraphicVector();

    public static native void setGraphicVector(boolean var0);

    private native boolean nativeHasHighlight();

    private native int nativeGetHighlightDuration();

    private native void nativeUpdateCustomHighlight();

    private native void nativeSetVisibleCustomHighlight(boolean var1);

    private native void nativeSetIsZooming(boolean var1);

    public OZPageView(Context context) {
        super(context);
        this.mHandler = new OZPageView$PageViewHandler(this);
        this.mViewerSurface = new SurfaceView(this.getContext());
        this.mViewerSurface.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mHighlightSurface = new SurfaceView(this.getContext());
        this.mHighlightSurface.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mHighlightSurface.setBackgroundColor(0);
        this.mHighlightSurface.setZOrderMediaOverlay(true);
        this.mHighlightSurface.setVisibility(8);
        this.mHighlightSurfaceEmpty = true;
        if (Build.VERSION.SDK_INT >= 26) {
            this.mViewerSurface.setZOrderMediaOverlay(true);
        }
        this.addView((View)this.mHighlightSurface);
        this.addView((View)this.mViewerSurface);
        this.svf = new OZSaveViewFlipper(this.getContext());
        this.m_holder = this.mViewerSurface.getHolder();
        this.m_holder.addCallback((SurfaceHolder.Callback)this);
        this.mHighlightHolder = this.mHighlightSurface.getHolder();
        this.mHighlightHolder.addCallback((SurfaceHolder.Callback)new OZPageView$1(this));
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.setVerticalScrollBarEnabled(true);
        this.setHorizontalScrollBarEnabled(true);
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new OZPageView$OZScaleListener(this, null));
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Method method = ScaleGestureDetector.class.getMethod("setQuickScaleEnabled", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)this.mScaleDetector, false);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new OZPageView$OZGestureListener(this, null));
        this._eventLock = new Object();
        if (USE_RGB565) {
            this.m_holder.setFormat(4);
        } else {
            this.m_holder.setFormat(-2);
        }
        this.mHighlightHolder.setFormat(-2);
    }

    public MainFrameView getMainFrameView() {
        if (this.mMainFrame == null) {
            for (ViewParent viewParent = this.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
                if (!(viewParent instanceof MainFrameView)) continue;
                this.mMainFrame = (MainFrameView)viewParent;
                break;
            }
        }
        return this.mMainFrame;
    }

    public void setPreviewView(int n, OZPreviewView oZPreviewView) {
        if (oZPreviewView == null) {
            this.previews.remove(n);
            if (this.previews.size() == 0) {
                this.m_previewPosition = 0;
                this.m_previewRealPosition = 0;
            }
        } else {
            this.previews.put(n, (Object)oZPreviewView);
        }
    }

    public void setPreviewPosition(int n, int n2) {
        this.m_previewPosition = n;
        this.m_previewRealPosition = n2;
    }

    public int getPreviewRealPosition() {
        if (this.previews.size() > 0) {
            if (this.previews.get(this.m_previewPosition) != null && ((OZPreviewView)((Object)this.previews.get((int)this.m_previewPosition))).m_singleMode) {
                return this.m_previewRealPosition;
            }
            return -2;
        }
        return -2;
    }

    public void removeAllObject() {
        this.flag_eventLock = true;
        this.m_holder = null;
        this.thread = null;
        this.timer = null;
        this.svf = null;
        this.helper = null;
        this.mScaleDetector = null;
        this.mGestureDetector = null;
        this.findShowEdit = null;
    }

    public float getMinZoomSacle() {
        return this.m_minScale;
    }

    public float getMaxZoomScale() {
        return this.m_maxScale;
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    public void setZooming(boolean bl) {
        this.isZooming = bl;
    }

    public boolean isScroll() {
        if (this.isZooming) {
            return true;
        }
        return !(this.m_scrollX <= 0.0f) && !(this.m_scrollX + (float)this.getWidth() >= this.m_maxScrollX);
    }

    public void setNeedsDisplay() {
        if (!this.m_needsDisplay) {
            OZOverlayLayout oZOverlayLayout;
            this.postInvalidate();
            MainFrameView mainFrameView = this.getMainFrameView();
            if (mainFrameView != null && (oZOverlayLayout = mainFrameView.getOverlayLayout()) != null) {
                oZOverlayLayout.getScrollManager().requestUpdateView();
            }
            this.m_needsDisplay = true;
        }
    }

    public boolean isIgnoreScrollEvent() {
        return this._isIgnoreScrollEvent > 0;
    }

    public void beginIgnoreScrollEvent() {
        ++this._isIgnoreScrollEvent;
    }

    public void endIgnoreScrollEvent() {
        --this._isIgnoreScrollEvent;
        if (this._isIgnoreScrollEvent < 0) {
            this._isIgnoreScrollEvent = 0;
        }
        this.setSignPadAnimation(false);
    }

    public void setSignPadAnimation(boolean bl) {
        this._isSignPadAnimation = bl;
    }

    public void setNowAnimation(boolean bl) {
        this._nowAnimation = bl;
        if (!this._nowAnimation) {
            ArrayList arrayList = new ArrayList(this.animationHolder);
            this.animationHolder.clear();
            this.postDelayed(new OZPageView$2(this, arrayList), 100L);
        }
    }

    public boolean isNowAnimation() {
        return this._nowAnimation;
    }

    public Bitmap getNowAnimationHoldBitmap(OZInputComponent oZInputComponent) {
        OZPageView$OZInputComponentBitmapHolder oZPageView$OZInputComponentBitmapHolder = this.getNowAnimationBitmapHolder(oZInputComponent);
        if (oZPageView$OZInputComponentBitmapHolder == null) {
            return null;
        }
        return oZPageView$OZInputComponentBitmapHolder.bitmap;
    }

    private OZPageView$OZInputComponentBitmapHolder getNowAnimationBitmapHolder(OZInputComponent oZInputComponent) {
        if (oZInputComponent != null) {
            for (int j = 0; j < this.animationHolder.size(); ++j) {
                if (((OZPageView$OZInputComponentBitmapHolder)this.animationHolder.get((int)j)).comp != oZInputComponent) continue;
                return (OZPageView$OZInputComponentBitmapHolder)this.animationHolder.get(j);
            }
        }
        return null;
    }

    public void setNowAnimationHoldBitmap(OZInputComponent oZInputComponent, Bitmap bitmap) {
        if (oZInputComponent != null && bitmap != null) {
            OZPageView$OZInputComponentBitmapHolder oZPageView$OZInputComponentBitmapHolder = this.getNowAnimationBitmapHolder(oZInputComponent);
            if (oZPageView$OZInputComponentBitmapHolder == null) {
                oZPageView$OZInputComponentBitmapHolder = new OZPageView$OZInputComponentBitmapHolder(this, null);
                oZPageView$OZInputComponentBitmapHolder.comp = oZInputComponent;
                oZPageView$OZInputComponentBitmapHolder.bitmap = bitmap;
                this.animationHolder.add(oZPageView$OZInputComponentBitmapHolder);
            } else {
                if (oZPageView$OZInputComponentBitmapHolder.bitmap != null && !oZPageView$OZInputComponentBitmapHolder.bitmap.isRecycled()) {
                    oZPageView$OZInputComponentBitmapHolder.bitmap.recycle();
                }
                oZPageView$OZInputComponentBitmapHolder.bitmap = bitmap;
            }
        }
    }

    public void setAnimation(Animation animation) {
        if (animation == null) {
            this.setNowAnimation(false);
        }
        super.setAnimation(animation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this._eventLock;
        synchronized (object) {
            this.isEvent = true;
        }
        this.isDragging = false;
        this.isScrolling = false;
        this.isExit = false;
        this.isActive = true;
        this.isZooming = false;
    }

    public boolean onTouchUpInside(MotionEvent motionEvent, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.m_bEditMode || this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMode() && this.getMainFrameView().getNativeController().isOnlyDrawWithStylusPen();
        if ((bl4 || !this.nativeIsInputRender()) && this.canFindComp()) {
            OZPageView$OnTouchUpInsideListener oZPageView$OnTouchUpInsideListener = new OZPageView$OnTouchUpInsideListener(this, motionEvent, bl, bl2, bl3);
            OZPageView$OnTouchUpInsideListener.access$502(oZPageView$OnTouchUpInsideListener, bl4);
            this.findComp(oZPageView$OnTouchUpInsideListener, true);
            return oZPageView$OnTouchUpInsideListener.getResult();
        }
        return false;
    }

    private ViewGroup getCompWndParent() {
        ViewParent viewParent;
        if (this.mCompWnd == null && (viewParent = this.getParent()) != null) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            int n = viewGroup.getChildCount();
            if (n >= 3) {
                try {
                    viewGroup = (ViewGroup)viewGroup.getChildAt(3);
                }
                catch (Exception exception) {
                    viewGroup = null;
                    exception.printStackTrace();
                }
            }
            if (viewGroup != null) {
                this.mCompWnd = viewGroup;
            }
        }
        return this.mCompWnd;
    }

    public boolean canFindComp() {
        return this.getCompWndParent() != null;
    }

    private boolean findCompInternal(ViewGroup viewGroup, View view, OZPageView$OnFindCompWndListener oZPageView$OnFindCompWndListener) {
        if (view != null && view instanceof OZInputComponent && ((OZInputComponent)view).isFindable()) {
            return oZPageView$OnFindCompWndListener.OnFind(viewGroup, (OZInputComponent)view);
        }
        return false;
    }

    public void findComp(OZPageView$OnFindCompWndListener oZPageView$OnFindCompWndListener, boolean bl) {
        if (oZPageView$OnFindCompWndListener != null && this.canFindComp()) {
            ViewGroup viewGroup = this.getCompWndParent();
            oZPageView$OnFindCompWndListener.OnFindStart(viewGroup);
            int n = viewGroup.getChildCount();
            if (bl) {
                for (int j = n - 1; j >= 0 && !this.findCompInternal(viewGroup, viewGroup.getChildAt(j), oZPageView$OnFindCompWndListener); --j) {
                }
            } else {
                for (int j = 0; j < n && !this.findCompInternal(viewGroup, viewGroup.getChildAt(j), oZPageView$OnFindCompWndListener); ++j) {
                }
            }
            oZPageView$OnFindCompWndListener.OnFindEnd(viewGroup);
        } else if (oZPageView$OnFindCompWndListener != null) {
            oZPageView$OnFindCompWndListener.OnFindStart(this.getCompWndParent());
            oZPageView$OnFindCompWndListener.OnFindEnd(this.getCompWndParent());
        }
    }

    public void checkInputControl(float f2, float f3, View view) {
        if (this.canFindComp()) {
            this.findComp(new OZPageView$3(this, f2, f3), false);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.init();
        if (n3 != OZStorage.m_height || n2 != OZStorage.m_width) {
            OZStorage.m_height = n3;
            OZStorage.m_width = n2;
            DisplayMetrics displayMetrics = OZStorage.getDisplayMetrics(this.getContext());
            OZStorage.m_screenWidth = displayMetrics.widthPixels;
            OZStorage.m_screenHeight = displayMetrics.heightPixels;
            if (OZStorage.m_screenWidth != this.m_screenOldWidth && OZStorage.m_screenHeight != this.m_screenOldHeight) {
                this.isDeviceRotation = true;
                if (this.svf != null && this.svf.getSaveView() != null) {
                    this.svf.getSaveView().onConfigurationChanged();
                }
                if (this.svf != null && this.helper != null) {
                    this.helper.onConfigurationChanged();
                }
            }
            this.checkInputControl(n2, n3, (View)this);
            this.m_width = n2;
            this.m_height = n3;
            this.m_height_diff = n3;
            this.isDeviceRotation = false;
            this.m_screenOldWidth = OZStorage.m_screenWidth;
            this.m_screenOldHeight = OZStorage.m_screenHeight;
            if (this.old_height > 0.0f) {
                if (!(this.m_maxScrollY <= this.old_height)) {
                    this.m_scrollY = this.m_maxScrollY <= (float)n3 ? 0.0f : (this.m_maxScrollY - (float)n3) / (this.m_maxScrollY - this.old_height) * this.m_scrollY;
                }
                if (!(this.m_maxScrollX <= this.old_width)) {
                    this.m_scrollX = this.m_maxScrollX <= (float)n2 ? 0.0f : (this.m_maxScrollX - (float)n2) / (this.m_maxScrollX - this.old_width) * this.m_scrollX;
                }
            }
            this.nativeOnScreenChange();
            this.old_height = n3;
            this.old_width = n2;
        } else {
            this.m_width = n2;
            this.m_height = n3;
        }
        if (Build.VERSION.SDK_INT > 10) {
            m_isHardwareAccelerated = this.isHardwareAccelerated();
        }
        this.postInvalidate();
    }

    private void unbindImagePickerAndSignPadReferences() {
        if (this.canFindComp()) {
            this.findComp(new OZPageView$4(this), false);
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.d((String)LOG_TAG, (String)"contents surfaceCreated");
        try {
            if (!ICImagePickerWnd.isStartGallayForNotClosePopup) {
                this.unbindImagePickerAndSignPadReferences();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
        this.isFirst = false;
        this.thread = new Thread(this);
        this.thread.start();
        this.timer = new OZPageView$TimerThread(this, 15L);
        this.timer.start();
        this.postInvalidate();
        this.post(new OZPageView$5(this));
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (n == 4 || n == 8) {
            this.unbindImagePickerAndSignPadReferences();
        }
    }

    public void CreatePrint(boolean bl, int n, int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
        if (Build.VERSION.SDK_INT < 19) {
            MainFrameView.AlertDialog("ERROR:", OZAndroidResource.getResource("not.supported.os.msg"));
            return;
        }
        if (this.helper != null) {
            this.helper = null;
        }
        try {
            this.helper = new OZPrintHelper(this.getContext());
        }
        catch (Throwable throwable) {
            this.nativeRunErrorMessage();
        }
        if (this.helper != null) {
            try {
                int n4 = this.nativeGetPrintTotalPages();
                String string = this.nativeGetPrintJobName();
                this.helper.printDocument(this, string, n4, bl, n, n2, n3, bl2, bl3, bl4);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public native int nativeGetPrintTotalPages();

    public native String nativeGetPrintJobName();

    public native void nativeOnPrintPage(Canvas var1, int var2, int var3, int var4);

    public native void nativeOnPrintFinish();

    public native void nativeSetPrintParam(int var1, int var2, int var3, boolean var4);

    public native void nativeSetPrintPage(String var1, String var2, boolean var3);

    public native void nativeRunErrorMessage();

    public native void nativeOnCancel();

    public native boolean nativeHasInvalidImgOrScript();

    protected void onMeasure(int n, int n2) {
        if (this.findShowEdit != null && this.findShowEdit.isShow && !this.isDragging && this.m_height_diff != this.m_old_height_diff) {
            this.findShowEdit.MoveComponent();
        }
        this.m_old_height_diff = this.m_height_diff;
        super.onMeasure(n, n2);
    }

    public void onWindowFocusChanged(boolean bl) {
        if (!bl) {
            if (!(OZAlertMsgUI.alertMsgOpen || ICImagePickerWnd.isStartGallay || ICSignPadWnd.isStartSealDialog)) {
                this.unbindImagePickerAndSignPadReferences();
            }
            this._isIgnoreScrollEvent = 0;
        }
        super.onWindowFocusChanged(bl);
    }

    protected void onDetachedFromWindow() {
        this.unbindImagePickerAndSignPadReferences();
        super.onDetachedFromWindow();
    }

    protected void onWindowVisibilityChanged(int n) {
        if (!(n != 8 && n != 4 || !ICImagePickerWnd.isStartGallay && ICImagePickerWnd.isStartGallayForNotClosePopup)) {
            this.unbindImagePickerAndSignPadReferences();
        }
        super.onWindowVisibilityChanged(n);
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)LOG_TAG, (String)"contents surfaceDestroyed");
        this.mHandler.hideHighlight();
        try {
            this.isExit = true;
            this.thread.join(30000L);
            this.isFirst = true;
            if (this.timer != null) {
                this.timer.setStop();
            }
        }
        catch (Throwable throwable) {
            Log.w((String)LOG_TAG, (String)"surfaceDestroyed job exception");
            throwable.printStackTrace();
        }
    }

    public void setUserOffSetXY(int n, int n2) {
        this.m_userOffsetX = n;
        this.m_userOffsetY = n2;
    }

    public int getUserOffSetX() {
        return this.m_userOffsetX;
    }

    public int getUserOffSetY() {
        return this.m_userOffsetY;
    }

    public void setCompClip(OZInputComponent oZInputComponent, Rect rect) {
        if (rect != null) {
            this.m_clipAreas.put(oZInputComponent, rect);
        } else {
            this.m_clipAreas.remove((Object)oZInputComponent);
        }
    }

    public boolean hasCompClip() {
        return !this.m_clipAreas.isEmpty();
    }

    public boolean hasCompClip(OZInputComponent oZInputComponent) {
        return this.m_clipAreas.containsKey((Object)oZInputComponent);
    }

    public Rect getCompClipFirst() {
        List list = this.getCompClip();
        Rect rect = null;
        for (int j = 0; j < list.size(); ++j) {
            if (list.get(j) == null) continue;
            rect = (Rect)list.get(j);
            break;
        }
        return rect;
    }

    public Rect getCompClip(OZInputComponent oZInputComponent) {
        return (Rect)this.m_clipAreas.get((Object)oZInputComponent);
    }

    public List getCompClip() {
        ArrayList<Rect> arrayList = new ArrayList<Rect>();
        if (this.hasCompClip()) {
            for (Rect rect : this.m_clipAreas.values()) {
                if (rect == null) continue;
                arrayList.add(rect);
            }
        }
        return arrayList;
    }

    public void setFullScreenComp(OZInputComponent oZInputComponent, boolean bl) {
        this.m_isFullScreenClip = bl;
        if (this.m_isFullScreenClip) {
            if (this.m_fullScreenComp != null && this.m_fullScreenComp != oZInputComponent) {
                switch (oZInputComponent.getComponentType()) {
                    case 88: {
                        if (!((ICVideoPlayerWnd)this.m_fullScreenComp).isFullScreen()) break;
                        ((ICVideoPlayerWnd)this.m_fullScreenComp).toggleFullScreen();
                    }
                }
            }
            this.m_fullScreenComp = oZInputComponent;
        } else {
            this.m_fullScreenComp = null;
        }
    }

    public OZInputComponent getFullScreenComp() {
        return this.m_fullScreenComp;
    }

    private void setCanvasClip(Canvas canvas, Paint paint, boolean bl) {
        if (this.m_isFullScreenClip || this.hasCompClip() || bl && this.getOpenComponent() != null) {
            canvas.drawPaint(paint);
            if (this.m_isFullScreenClip) {
                if (this.m_fullScreenClipRect == null) {
                    this.m_fullScreenClipRect = new Rect();
                }
                this.m_fullScreenClipRect.set(0, 0, canvas.getWidth(), canvas.getHeight());
                canvas.clipRect(this.m_fullScreenClipRect);
            } else {
                Object object;
                Rect rect = new Rect();
                OZInputComponent oZInputComponent = this.getOpenComponent();
                if (bl && oZInputComponent != null) {
                    object = oZInputComponent.getCompRect();
                    rect.set((int)((RectF)object).left, (int)((RectF)object).top, (int)((RectF)object).right, (int)((RectF)object).bottom);
                    if (rect != null && !rect.isEmpty()) {
                        canvas.clipRect(rect, Region.Op.DIFFERENCE);
                    }
                }
                object = this.m_clipAreas.values().iterator();
                while (object.hasNext()) {
                    rect.set((Rect)object.next());
                    if (rect.right > canvas.getWidth()) {
                        rect.right = canvas.getWidth();
                    }
                    if (rect.bottom > canvas.getHeight()) {
                        rect.bottom = canvas.getHeight();
                    }
                    if (rect == null || rect.isEmpty()) continue;
                    canvas.clipRect(rect, Region.Op.DIFFERENCE);
                }
            }
        }
    }

    private void setCanvasTranslateAndScale(Canvas canvas, float f2, float f3, float f4, float f5, float f6) {
        float f7 = -f2 + f4;
        float f8 = -f3 + f5;
        canvas.translate(f7, f8);
        canvas.scale(f6, f6);
    }

    public void draw(Canvas canvas, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (this.previews.size() > 0 && bl) {
            return;
        }
        canvas.save();
        if (this.mClipPaint == null) {
            this.mClipPaint = new Paint();
            this.mClipPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        }
        this.setCanvasClip(canvas, this.mClipPaint, false);
        canvas.drawARGB(255, this.m_color_red, this.m_color_green, this.m_color_blue);
        canvas.save();
        this.setCanvasTranslateAndScale(canvas, f4, f5, f2, f3, f6);
        this.nativeOnDraw(canvas, this.m_previewRealPosition + 1, f6, f4, f5, f2, f3);
        this.m_needsDisplay = false;
        canvas.restore();
    }

    private void drawHighlight(Canvas canvas, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mHighlightSurfaceEmpty = bl;
        if (!bl) {
            canvas.save();
            if (this.mHighlightClipPaint == null) {
                this.mHighlightClipPaint = new Paint();
                this.mHighlightClipPaint.setAntiAlias(true);
                this.mHighlightClipPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            this.setCanvasClip(canvas, this.mHighlightClipPaint, true);
            this.nativeOnDrawHighlightLayer(canvas, -1, this.m_previewRealPosition + 1, f6, f2, f3, f4, f5, (int)(255.0f * this.mHandler.getHighlightAlpha()));
            canvas.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDraw() {
        boolean bl = false;
        Object object = this._eventLock;
        synchronized (object) {
            if (this.isNotEvent) {
                return;
            }
            bl = this.isEvent;
            this.isEvent = false;
        }
        new OZPageView$PageViewDrawingWork(this).doWork(bl);
    }

    public void run() {
        while (!this.isExit) {
            if (this.isIgnoreScrollEvent() && this._isSignPadAnimation) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isForceRepaintWhenIgnoreScroll) continue;
                this.internalDraw();
                continue;
            }
            this.internalDraw();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this._eventLock == null) {
            this._eventLock = new Object();
        }
        Object object = this._eventLock;
        synchronized (object) {
            this.isEvent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isNotInvalidate(boolean bl) {
        if (this._eventLock == null) {
            this._eventLock = new Object();
        }
        Object object = this._eventLock;
        synchronized (object) {
            this.isNotEvent = bl;
        }
    }

    public boolean isNotInvalidate() {
        return this.isNotEvent;
    }

    public void setInputMode(boolean bl) {
        this.m_isInputMode = bl;
    }

    public void setMemoDragMode(int n) {
        this.m_nDragMode = n;
    }

    public void setEditMode(boolean bl) {
        this.m_bEditMode = bl;
    }

    private boolean isMovedBeyondDP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Math.abs(f2 - f4) > (float)OZStorage.DpToPx(this.getContext(), 5.0f, true) || Math.abs(f3 - f5) > (float)OZStorage.DpToPx(this.getContext(), 5.0f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = this.getMainFrameView().getOverlayLayout().getNativeController().isOnlyDrawWithStylusPen();
        boolean bl2 = OZStorage.checkUsingStylusPen(motionEvent);
        if ((motionEvent.getAction() == 0 || motionEvent.getAction() == 2 || motionEvent.getAction() == 1) && this.m_nDragMode != 0 && this.m_nDragMode != 1) {
            this.m_position_x = motionEvent.getX();
            this.m_position_y = motionEvent.getY();
        }
        SurfaceHolder surfaceHolder = this.m_holder;
        synchronized (surfaceHolder) {
            Object object = this._eventLock;
            synchronized (object) {
                if (!this.isActive) {
                    return true;
                }
                if (this.isIgnoreScrollEvent()) {
                    return true;
                }
                this.nativeReadyHandWrite();
                if (this.m_nDragMode == 0 || this.m_nDragMode == 1) {
                    if (motionEvent.getAction() == 2) {
                        this.nativeOnDragMemoLabel(this.m_nDragMode, motionEvent.getX(), motionEvent.getY());
                    } else if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
                        this.setInputMode(true);
                        this.nativeOnUpdateMemoLabel(this.m_nDragMode);
                        this.getMainFrameView().getOverlayLayout().getCommentManager().getBaseView().getBottomBar().setModeBackground();
                        this.m_nDragMode = -1;
                    }
                    return true;
                }
                if (this.getMainFrameView() != null && this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentNormalMode() && motionEvent.getPointerCount() != 2 && motionEvent.getAction() == 2 && !bl) {
                    return true;
                }
                int n = motionEvent.getActionMasked();
                boolean bl3 = false;
                switch (n) {
                    case 0: 
                    case 2: {
                        bl3 = motionEvent.getButtonState() == 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    if (this.m_minScale != this.m_maxScale) {
                        this.mScaleDetector.onTouchEvent(motionEvent);
                    }
                    this.mGestureDetector.onTouchEvent(motionEvent);
                }
                if (!this.isZooming() && motionEvent.getPointerCount() == 1) {
                    if (this.mVelocity == null) {
                        this.mVelocity = VelocityTracker.obtain();
                    }
                    if (motionEvent.getAction() == 0) {
                        if (this.mVelocityDecelerator != null) {
                            this.mVelocityDecelerator.stop();
                        }
                        this.mVelocity.addMovement(motionEvent);
                    }
                    if (motionEvent.getAction() == 2) {
                        if (bl && bl2 && this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentNormalMode()) {
                            return true;
                        }
                        this.mVelocity.addMovement(motionEvent);
                    }
                    if (motionEvent.getAction() == 1) {
                        this.mVelocity.addMovement(motionEvent);
                        this.mVelocity.computeCurrentVelocity(1);
                        if (this.mVelocityDecelerator == null) {
                            this.mVelocityDecelerator = new VelocityDecelerator(this.mVelocity.getXVelocity(), this.mVelocity.getYVelocity());
                        } else {
                            this.mVelocityDecelerator.start(this.mVelocity.getXVelocity(), this.mVelocity.getYVelocity());
                        }
                        this.mVelocity.recycle();
                        this.mVelocity = null;
                    }
                }
                switch (motionEvent.getAction() & 0xFF) {
                    case 0: {
                        if (this.timer == null) {
                            this.timer = new OZPageView$TimerThread(this, 15L);
                            this.timer.start();
                        }
                        this.timer.beginBreak();
                        this.mLastTouchX = motionEvent.getX();
                        this.mLastTouchY = motionEvent.getY();
                        this.mDownTouchX = motionEvent.getX();
                        this.mDownTouchY = motionEvent.getY();
                        this.mActivePointerId = motionEvent.getPointerId(0);
                        Object object2 = this._eventLock;
                        synchronized (object2) {
                            this.isEvent = false;
                            break;
                        }
                    }
                    case 2: {
                        int n2 = 0;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        try {
                            n2 = motionEvent.findPointerIndex(this.mActivePointerId);
                            f2 = motionEvent.getX(n2);
                            f3 = motionEvent.getY(n2);
                        }
                        catch (Exception exception) {
                            f2 = motionEvent.getX();
                            f3 = motionEvent.getY();
                        }
                        if (!this.isScrolled && !this.isIgnoreScrollEvent() && this.isMovedBeyondDP(this.mDownTouchX, this.mDownTouchY, f2, f3, 5.0f, 5.0f)) {
                            this.isScrolled = true;
                        }
                        if (!this.isScrolled) break;
                        if (!this.isDragging) {
                            if (this.mLastTouchX != f2 || this.mLastTouchY != f3) {
                                this.onBeginDragging(false);
                                this.isDragging = true;
                                this.isScrolling = true;
                                this.dragging(f2, f3);
                            }
                        } else {
                            this.dragging(f2, f3);
                        }
                        if (!this.isButtonDown) break;
                        motionEvent.setLocation(this.button_x, this.button_y);
                        this.isButtonDown = false;
                        this.onTouchUpInside(motionEvent, false, true, this.isScrolled);
                        break;
                    }
                    case 1: {
                        int n3 = -1;
                        if (!this.nativeIsInputRender()) {
                            n3 = this.getCompType(motionEvent);
                        }
                        this.mActivePointerId = -1;
                        this.timer.endBreak();
                        if (this.isScrolling) {
                            if (!this.isFling) {
                                this.onEndScroll();
                            }
                        } else if (!(this.nativeIsZoomByDoubleTap() && (!this.nativeIsZoomByDoubleTap() || !this.isLongPress || n3 != 51) || this.isScrolled || this.isLongPress && n3 != 51 || this.isZooming() || this.isIgnoreScrollEvent() || this.onTouchUpInside(motionEvent, false, false, false))) {
                            this.onSingleTap(this.m_position_x, this.m_position_y);
                        }
                        this.isScrolled = false;
                        this.isLongPress = false;
                        break;
                    }
                    case 3: {
                        this.mActivePointerId = -1;
                        break;
                    }
                    case 6: {
                        int n4 = (motionEvent.getAction() & 0xFF00) >> 8;
                        int n5 = motionEvent.getPointerId(n4);
                        if (n5 != this.mActivePointerId) break;
                        int n6 = n4 == 0 ? 1 : 0;
                        this.mLastTouchX = motionEvent.getX(n6);
                        this.mLastTouchY = motionEvent.getY(n6);
                        this.mActivePointerId = motionEvent.getPointerId(n6);
                        if (!this.isScrolling) break;
                        this.onEndScroll();
                        break;
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScroll() {
        try {
            SurfaceHolder surfaceHolder = this.m_holder;
            synchronized (surfaceHolder) {
                this.nativeOnScroll();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("nativeOnScroll error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void onBeginDragging(boolean bl) {
        try {
            this.findShowEdit();
            this.nativeOnBeginDragging(bl);
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("onBeginDragging error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void setShowEdit(ICEditWnd iCEditWnd) {
        this.findShowEdit = iCEditWnd;
    }

    private void findShowEdit() {
        this.isFling = false;
        if (this.findShowEdit != null && this.findShowEdit.getChildCount() == 1) {
            this.findShowEdit.editVisible(false);
        }
    }

    private void findCloseEdit() {
        if (this.findShowEdit != null && this.findShowEdit.getChildCount() == 1) {
            boolean bl;
            boolean bl2 = (this.findShowEdit.m_left > 0.0f || this.findShowEdit.m_right > 0.0f) && ((float)this.getWidth() - this.findShowEdit.m_left > 0.0f || (float)this.getWidth() - this.findShowEdit.m_right > 0.0f);
            boolean bl3 = bl = (this.findShowEdit.m_top > 0.0f || this.findShowEdit.m_bottom > 0.0f) && ((float)this.getHeight() - this.findShowEdit.m_top > 0.0f || (float)this.getHeight() - this.findShowEdit.m_bottom > 0.0f);
            if (bl2 && bl) {
                this.findShowEdit.editVisible(true);
                this.invalidate();
            }
        }
    }

    public void onEndScroll() {
        try {
            this.isDragging = false;
            this.isScrolling = false;
            if (this.flag_eventLock) {
                return;
            }
            this.nativeOnEndScroll();
            this.Animation();
            if (!this.isFling) {
                this.findCloseEdit();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("onEndScroll error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void onZoom(float f2, float f3) {
        try {
            this.nativeOnZoom(f2, f3);
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("onZoom error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void onBeginZoom() {
        try {
            this.nativeOnBeginZoom(this.isIgnoreScrollEvent());
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("onZoom error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void onEndZoom(boolean bl) {
        if (bl) {
            try {
                this.nativeOnEndZoom(bl);
                this.Animation();
            }
            catch (Throwable throwable) {
                Log.e((String)LOG_TAG, (String)("onZoom error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
            }
        } else {
            this.onEndZoom();
        }
    }

    public void onEndZoom() {
        try {
            this.nativeOnEndZoom(this.isIgnoreScrollEvent());
            this.Animation();
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)("onZoom error=" + throwable.getLocalizedMessage()), (Throwable)throwable);
        }
    }

    public void updatePosition() {
        if (this.mVelocityDecelerator != null && this.mVelocityDecelerator.isMoving()) {
            this.mVelocityDecelerator.calculateFreezeFrameData();
            this.m_scrollX -= (float)(Math.round(this.mVelocityDecelerator.getDeltaDistanceX()) * this.mVelocityDecelerator.getDirectionX());
            this.m_scrollY -= (float)(Math.round(this.mVelocityDecelerator.getDeltaDistanceY()) * this.mVelocityDecelerator.getDirectionY());
        }
    }

    public void onFling(float f2, float f3) {
        if (this.mVelocityDecelerator != null) {
            this.mVelocityDecelerator.start(f2, f3);
        }
        this.isFling = true;
        this.timer.setF(f2, f3);
    }

    public void setOffSet(float f2, float f3) {
        this.m_offsetX = f2;
        this.m_offsetY = f3;
        this.invalidate();
        this.Animation(true);
    }

    public float getOffSet(boolean bl) {
        if (bl) {
            return this.m_offsetX;
        }
        return this.m_offsetY;
    }

    public float getScrollPositionX() {
        return this.m_scrollX;
    }

    public void setScrollPositionX(float f2) {
        this.scrollingStop();
        this.m_scrollX = f2;
        this.setNeedsDisplay();
    }

    public float getScrollPositionY() {
        return this.m_scrollY;
    }

    public void setScrollPositionY(float f2) {
        this.scrollingStop();
        this.m_scrollY = f2;
        this.setNeedsDisplay();
    }

    public int getScreenWidthSize() {
        return (int)this.m_width;
    }

    public int getScreenHeightSize() {
        return (int)this.m_height;
    }

    public void setScrollSize(float f2, float f3) {
        this.setScrollSize(false, f2, f3);
    }

    public void setScrollSize(boolean bl, float f2, float f3) {
        if (f2 <= 0.0f || f3 <= 0.0f) {
            return;
        }
        if (bl) {
            if (!(this.m_maxScrollY <= this.m_height)) {
                this.m_scrollY = f3 <= this.m_height ? 0.0f : (f3 - this.m_height) / (this.m_maxScrollY - this.m_height) * this.m_scrollY;
            }
            if (!(this.m_maxScrollX <= this.m_width)) {
                this.m_scrollX = f2 <= this.m_width ? 0.0f : (f2 - this.m_width) / (this.m_maxScrollX - this.m_width) * this.m_scrollX;
            }
        }
        this.m_maxScrollX = f2;
        this.m_maxScrollY = f3;
        if (this.m_maxScrollX < this.getScrollPositionX()) {
            this.setScrollPositionX(this.m_maxScrollX);
        }
        if (this.m_maxScrollY < this.getScrollPositionY()) {
            this.setScrollPositionY(this.m_maxScrollY);
        }
        this.invalidate();
    }

    public float getScrollSizeX() {
        return this.m_maxScrollX;
    }

    public float getScrollSizeY() {
        return this.m_maxScrollY;
    }

    public float getZoomScale() {
        return this.mScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomScale(float f2) {
        Object object = this._eventLock;
        synchronized (object) {
            this.mScaleFactor = f2;
        }
    }

    public void setMinMaxZoomScale(float f2, float f3) {
        this.m_minScale = f2;
        this.m_maxScale = f3;
    }

    public void onSingleTap(float f2, float f3) {
        if (!this.isIgnoreScrollEvent()) {
            this.nativeOnSingleTap(f2, f3);
            this.Animation();
        }
    }

    public void onSingleTap2(float f2, float f3) {
        if (!this.isIgnoreScrollEvent()) {
            this.nativeOnSingleTap2(f2, f3);
            this.Animation();
        }
    }

    public void onDoubleTap(float f2, float f3) {
        if (!this.isIgnoreScrollEvent()) {
            if (this.nativeIsSendUserActionDoubleTap(f2, f3)) {
                this.showDoubleTapEffect(f2, f3);
                return;
            }
            this.nativeOnDoubleTap(f2, f3);
            this.Animation();
            this.onEndScroll();
        }
    }

    public void showDoubleTapEffect(float f2, float f3) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        float f4 = this.getResources().getDisplayMetrics().density;
        this.imageEffectView = new ImageView(this.getContext());
        this.imageEffectView.setImageDrawable(AOverlayUtil.getAssetIcon_Toolbar(this.imageEffectView.getContext(), "resource/dbtap_effect.png"));
        this.imageEffectView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.imageEffectView.getLayoutParams().width = (int)(10.0f * f4);
        this.imageEffectView.getLayoutParams().height = (int)(10.0f * f4);
        this.imageEffectView.setX(f2);
        this.imageEffectView.setY(f3);
        this.imageEffectView.setZ(100000.0f);
        this.addView((View)this.imageEffectView);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.imageEffectView, (String)"scaleX", (float[])new float[]{10.0f});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.imageEffectView, (String)"scaleY", (float[])new float[]{10.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)this.imageEffectView, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        objectAnimator.setDuration(300L);
        objectAnimator2.setDuration(300L);
        objectAnimator3.setDuration(300L);
        objectAnimator3.addListener((Animator.AnimatorListener)new OZPageView$6(this));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)objectAnimator).with((Animator)objectAnimator2).with((Animator)objectAnimator3);
        animatorSet.start();
    }

    public void setColor(int n) {
        this.m_color_blue = Color.red((int)n);
        this.m_color_green = Color.green((int)n);
        this.m_color_red = Color.blue((int)n);
    }

    protected native void nativeOnRelease();

    protected native void nativeOnDraw(Canvas var1, int var2, float var3, float var4, float var5, float var6, float var7);

    protected native void nativeOnDrawSkia(Surface var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, Region var11);

    protected native void nativeOnPreviewDrawSkia(Bitmap var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, Region var11);

    protected native void nativeOnPreviewMoveDrawSkia(Bitmap var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10);

    protected native boolean nativeOnDrawPage(Canvas var1, int var2);

    protected native void nativeOnDrawInputComponentSinglePage(Canvas var1, int var2, float var3, float var4, float var5, float var6, float var7);

    protected native void nativeOnDrawCommentLayer(Canvas var1, boolean var2, int var3, float var4, float var5, float var6, float var7, float var8);

    protected native void nativeOnDrawHighlightLayer(Canvas var1, int var2, int var3, float var4, float var5, float var6, float var7, float var8, int var9);

    protected native void nativeOnScroll();

    protected native void nativeOnBeginDragging(boolean var1);

    protected native void nativeOnEndScroll();

    protected native void nativeOnZoom(float var1, float var2);

    protected native void nativeOnBeginZoom(boolean var1);

    protected native void nativeOnEndZoom(boolean var1);

    private native void nativeDeselectMemoLabel();

    public void deselectMemoLabel() {
        this.nativeDeselectMemoLabel();
    }

    protected native void nativeOnSingleTap(float var1, float var2);

    protected native void nativeOnDoubleTap(float var1, float var2);

    protected native void nativeOnSingleTap2(float var1, float var2);

    protected native void nativeOnLinkShow(float var1, float var2);

    protected native void nativeOnLinkHide();

    public native void nativeOnScreenChange();

    public native void nativeOnDragMemoLabel(int var1, float var2, float var3);

    public native void nativeOnUpdateMemoLabel(int var1);

    public native int nativeIsExistEnableInputComp(float var1, float var2);

    public native boolean nativeIsInputRender();

    public native boolean nativeIsZoomByDoubleTap();

    public native void nativeOnScrollChanged();

    public native void nativeReadyHandWrite();

    private void Animation() {
        this.Animation(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Animation(boolean bl) {
        if (this.flag_eventLock) {
            return;
        }
        Object object = this._eventLock;
        synchronized (object) {
            if (this._isAnimation) {
                return;
            }
            this._isAnimation = true;
            float f2 = this.m_scrollX;
            float f3 = this.m_scrollY;
            if (this.m_maxScrollX > (float)this.getWidth() && this.m_maxScrollY > (float)this.getHeight()) {
                if (this.m_scrollX < 0.0f && this.m_scrollY < 0.0f) {
                    f2 = 0.0f;
                    f3 = 0.0f;
                } else if (this.m_scrollX + (float)this.getWidth() > this.m_maxScrollX && this.m_scrollY < 0.0f) {
                    f2 = this.m_maxScrollX - (float)this.getWidth();
                    f3 = 0.0f;
                } else if (this.m_scrollX + (float)this.getWidth() > this.m_maxScrollX && this.m_scrollY + (float)this.getHeight() > this.m_maxScrollY) {
                    f2 = this.m_maxScrollX - (float)this.getWidth();
                    f3 = this.m_maxScrollY - (float)this.getHeight();
                } else if (this.m_scrollX < 0.0f && this.m_scrollY + (float)this.getHeight() > this.m_maxScrollY) {
                    f2 = 0.0f;
                    f3 = this.m_maxScrollY - (float)this.getHeight();
                } else if (this.m_scrollX + (float)this.getWidth() > this.m_maxScrollX) {
                    f2 = this.m_maxScrollX - (float)this.getWidth();
                } else if (this.m_scrollY + (float)this.getHeight() > this.m_maxScrollY) {
                    f3 = this.m_maxScrollY - (float)this.getHeight();
                } else if (this.m_scrollX < 0.0f) {
                    f2 = 0.0f;
                } else if (this.m_scrollY < 0.0f) {
                    f3 = 0.0f;
                }
            } else if (this.m_maxScrollX > (float)this.getWidth()) {
                f3 = 0.0f;
                if (this.m_scrollX < 0.0f) {
                    f2 = 0.0f;
                } else if (this.m_scrollX + (float)this.getWidth() > this.m_maxScrollX) {
                    f2 = this.m_maxScrollX - (float)this.getWidth();
                }
            } else if (this.m_maxScrollY > (float)this.getHeight()) {
                f2 = 0.0f;
                if (this.m_scrollY < 0.0f) {
                    f3 = 0.0f;
                } else if (this.m_scrollY + (float)this.getHeight() > this.m_maxScrollY) {
                    f3 = this.m_maxScrollY - (float)this.getHeight();
                }
            } else {
                f2 = 0.0f;
                f3 = 0.0f;
            }
            this.m_scrollX = f2;
            this.m_scrollY = f3;
            if (!bl && (Math.abs(this.old_px - f2) > 0.5f || Math.abs(this.old_py - f3) > 0.5f)) {
                this.onScroll();
            }
            this.old_px = f2;
            this.old_py = f3;
            this.setNeedsDisplay();
            this._isAnimation = false;
        }
    }

    public native boolean nativeIsSendUserActionDoubleTap(float var1, float var2);

    protected OZSaveView getSaveView() {
        return this.svf.getSaveView();
    }

    protected void setPostVisibility(int n) {
        if (!MainFrameView.isProgressShow) {
            if (this.getHandler() != null && Thread.currentThread() == this.getHandler().getLooper().getThread()) {
                this.setVisibility(n);
            } else {
                this.post(new OZPageView$7(this, n));
            }
        } else {
            this.post(new OZPageView$8(this, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SaveImageJpgPng(Bitmap bitmap, int n, String string, int n2) {
        string = string.replace("\\", "/");
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            if (n2 == 1) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)filterOutputStream);
            } else if (n2 == 2) {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)filterOutputStream);
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static Typeface getTypeface(String string, int n) {
        Typeface typeface = null;
        try {
            if (n == 1) {
                try {
                    typeface = Typeface.createFromAsset((AssetManager)MainFrameView.s_context.getResources().getAssets(), (String)string);
                }
                catch (Throwable throwable) {
                    if (string.startsWith("res/")) {
                        typeface = Typeface.createFromAsset((AssetManager)MainFrameView.s_context.getResources().getAssets(), (String)string.substring(4));
                    }
                }
            } else {
                typeface = Typeface.createFromFile((String)string);
            }
        }
        catch (Throwable throwable) {
            Log.d((String)LOG_TAG, (String)("Font not found Error :" + string), (Throwable)throwable);
            typeface = Typeface.DEFAULT;
        }
        return typeface;
    }

    public static int compareTo(Bitmap.Config config, Bitmap bitmap) {
        return config.compareTo((Enum)bitmap.getConfig());
    }

    public void dragging(float f2, float f3) {
        if (!this.mScaleDetector.isInProgress()) {
            float f4 = f2 - this.mLastTouchX;
            float f5 = f3 - this.mLastTouchY;
            this.m_scrollX -= f4;
            this.m_scrollY -= f5;
            this.onScroll();
        }
        this.invalidate();
        this.mLastTouchX = f2;
        this.mLastTouchY = f3;
    }

    private int getCompType(float f2, float f3) {
        if (this.nativeIsInputRender()) {
            return this.nativeIsExistEnableInputComp(f2, f3);
        }
        if (this.canFindComp()) {
            OZPageView$OnGetCompTypeListener oZPageView$OnGetCompTypeListener = new OZPageView$OnGetCompTypeListener(this, null, f2, f3);
            this.findComp(oZPageView$OnGetCompTypeListener, true);
            return oZPageView$OnGetCompTypeListener.getTypeResult();
        }
        return -1;
    }

    private int getCompType(MotionEvent motionEvent) {
        return this.getCompType(motionEvent.getX(), motionEvent.getY());
    }

    public static AssetManager getAssetManager() {
        if (MainFrameView.s_context != null) {
            return MainFrameView.s_context.getAssets();
        }
        return null;
    }

    public void repaint() {
        this.invalidate();
        this.internalDraw();
    }

    public void forceRepaintWhenIgnoreScroll() {
        this.invalidate();
        this.isForceRepaintWhenIgnoreScroll = true;
    }

    public OZInputComponent getOpenComponent() {
        return this._openComponent;
    }

    public void setOpenComponent(OZInputComponent oZInputComponent) {
        this._openComponent = oZInputComponent;
    }

    public void closeVideoPlayingComponent() {
        if (this._videoPlayingComponent != null) {
            this._videoPlayingComponent.closeComponent();
            this._videoPlayingComponent = null;
        }
    }

    public OZInputComponent getVideoPlayingComponent() {
        return this._videoPlayingComponent;
    }

    public void setVideoPlayingComponent(OZInputComponent oZInputComponent) {
        this._videoPlayingComponent = oZInputComponent;
    }

    public boolean isComponentZoom() {
        return this.isNowAnimation();
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        this.mViewerSurface.setVisibility(n);
    }

    public OZPageView$PageViewHandler getPageViewHandler() {
        return this.mHandler;
    }

    public void updateCustomHighlight() {
        this.nativeUpdateCustomHighlight();
    }

    public void setVisibleCustomHighlight(boolean bl) {
        this.nativeSetVisibleCustomHighlight(bl);
    }

    public void setIsZooming(boolean bl) {
        this.nativeSetIsZooming(bl);
    }

    public void scrollingStop() {
        if (this.mVelocityDecelerator != null && this.mVelocityDecelerator.isMoving()) {
            this.mVelocityDecelerator.stop();
        }
    }

    static /* synthetic */ boolean access$002(OZPageView oZPageView, boolean bl) {
        oZPageView.mHighlightSurfaceReady = bl;
        return oZPageView.mHighlightSurfaceReady;
    }

    static /* synthetic */ SurfaceHolder access$100(OZPageView oZPageView) {
        return oZPageView.mHighlightHolder;
    }

    static /* synthetic */ OZPageView$PageViewHandler access$600(OZPageView oZPageView) {
        return oZPageView.mHandler;
    }

    static /* synthetic */ boolean access$702(OZPageView oZPageView, boolean bl) {
        oZPageView.isZooming = bl;
        return oZPageView.isZooming;
    }

    static /* synthetic */ float access$800(OZPageView oZPageView) {
        return oZPageView.mScaleFactor;
    }

    static /* synthetic */ float access$802(OZPageView oZPageView, float f2) {
        oZPageView.mScaleFactor = f2;
        return oZPageView.mScaleFactor;
    }

    static /* synthetic */ int access$900(OZPageView oZPageView, float f2, float f3) {
        return oZPageView.getCompType(f2, f3);
    }

    static /* synthetic */ void access$1000(OZPageView oZPageView) {
        oZPageView.Animation();
    }

    static /* synthetic */ SurfaceView access$1100(OZPageView oZPageView) {
        return oZPageView.mHighlightSurface;
    }

    static /* synthetic */ SurfaceHolder access$1200(OZPageView oZPageView) {
        return oZPageView.m_holder;
    }

    static /* synthetic */ boolean access$1300(OZPageView oZPageView) {
        return oZPageView.nativeHasHighlight();
    }

    static /* synthetic */ boolean access$000(OZPageView oZPageView) {
        return oZPageView.mHighlightSurfaceReady;
    }

    static /* synthetic */ int access$1400(OZPageView oZPageView) {
        return oZPageView.nativeGetHighlightDuration();
    }

    static /* synthetic */ boolean access$700(OZPageView oZPageView) {
        return oZPageView.isZooming;
    }

    static /* synthetic */ boolean access$1500(OZPageView oZPageView) {
        return oZPageView.mHighlightSurfaceEmpty;
    }

    static /* synthetic */ void access$1600(OZPageView oZPageView, Canvas canvas, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        oZPageView.drawHighlight(canvas, f2, f3, f4, f5, f6, bl);
    }

    static /* synthetic */ float access$1700(OZPageView oZPageView) {
        return oZPageView.m_scrollX;
    }

    static /* synthetic */ float access$1800(OZPageView oZPageView) {
        return oZPageView.m_scrollY;
    }

    static /* synthetic */ int access$1900(OZPageView oZPageView) {
        return oZPageView.m_userOffsetX;
    }

    static /* synthetic */ int access$2000(OZPageView oZPageView) {
        return oZPageView.m_userOffsetY;
    }

    static /* synthetic */ float access$2100(OZPageView oZPageView) {
        return oZPageView.m_offsetX;
    }

    static /* synthetic */ float access$2200(OZPageView oZPageView) {
        return oZPageView.m_offsetY;
    }

    static /* synthetic */ boolean access$2302(OZPageView oZPageView, boolean bl) {
        oZPageView.isForceRepaintWhenIgnoreScroll = bl;
        return oZPageView.isForceRepaintWhenIgnoreScroll;
    }
}

