/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.os.Parcel;
import android.os.Parcelable;
import oz.materialcalendarview.CalendarDay$1;
import oz.threeten.bp.LocalDate;

public final class CalendarDay
implements Parcelable {
    private final LocalDate date;
    public static final Parcelable.Creator CREATOR = new CalendarDay$1();

    private CalendarDay(int n, int n2, int n3) {
        this.date = LocalDate.of(n, n2, n3);
    }

    private CalendarDay(LocalDate localDate) {
        this.date = localDate;
    }

    public static CalendarDay today() {
        return CalendarDay.from(LocalDate.now());
    }

    public static CalendarDay from(int n, int n2, int n3) {
        return new CalendarDay(n, n2, n3);
    }

    public static CalendarDay from(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return new CalendarDay(localDate);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonthValue();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public LocalDate getDate() {
        return this.date;
    }

    public boolean isInRange(CalendarDay calendarDay, CalendarDay calendarDay2) {
        return !(calendarDay != null && calendarDay.isAfter(this) || calendarDay2 != null && calendarDay2.isBefore(this));
    }

    public boolean isBefore(CalendarDay calendarDay) {
        return this.date.isBefore(calendarDay.getDate());
    }

    public boolean isAfter(CalendarDay calendarDay) {
        return this.date.isAfter(calendarDay.getDate());
    }

    public boolean equals(Object object) {
        return object instanceof CalendarDay && this.date.equals(((CalendarDay)object).getDate());
    }

    public int hashCode() {
        return CalendarDay.hashCode(this.date.getYear(), this.date.getMonthValue(), this.date.getDayOfMonth());
    }

    private static int hashCode(int n, int n2, int n3) {
        return n * 10000 + n2 * 100 + n3;
    }

    public String toString() {
        return "CalendarDay{" + this.date.getYear() + "-" + this.date.getMonthValue() + "-" + this.date.getDayOfMonth() + "}";
    }

    public CalendarDay(Parcel parcel) {
        this(parcel.readInt(), parcel.readInt(), parcel.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.date.getYear());
        parcel.writeInt(this.date.getMonthValue());
        parcel.writeInt(this.date.getDayOfMonth());
    }
}

