/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.CalendarMode;
import oz.materialcalendarview.CalendarPager;
import oz.materialcalendarview.CalendarPagerAdapter;
import oz.materialcalendarview.DayView;
import oz.materialcalendarview.DayViewDecorator;
import oz.materialcalendarview.MaterialCalendarView$1;
import oz.materialcalendarview.MaterialCalendarView$2;
import oz.materialcalendarview.MaterialCalendarView$3;
import oz.materialcalendarview.MaterialCalendarView$LayoutParams;
import oz.materialcalendarview.MaterialCalendarView$SavedState;
import oz.materialcalendarview.MaterialCalendarView$State;
import oz.materialcalendarview.MaterialCalendarView$StateBuilder;
import oz.materialcalendarview.MaterialStyle;
import oz.materialcalendarview.MonthPagerAdapter;
import oz.materialcalendarview.MonthView;
import oz.materialcalendarview.OnDateLongClickListener;
import oz.materialcalendarview.OnDateSelectedListener;
import oz.materialcalendarview.OnMonthChangedListener;
import oz.materialcalendarview.OnRangeSelectedListener;
import oz.materialcalendarview.TitleChanger;
import oz.materialcalendarview.WeekPagerAdapter;
import oz.materialcalendarview.custom.AndroidThreeTen;
import oz.materialcalendarview.format.ArrayWeekDayFormatter;
import oz.materialcalendarview.format.DayFormatter;
import oz.materialcalendarview.format.MonthArrayTitleFormatter;
import oz.materialcalendarview.format.TitleFormatter;
import oz.materialcalendarview.format.WeekDayFormatter;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.temporal.WeekFields;
import oz.viewer.ui.df.DFUtils;

public class MaterialCalendarView
extends ViewGroup {
    public static final int INVALID_TILE_DIMENSION = -10;
    public static final int SELECTION_MODE_NONE = 0;
    public static final int SELECTION_MODE_SINGLE = 1;
    public static final int SELECTION_MODE_MULTIPLE = 2;
    public static final int SELECTION_MODE_RANGE = 3;
    public static final int SHOW_NONE = 0;
    public static final int SHOW_OTHER_MONTHS = 1;
    public static final int SHOW_OUT_OF_RANGE = 2;
    public static final int SHOW_DECORATED_DISABLED = 4;
    public static final int SHOW_DEFAULTS = 4;
    public static final int SHOW_ALL = 7;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int DEFAULT_TILE_SIZE_DP = 44;
    private static final int DEFAULT_DAYS_IN_WEEK = 7;
    private static final int DEFAULT_MAX_WEEKS = 6;
    private static final int DAY_NAMES_ROW = 1;
    private int PREV_NEXT_ICON_WIDTH = 17;
    private int PREV_NEXT_ICON_HEIGHT = 27;
    private final TitleChanger titleChanger;
    private TextView title;
    private ImageView buttonPast;
    private ImageView buttonFuture;
    private final CalendarPager pager;
    private CalendarPagerAdapter adapter;
    private CalendarDay currentMonth;
    private LinearLayout topbar;
    private CalendarMode calendarMode;
    private boolean mDynamicHeightEnabled;
    private final ArrayList dayViewDecorators = new ArrayList();
    private final View.OnClickListener onClickListener = new MaterialCalendarView$1(this);
    private final ViewPager.OnPageChangeListener pageChangeListener = new MaterialCalendarView$2(this);
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private OnDateSelectedListener listener;
    private OnDateLongClickListener longClickListener;
    private OnMonthChangedListener monthListener;
    private OnRangeSelectedListener rangeListener;
    CharSequence calendarContentDescription;
    private int accentColor = 0;
    private int tileHeight = -10;
    private int tileWidth = -10;
    private int selectionMode = 1;
    private boolean allowClickDaysOutsideCurrentMonth = true;
    private DayOfWeek firstDayOfWeek;
    private boolean showWeekDays;
    private MaterialCalendarView$State state;
    public final MaterialStyle materialStyle;

    public MaterialCalendarView(Context context, MaterialStyle materialStyle) {
        this(context, materialStyle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterialCalendarView(Context context, MaterialStyle materialStyle, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.materialStyle = materialStyle;
        AndroidThreeTen.init(this.getContext());
        if (Build.VERSION.SDK_INT >= 19) {
            this.setClipToPadding(false);
            this.setClipChildren(false);
        } else {
            this.setClipChildren(true);
            this.setClipToPadding(true);
        }
        this.createView();
        this.pager = new CalendarPager(this.getContext());
        this.buttonPast.setOnClickListener(this.onClickListener);
        this.buttonFuture.setOnClickListener(this.onClickListener);
        this.titleChanger = new TitleChanger(this.title);
        this.pager.setOnPageChangeListener(this.pageChangeListener);
        this.pager.setPageTransformer(false, new MaterialCalendarView$3(this));
        try {
            int n = 0;
            int n2 = -1;
            this.titleChanger.setOrientation(0);
            this.firstDayOfWeek = n2 >= 1 && n2 <= 7 ? DayOfWeek.of(n2) : WeekFields.of(Locale.getDefault()).getFirstDayOfWeek();
            this.showWeekDays = true;
            this.newState().setFirstDayOfWeek(this.firstDayOfWeek).setCalendarDisplayMode(CalendarMode.values()[n]).setShowWeekDays(this.showWeekDays).commit();
            this.setSelectionMode(1);
            int n3 = -10;
            int n4 = -10;
            int n5 = -10;
            this.setSelectionColor(MaterialCalendarView.getThemeAccentColor(context));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setupChildren();
        this.currentMonth = CalendarDay.today();
        this.setCurrentDate(this.currentMonth);
        if (this.isInEditMode()) {
            this.removeView((View)this.pager);
            MonthView monthView = new MonthView(this, this.currentMonth, this.getFirstDayOfWeek(), true);
            monthView.setSelectionColor(this.getSelectionColor());
            monthView.setDateTextAppearance(this.adapter.getDateTextAppearance());
            monthView.setWeekDayTextAppearance(this.adapter.getWeekDayTextAppearance());
            monthView.setShowOtherDates(this.getShowOtherDates());
            this.addView((View)monthView, (ViewGroup.LayoutParams)new MaterialCalendarView$LayoutParams(this.calendarMode.visibleWeeksCount + 1));
        }
    }

    private void createView() {
        this.topbar = new LinearLayout(this.getContext());
        this.buttonPast = new ImageView(this.getContext());
        this.buttonFuture = new ImageView(this.getContext());
        this.title = new TextView(this.getContext());
        this.topbar.setOrientation(0);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.topbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.topbar.setGravity(17);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, -2);
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        layoutParams2.setMargins(n, 0, 0, 0);
        layoutParams3.setMargins(0, 0, n, 0);
        this.title.setGravity(17);
        this.title.setTextColor(this.materialStyle.fontColor);
        this.title.setTextSize((float)DFUtils.toDP(this.getContext(), 8.0f));
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams2.width = DFUtils.toDP(this.getContext(), this.PREV_NEXT_ICON_WIDTH);
        layoutParams2.height = DFUtils.toDP(this.getContext(), this.PREV_NEXT_ICON_HEIGHT);
        layoutParams3.width = DFUtils.toDP(this.getContext(), this.PREV_NEXT_ICON_WIDTH);
        layoutParams3.height = DFUtils.toDP(this.getContext(), this.PREV_NEXT_ICON_HEIGHT);
        this.topbar.addView((View)this.buttonPast, (ViewGroup.LayoutParams)layoutParams2);
        this.topbar.addView((View)this.title, (ViewGroup.LayoutParams)layoutParams4);
        this.topbar.addView((View)this.buttonFuture, (ViewGroup.LayoutParams)layoutParams3);
    }

    private int toDP(Context context, float f2) {
        return (int)this.toDP_F(context, f2);
    }

    private float toDP_F(Context context, float f2) {
        return TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private void setupChildren() {
        this.addView((View)this.topbar);
        this.pager.setId(1);
        this.pager.setOffscreenPageLimit(1);
        int n = this.showWeekDays ? this.calendarMode.visibleWeeksCount + 1 : this.calendarMode.visibleWeeksCount;
        this.addView((View)this.pager, (ViewGroup.LayoutParams)new MaterialCalendarView$LayoutParams(n));
    }

    private void updateUi() {
        this.titleChanger.change(this.currentMonth);
        MaterialCalendarView.enableView((View)this.buttonPast, this.canGoBack());
        MaterialCalendarView.enableView((View)this.buttonFuture, this.canGoForward());
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        switch (n) {
            case 3: {
                this.clearSelection();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                List list;
                if (n2 != 2 && n2 != 3 || (list = this.getSelectedDates()).isEmpty()) break;
                this.setSelectedDate(this.getSelectedDate());
                break;
            }
            default: {
                this.selectionMode = 0;
                if (n2 == 0) break;
                this.clearSelection();
            }
        }
        this.adapter.setSelectionEnabled(this.selectionMode != 0);
    }

    public void goToPrevious() {
        if (this.canGoBack()) {
            this.pager.setCurrentItem(this.pager.getCurrentItem() - 1, true);
        }
    }

    public void goToNext() {
        if (this.canGoForward()) {
            this.pager.setCurrentItem(this.pager.getCurrentItem() + 1, true);
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int getTileSize() {
        return Math.max(this.tileHeight, this.tileWidth);
    }

    public void setTileSize(int n) {
        this.tileWidth = n;
        this.tileHeight = n;
        this.requestLayout();
    }

    public void setTileSizeDp(int n) {
        this.setTileSize(this.dpToPx(n));
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int n) {
        this.tileHeight = n;
        this.requestLayout();
    }

    public void setTileHeightDp(int n) {
        this.setTileHeight(this.dpToPx(n));
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int n) {
        this.tileWidth = n;
        this.requestLayout();
    }

    public void setTileWidthDp(int n) {
        this.setTileWidth(this.dpToPx(n));
    }

    private int dpToPx(int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public boolean canGoForward() {
        return this.pager.getCurrentItem() < this.adapter.getCount() - 1;
    }

    public boolean canGoBack() {
        return this.pager.getCurrentItem() > 0;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.pager.dispatchTouchEvent(motionEvent);
    }

    public int getSelectionColor() {
        return this.accentColor;
    }

    public void setSelectionColor(int n) {
        if (n == 0) {
            if (!this.isInEditMode()) {
                return;
            }
            n = -7829368;
        }
        this.accentColor = n;
        this.adapter.setSelectionColor(n);
        this.invalidate();
    }

    public void setContentDescriptionArrowPast(CharSequence charSequence) {
        this.buttonPast.setContentDescription(charSequence);
    }

    public void setContentDescriptionArrowFuture(CharSequence charSequence) {
        this.buttonFuture.setContentDescription(charSequence);
    }

    public void setContentDescriptionCalendar(CharSequence charSequence) {
        this.calendarContentDescription = charSequence;
    }

    public CharSequence getCalendarContentDescription() {
        return this.calendarContentDescription != null ? this.calendarContentDescription : "Calendar";
    }

    public void setDayFormatterContentDescription(DayFormatter dayFormatter) {
        this.adapter.setDayFormatterContentDescription(dayFormatter);
    }

    public Drawable getLeftArrow() {
        return this.buttonPast.getDrawable();
    }

    public void setLeftArrow(int n) {
        this.buttonPast.setImageResource(n);
    }

    public void setLeftArrow(Drawable drawable2) {
        this.buttonPast.setBackground(drawable2);
    }

    public Drawable getRightArrow() {
        return this.buttonFuture.getDrawable();
    }

    public void setRightArrow(int n) {
        this.buttonFuture.setImageResource(n);
    }

    public void setRightArrow(Drawable drawable2) {
        this.buttonFuture.setBackground(drawable2);
    }

    public void setHeaderTextAppearance(int n) {
        this.title.setTextAppearance(this.getContext(), n);
    }

    public void setDateTextAppearance(int n) {
        this.adapter.setDateTextAppearance(n);
    }

    public void setWeekDayTextAppearance(int n) {
        this.adapter.setWeekDayTextAppearance(n);
    }

    public CalendarDay getSelectedDate() {
        List list = this.adapter.getSelectedDates();
        if (list.isEmpty()) {
            return null;
        }
        return (CalendarDay)list.get(list.size() - 1);
    }

    public List getSelectedDates() {
        return this.adapter.getSelectedDates();
    }

    public void clearSelection() {
        List list = this.getSelectedDates();
        this.adapter.clearSelections();
        for (CalendarDay calendarDay : list) {
            this.dispatchOnDateSelected(calendarDay, false);
        }
    }

    public void setSelectedDate(LocalDate localDate) {
        this.setSelectedDate(CalendarDay.from(localDate));
    }

    public void setSelectedDate(CalendarDay calendarDay) {
        this.clearSelection();
        if (calendarDay != null) {
            this.setDateSelected(calendarDay, true);
        }
    }

    public void setDateSelected(CalendarDay calendarDay, boolean bl) {
        if (calendarDay == null) {
            return;
        }
        this.adapter.setDateSelected(calendarDay, bl);
    }

    public CalendarDay getCurrentDate() {
        return this.adapter.getItem(this.pager.getCurrentItem());
    }

    public void setCurrentDate(LocalDate localDate) {
        this.setCurrentDate(CalendarDay.from(localDate));
    }

    public void setCurrentDate(CalendarDay calendarDay) {
        this.setCurrentDate(calendarDay, true);
    }

    public void setCurrentDate(CalendarDay calendarDay, boolean bl) {
        if (calendarDay == null) {
            return;
        }
        int n = this.adapter.getIndexForDay(calendarDay);
        this.pager.setCurrentItem(n, bl);
        this.updateUi();
    }

    public CalendarDay getMinimumDate() {
        return this.minDate;
    }

    public CalendarDay getMaximumDate() {
        return this.maxDate;
    }

    public void setShowOtherDates(int n) {
        this.adapter.setShowOtherDates(n);
    }

    public void setAllowClickDaysOutsideCurrentMonth(boolean bl) {
        this.allowClickDaysOutsideCurrentMonth = bl;
    }

    public void setWeekDayFormatter(WeekDayFormatter weekDayFormatter) {
        this.adapter.setWeekDayFormatter(weekDayFormatter == null ? WeekDayFormatter.DEFAULT : weekDayFormatter);
    }

    public void setDayFormatter(DayFormatter dayFormatter) {
        this.adapter.setDayFormatter(dayFormatter == null ? DayFormatter.DEFAULT : dayFormatter);
    }

    public void setWeekDayLabels(CharSequence[] charSequenceArray) {
        this.setWeekDayFormatter(new ArrayWeekDayFormatter(charSequenceArray));
    }

    public void setWeekDayLabels(int n) {
        this.setWeekDayLabels(this.getResources().getTextArray(n));
    }

    public int getShowOtherDates() {
        return this.adapter.getShowOtherDates();
    }

    public boolean allowClickDaysOutsideCurrentMonth() {
        return this.allowClickDaysOutsideCurrentMonth;
    }

    public boolean isShowWeekDays() {
        return this.showWeekDays;
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        this.titleChanger.setTitleFormatter(titleFormatter);
        this.adapter.setTitleFormatter(titleFormatter);
        this.updateUi();
    }

    public void setTitleMonths(CharSequence[] charSequenceArray) {
        this.setTitleFormatter(new MonthArrayTitleFormatter(charSequenceArray));
    }

    public void setTitleMonths(int n) {
        this.setTitleMonths(this.getResources().getTextArray(n));
    }

    public void setTitleAnimationOrientation(int n) {
        this.titleChanger.setOrientation(n);
    }

    public int getTitleAnimationOrientation() {
        return this.titleChanger.getOrientation();
    }

    public void setTopbarVisible(boolean bl) {
        this.topbar.setVisibility(bl ? 0 : 8);
        this.requestLayout();
    }

    public boolean getTopbarVisible() {
        return this.topbar.getVisibility() == 0;
    }

    public CalendarMode getCalendarMode() {
        return this.calendarMode;
    }

    protected Parcelable onSaveInstanceState() {
        MaterialCalendarView$SavedState materialCalendarView$SavedState = new MaterialCalendarView$SavedState(super.onSaveInstanceState());
        materialCalendarView$SavedState.showOtherDates = this.getShowOtherDates();
        materialCalendarView$SavedState.allowClickDaysOutsideCurrentMonth = this.allowClickDaysOutsideCurrentMonth();
        materialCalendarView$SavedState.minDate = this.getMinimumDate();
        materialCalendarView$SavedState.maxDate = this.getMaximumDate();
        materialCalendarView$SavedState.selectedDates = this.getSelectedDates();
        materialCalendarView$SavedState.selectionMode = this.getSelectionMode();
        materialCalendarView$SavedState.topbarVisible = this.getTopbarVisible();
        materialCalendarView$SavedState.dynamicHeightEnabled = this.mDynamicHeightEnabled;
        materialCalendarView$SavedState.currentMonth = this.currentMonth;
        materialCalendarView$SavedState.cacheCurrentPosition = MaterialCalendarView$State.access$700(this.state);
        return materialCalendarView$SavedState;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        MaterialCalendarView$SavedState materialCalendarView$SavedState = (MaterialCalendarView$SavedState)parcelable;
        super.onRestoreInstanceState(materialCalendarView$SavedState.getSuperState());
        this.state().edit().setMinimumDate(materialCalendarView$SavedState.minDate).setMaximumDate(materialCalendarView$SavedState.maxDate).isCacheCalendarPositionEnabled(materialCalendarView$SavedState.cacheCurrentPosition).commit();
        this.setShowOtherDates(materialCalendarView$SavedState.showOtherDates);
        this.setAllowClickDaysOutsideCurrentMonth(materialCalendarView$SavedState.allowClickDaysOutsideCurrentMonth);
        this.clearSelection();
        for (CalendarDay calendarDay : materialCalendarView$SavedState.selectedDates) {
            this.setDateSelected(calendarDay, true);
        }
        this.setTopbarVisible(materialCalendarView$SavedState.topbarVisible);
        this.setSelectionMode(materialCalendarView$SavedState.selectionMode);
        this.setDynamicHeightEnabled(materialCalendarView$SavedState.dynamicHeightEnabled);
        this.setCurrentDate(materialCalendarView$SavedState.currentMonth);
    }

    protected void dispatchSaveInstanceState(SparseArray sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    protected void dispatchRestoreInstanceState(SparseArray sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    private void setRangeDates(CalendarDay calendarDay, CalendarDay calendarDay2) {
        CalendarDay calendarDay3 = this.currentMonth;
        this.adapter.setRangeDates(calendarDay, calendarDay2);
        this.currentMonth = calendarDay3;
        if (calendarDay != null) {
            this.currentMonth = calendarDay.isAfter(this.currentMonth) ? calendarDay : this.currentMonth;
        }
        int n = this.adapter.getIndexForDay(calendarDay3);
        this.pager.setCurrentItem(n, false);
        this.updateUi();
    }

    private static int getThemeAccentColor(Context context) {
        int n = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(n, typedValue, true);
        return typedValue.data;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setDynamicHeightEnabled(boolean bl) {
        this.mDynamicHeightEnabled = bl;
    }

    public boolean isDynamicHeightEnabled() {
        return this.mDynamicHeightEnabled;
    }

    public void addDecorators(Collection collection) {
        if (collection == null) {
            return;
        }
        this.dayViewDecorators.addAll(collection);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void addDecorators(DayViewDecorator ... dayViewDecoratorArray) {
        this.addDecorators(Arrays.asList(dayViewDecoratorArray));
    }

    public void addDecorator(DayViewDecorator dayViewDecorator) {
        if (dayViewDecorator == null) {
            return;
        }
        this.dayViewDecorators.add(dayViewDecorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorators() {
        this.dayViewDecorators.clear();
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorator(DayViewDecorator dayViewDecorator) {
        this.dayViewDecorators.remove(dayViewDecorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void invalidateDecorators() {
        this.adapter.invalidateDecorators();
    }

    public void setOnDateChangedListener(OnDateSelectedListener onDateSelectedListener) {
        this.listener = onDateSelectedListener;
    }

    public void setOnDateLongClickListener(OnDateLongClickListener onDateLongClickListener) {
        this.longClickListener = onDateLongClickListener;
    }

    public void setOnMonthChangedListener(OnMonthChangedListener onMonthChangedListener) {
        this.monthListener = onMonthChangedListener;
    }

    public void setOnRangeSelectedListener(OnRangeSelectedListener onRangeSelectedListener) {
        this.rangeListener = onRangeSelectedListener;
    }

    public void setOnTitleClickListener(View.OnClickListener onClickListener) {
        this.title.setOnClickListener(onClickListener);
    }

    protected void dispatchOnDateSelected(CalendarDay calendarDay, boolean bl) {
        if (this.listener != null) {
            this.listener.onDateSelected(this, calendarDay, bl);
        }
    }

    protected void dispatchOnRangeSelected(List list) {
        if (this.rangeListener != null) {
            this.rangeListener.onRangeSelected(this, list);
        }
    }

    protected void dispatchOnMonthChanged(CalendarDay calendarDay) {
        if (this.monthListener != null) {
            this.monthListener.onMonthChanged(this, calendarDay);
        }
    }

    protected void onDateClicked(CalendarDay calendarDay, boolean bl) {
        switch (this.selectionMode) {
            case 2: {
                this.adapter.setDateSelected(calendarDay, bl);
                this.dispatchOnDateSelected(calendarDay, bl);
                break;
            }
            case 3: {
                List list = this.adapter.getSelectedDates();
                if (list.size() == 0) {
                    this.adapter.setDateSelected(calendarDay, bl);
                    this.dispatchOnDateSelected(calendarDay, bl);
                    break;
                }
                if (list.size() == 1) {
                    CalendarDay calendarDay2 = (CalendarDay)list.get(0);
                    if (calendarDay2.equals(calendarDay)) {
                        this.adapter.setDateSelected(calendarDay, bl);
                        this.dispatchOnDateSelected(calendarDay, bl);
                        break;
                    }
                    if (calendarDay2.isAfter(calendarDay)) {
                        this.adapter.selectRange(calendarDay, calendarDay2);
                        this.dispatchOnRangeSelected(this.adapter.getSelectedDates());
                        break;
                    }
                    this.adapter.selectRange(calendarDay2, calendarDay);
                    this.dispatchOnRangeSelected(this.adapter.getSelectedDates());
                    break;
                }
                this.adapter.clearSelections();
                this.adapter.setDateSelected(calendarDay, bl);
                this.dispatchOnDateSelected(calendarDay, bl);
                break;
            }
            default: {
                this.adapter.clearSelections();
                this.adapter.setDateSelected(calendarDay, true);
                this.dispatchOnDateSelected(calendarDay, true);
            }
        }
    }

    public void selectRange(CalendarDay calendarDay, CalendarDay calendarDay2) {
        if (calendarDay == null || calendarDay2 == null) {
            return;
        }
        if (calendarDay.isAfter(calendarDay2)) {
            this.adapter.selectRange(calendarDay2, calendarDay);
            this.dispatchOnRangeSelected(this.adapter.getSelectedDates());
        } else {
            this.adapter.selectRange(calendarDay, calendarDay2);
            this.dispatchOnRangeSelected(this.adapter.getSelectedDates());
        }
    }

    protected void onDateClicked(DayView dayView) {
        CalendarDay calendarDay = this.getCurrentDate();
        CalendarDay calendarDay2 = dayView.getDate();
        int n = calendarDay.getMonth();
        int n2 = calendarDay2.getMonth();
        if (this.calendarMode == CalendarMode.MONTHS && this.allowClickDaysOutsideCurrentMonth && n != n2) {
            if (calendarDay.isAfter(calendarDay2)) {
                this.goToPrevious();
            } else if (calendarDay.isBefore(calendarDay2)) {
                this.goToNext();
            }
        }
        this.onDateClicked(dayView.getDate(), !dayView.isChecked());
    }

    protected void onDateLongClicked(DayView dayView) {
        if (this.longClickListener != null) {
            this.longClickListener.onDateLongClick(this, dayView.getDate());
        }
    }

    protected void onDateUnselected(CalendarDay calendarDay) {
        this.dispatchOnDateSelected(calendarDay, false);
    }

    public static boolean showOtherMonths(int n) {
        return (n & 1) != 0;
    }

    public static boolean showOutOfRange(int n) {
        return (n & 2) != 0;
    }

    public static boolean showDecoratedDisabled(int n) {
        return (n & 4) != 0;
    }

    protected MaterialCalendarView$LayoutParams generateDefaultLayoutParams() {
        return new MaterialCalendarView$LayoutParams(1);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getMode((int)n);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = View.MeasureSpec.getMode((int)n2);
        int n7 = n3 - this.getPaddingLeft() - this.getPaddingRight();
        int n8 = n5 - this.getPaddingTop() - this.getPaddingBottom();
        int n9 = this.getWeekCountBasedOnMode();
        int n10 = this.getTopbarVisible() ? n9 + 1 : n9;
        int n11 = n7 / 7;
        int n12 = n8 / n10;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        if (this.tileWidth != -10 || this.tileHeight != -10) {
            n14 = this.tileWidth > 0 ? this.tileWidth : n11;
            n15 = this.tileHeight > 0 ? this.tileHeight : n12;
        } else if (n4 == 0x40000000 || n4 == Integer.MIN_VALUE) {
            n13 = n6 == 0x40000000 ? Math.min(n11, n12) : n11;
        } else if (n6 == 0x40000000 || n6 == Integer.MIN_VALUE) {
            n13 = n12;
        }
        if (n13 > 0) {
            n15 = n13;
            n14 = n13;
        } else if (n13 <= 0) {
            if (n14 <= 0) {
                n14 = this.dpToPx(44);
            }
            if (n15 <= 0) {
                n15 = this.dpToPx(44);
            }
        }
        int n16 = n14 * 7;
        int n17 = n15 * n10;
        this.setMeasuredDimension(MaterialCalendarView.clampSize(n16 += this.getPaddingLeft() + this.getPaddingRight(), n), MaterialCalendarView.clampSize(n17 += this.getPaddingTop() + this.getPaddingBottom(), n2));
        int n18 = this.getChildCount();
        for (int j = 0; j < n18; ++j) {
            View view = this.getChildAt(j);
            MaterialCalendarView$LayoutParams materialCalendarView$LayoutParams = (MaterialCalendarView$LayoutParams)view.getLayoutParams();
            int n19 = View.MeasureSpec.makeMeasureSpec((int)(7 * n14), (int)0x40000000);
            int n20 = View.MeasureSpec.makeMeasureSpec((int)(materialCalendarView$LayoutParams.height * n15), (int)0x40000000);
            view.measure(n19, n20);
        }
    }

    private int getWeekCountBasedOnMode() {
        int n = this.calendarMode.visibleWeeksCount;
        boolean bl = this.calendarMode.equals((Object)CalendarMode.MONTHS);
        if (bl && this.mDynamicHeightEnabled && this.adapter != null && this.pager != null) {
            LocalDate localDate = this.adapter.getItem(this.pager.getCurrentItem()).getDate();
            LocalDate localDate2 = localDate.withDayOfMonth(localDate.lengthOfMonth());
            n = localDate2.get(WeekFields.of(this.firstDayOfWeek, 1).weekOfMonth());
        }
        return this.showWeekDays ? n + 1 : n;
    }

    private static int clampSize(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n2);
        int n4 = View.MeasureSpec.getSize((int)n2);
        switch (n3) {
            case 0x40000000: {
                return n4;
            }
            case -2147483648: {
                return Math.min(n, n4);
            }
        }
        return n;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = this.getPaddingLeft();
        int n7 = n3 - n - n6 - this.getPaddingRight();
        int n8 = this.getPaddingTop();
        for (int j = 0; j < n5; ++j) {
            View view = this.getChildAt(j);
            if (view.getVisibility() == 8) continue;
            int n9 = view.getMeasuredWidth();
            int n10 = view.getMeasuredHeight();
            int n11 = (n7 - n9) / 2;
            int n12 = n6 + n11;
            view.layout(n12, n8, n12 + n9, n8 + n10);
            n8 += n10;
        }
    }

    public MaterialCalendarView$LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new MaterialCalendarView$LayoutParams(1);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof MaterialCalendarView$LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new MaterialCalendarView$LayoutParams(1);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)MaterialCalendarView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)MaterialCalendarView.class.getName());
    }

    public void setPagingEnabled(boolean bl) {
        this.pager.setPagingEnabled(bl);
        this.updateUi();
    }

    public boolean isPagingEnabled() {
        return this.pager.isPagingEnabled();
    }

    public MaterialCalendarView$State state() {
        return this.state;
    }

    public MaterialCalendarView$StateBuilder newState() {
        return new MaterialCalendarView$StateBuilder(this);
    }

    private void commit(MaterialCalendarView$State materialCalendarView$State) {
        Object object;
        Object object2 = null;
        if (this.adapter != null && MaterialCalendarView$State.access$700(materialCalendarView$State)) {
            object2 = this.adapter.getItem(this.pager.getCurrentItem());
            if (this.calendarMode != MaterialCalendarView$State.access$1600(materialCalendarView$State)) {
                LocalDate localDate;
                object = this.getSelectedDate();
                if (this.calendarMode == CalendarMode.MONTHS && object != null) {
                    localDate = ((CalendarDay)object2).getDate();
                    CalendarDay calendarDay = CalendarDay.from(localDate.plusDays(1L));
                    if (((CalendarDay)object).equals(object2) || ((CalendarDay)object).isAfter((CalendarDay)object2) && ((CalendarDay)object).isBefore(calendarDay)) {
                        object2 = object;
                    }
                } else if (this.calendarMode == CalendarMode.WEEKS) {
                    localDate = ((CalendarDay)object2).getDate();
                    CalendarDay calendarDay = CalendarDay.from(localDate.plusDays(6L));
                    object2 = object != null && (((CalendarDay)object).equals(object2) || ((CalendarDay)object).equals(calendarDay) || ((CalendarDay)object).isAfter((CalendarDay)object2) && ((CalendarDay)object).isBefore(calendarDay)) ? object : calendarDay;
                }
            }
        }
        this.state = materialCalendarView$State;
        this.calendarMode = MaterialCalendarView$State.access$1600(materialCalendarView$State);
        this.firstDayOfWeek = MaterialCalendarView$State.access$1700(materialCalendarView$State);
        this.minDate = MaterialCalendarView$State.access$1800(materialCalendarView$State);
        this.maxDate = MaterialCalendarView$State.access$1900(materialCalendarView$State);
        this.showWeekDays = MaterialCalendarView$State.access$2000(materialCalendarView$State);
        switch (this.calendarMode) {
            case MONTHS: {
                object = new MonthPagerAdapter(this);
                break;
            }
            case WEEKS: {
                object = new WeekPagerAdapter(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided display mode which is not yet implemented");
            }
        }
        this.adapter = this.adapter == null ? object : this.adapter.migrateStateAndReturn((CalendarPagerAdapter)((Object)object));
        this.adapter.setShowWeekDays(this.showWeekDays);
        this.pager.setAdapter(this.adapter);
        this.setRangeDates(this.minDate, this.maxDate);
        int n = this.showWeekDays ? this.calendarMode.visibleWeeksCount + 1 : this.calendarMode.visibleWeeksCount;
        this.pager.setLayoutParams((ViewGroup.LayoutParams)new MaterialCalendarView$LayoutParams(n));
        this.setCurrentDate(this.selectionMode == 1 && !this.adapter.getSelectedDates().isEmpty() ? (CalendarDay)this.adapter.getSelectedDates().get(0) : CalendarDay.today());
        if (object2 != null) {
            this.pager.setCurrentItem(this.adapter.getIndexForDay((CalendarDay)object2));
        }
        this.invalidateDecorators();
        this.updateUi();
    }

    private static void enableView(View view, boolean bl) {
        view.setEnabled(bl);
        view.setAlpha(bl ? 1.0f : 0.1f);
    }

    static /* synthetic */ ImageView access$000(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.buttonFuture;
    }

    static /* synthetic */ CalendarPager access$100(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.pager;
    }

    static /* synthetic */ ImageView access$200(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.buttonPast;
    }

    static /* synthetic */ CalendarDay access$300(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.currentMonth;
    }

    static /* synthetic */ TitleChanger access$400(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.titleChanger;
    }

    static /* synthetic */ CalendarDay access$302(MaterialCalendarView materialCalendarView, CalendarDay calendarDay) {
        materialCalendarView.currentMonth = calendarDay;
        return materialCalendarView.currentMonth;
    }

    static /* synthetic */ CalendarPagerAdapter access$500(MaterialCalendarView materialCalendarView) {
        return materialCalendarView.adapter;
    }

    static /* synthetic */ void access$600(MaterialCalendarView materialCalendarView) {
        materialCalendarView.updateUi();
    }

    static /* synthetic */ void access$2200(MaterialCalendarView materialCalendarView, MaterialCalendarView$State materialCalendarView$State) {
        materialCalendarView.commit(materialCalendarView$State);
    }
}

