/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.widget.TextView;
import oz.materialcalendarview.MaterialStyle;
import oz.materialcalendarview.format.WeekDayFormatter;
import oz.threeten.bp.DayOfWeek;
import oz.viewer.ui.df.DFUtils;

class WeekDayView
extends TextView {
    private WeekDayFormatter formatter = WeekDayFormatter.DEFAULT;
    private DayOfWeek dayOfWeek;
    private MaterialStyle materialStyle;
    private Paint linePaint;

    public WeekDayView(Context context, DayOfWeek dayOfWeek, MaterialStyle materialStyle) {
        super(context);
        this.materialStyle = materialStyle;
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDayOfWeek(dayOfWeek);
        this.linePaint = new Paint();
        this.linePaint.setColor(materialStyle.lineColor);
        this.linePaint.setStrokeWidth((float)DFUtils.toDP(this.getContext(), 1.0f));
    }

    public void setWeekDayFormatter(WeekDayFormatter weekDayFormatter) {
        this.formatter = weekDayFormatter == null ? WeekDayFormatter.DEFAULT : weekDayFormatter;
        this.setDayOfWeek(this.dayOfWeek);
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        this.setText(dayOfWeek);
    }

    public void setText(DayOfWeek dayOfWeek) {
        this.setText(this.formatter.format(dayOfWeek));
        if (dayOfWeek == DayOfWeek.SUNDAY) {
            this.setTextColor(this.materialStyle.sundayColor);
        } else if (dayOfWeek == DayOfWeek.SATURDAY) {
            this.setTextColor(this.materialStyle.saturdayColor);
        } else {
            this.setTextColor(this.materialStyle.fontColor);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawLine(0.0f, (float)(canvas.getHeight() - 10), (float)canvas.getWidth(), (float)(canvas.getHeight() - 10), this.linePaint);
    }
}

