/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.Duration;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.jdk8.Jdk8Methods;

final class Clock$OffsetClock
extends Clock
implements Serializable {
    private static final long serialVersionUID = 2007484719125426256L;
    private final Clock baseClock;
    private final Duration offset;

    Clock$OffsetClock(Clock clock, Duration duration) {
        this.baseClock = clock;
        this.offset = duration;
    }

    public ZoneId getZone() {
        return this.baseClock.getZone();
    }

    public Clock withZone(ZoneId zoneId) {
        if (zoneId.equals(this.baseClock.getZone())) {
            return this;
        }
        return new Clock$OffsetClock(this.baseClock.withZone(zoneId), this.offset);
    }

    public long millis() {
        return Jdk8Methods.safeAdd(this.baseClock.millis(), this.offset.toMillis());
    }

    public Instant instant() {
        return this.baseClock.instant().plus(this.offset);
    }

    public boolean equals(Object object) {
        if (object instanceof Clock$OffsetClock) {
            Clock$OffsetClock clock$OffsetClock = (Clock$OffsetClock)object;
            return this.baseClock.equals(clock$OffsetClock.baseClock) && this.offset.equals(clock$OffsetClock.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.baseClock.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return "OffsetClock[" + this.baseClock + "," + this.offset + "]";
    }
}

