/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate$1;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.OffsetDateTime;
import oz.threeten.bp.OffsetTime;
import oz.threeten.bp.Period;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.ZonedDateTime;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneRules;

public final class LocalDate
extends ChronoLocalDate
implements Serializable,
Temporal,
TemporalAdjuster {
    public static final LocalDate MIN = LocalDate.of(-999999999, 1, 1);
    public static final LocalDate MAX = LocalDate.of(999999999, 12, 31);
    public static final TemporalQuery FROM = new LocalDate$1();
    private static final long serialVersionUID = 2942565459149668126L;
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    private final int year;
    private final short month;
    private final short day;

    public static LocalDate now() {
        return LocalDate.now(Clock.systemDefaultZone());
    }

    public static LocalDate now(ZoneId zoneId) {
        return LocalDate.now(Clock.system(zoneId));
    }

    public static LocalDate now(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        ZoneOffset zoneOffset = clock.getZone().getRules().getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        long l2 = Jdk8Methods.floorDiv(l, 86400L);
        return LocalDate.ofEpochDay(l2);
    }

    public static LocalDate of(int n, Month month, int n2) {
        ChronoField.YEAR.checkValidValue(n);
        Jdk8Methods.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(n2);
        return LocalDate.create(n, month, n2);
    }

    public static LocalDate of(int n, int n2, int n3) {
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.MONTH_OF_YEAR.checkValidValue(n2);
        ChronoField.DAY_OF_MONTH.checkValidValue(n3);
        return LocalDate.create(n, Month.of(n2), n3);
    }

    public static LocalDate ofYearDay(int n, int n2) {
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.DAY_OF_YEAR.checkValidValue(n2);
        boolean bl = IsoChronology.INSTANCE.isLeapYear(n);
        if (n2 == 366 && !bl) {
            throw new DateTimeException("Invalid date 'DayOfYear 366' as '" + n + "' is not a leap year");
        }
        Month month = Month.of((n2 - 1) / 31 + 1);
        int n3 = month.firstDayOfYear(bl) + month.length(bl) - 1;
        if (n2 > n3) {
            month = month.plus(1L);
        }
        int n4 = n2 - month.firstDayOfYear(bl) + 1;
        return LocalDate.create(n, month, n4);
    }

    public static LocalDate ofEpochDay(long l) {
        long l2;
        long l3;
        ChronoField.EPOCH_DAY.checkValidValue(l);
        long l4 = l + 719528L;
        long l5 = 0L;
        if ((l4 -= 60L) < 0L) {
            l3 = (l4 + 1L) / 146097L - 1L;
            l5 = l3 * 400L;
            l4 += -l3 * 146097L;
        }
        if ((l2 = l4 - (365L * (l3 = (400L * l4 + 591L) / 146097L) + l3 / 4L - l3 / 100L + l3 / 400L)) < 0L) {
            l2 = l4 - (365L * --l3 + l3 / 4L - l3 / 100L + l3 / 400L);
        }
        l3 += l5;
        int n = (int)l2;
        int n2 = (n * 5 + 2) / 153;
        int n3 = (n2 + 2) % 12 + 1;
        int n4 = n - (n2 * 306 + 5) / 10 + 1;
        int n5 = ChronoField.YEAR.checkValidIntValue(l3 += (long)(n2 / 10));
        return new LocalDate(n5, n3, n4);
    }

    public static LocalDate from(TemporalAccessor temporalAccessor) {
        LocalDate localDate = (LocalDate)temporalAccessor.query(TemporalQueries.localDate());
        if (localDate == null) {
            throw new DateTimeException("Unable to obtain LocalDate from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
        return localDate;
    }

    public static LocalDate parse(CharSequence charSequence) {
        return LocalDate.parse(charSequence, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (LocalDate)dateTimeFormatter.parse(charSequence, FROM);
    }

    private static LocalDate create(int n, Month month, int n2) {
        if (n2 > 28 && n2 > month.length(IsoChronology.INSTANCE.isLeapYear(n))) {
            if (n2 == 29) {
                throw new DateTimeException("Invalid date 'February 29' as '" + n + "' is not a leap year");
            }
            throw new DateTimeException("Invalid date '" + month.name() + " " + n2 + "'");
        }
        return new LocalDate(n, month.getValue(), n2);
    }

    private static LocalDate resolvePreviousValid(int n, int n2, int n3) {
        switch (n2) {
            case 2: {
                n3 = Math.min(n3, IsoChronology.INSTANCE.isLeapYear(n) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n3 = Math.min(n3, 30);
            }
        }
        return LocalDate.of(n, n2, n3);
    }

    private LocalDate(int n, int n2, int n3) {
        this.year = n;
        this.month = (short)n2;
        this.day = (short)n3;
    }

    public boolean isSupported(TemporalField temporalField) {
        return super.isSupported(temporalField);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (chronoField.isDateBased()) {
                switch (chronoField) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, this.getMonth() == Month.FEBRUARY && !this.isLeapYear() ? 4L : 5L);
                    }
                    case YEAR_OF_ERA: {
                        return this.getYear() <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
                    }
                }
                return temporalField.range();
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return this.get0(temporalField);
        }
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.EPOCH_DAY) {
                return this.toEpochDay();
            }
            if (temporalField == ChronoField.PROLEPTIC_MONTH) {
                return this.getProlepticMonth();
            }
            return this.get0(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private int get0(TemporalField temporalField) {
        switch ((ChronoField)temporalField) {
            case DAY_OF_WEEK: {
                return this.getDayOfWeek().getValue();
            }
            case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                return (this.day - 1) % 7 + 1;
            }
            case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                return (this.getDayOfYear() - 1) % 7 + 1;
            }
            case DAY_OF_MONTH: {
                return this.day;
            }
            case DAY_OF_YEAR: {
                return this.getDayOfYear();
            }
            case EPOCH_DAY: {
                throw new DateTimeException("Field too large for an int: " + temporalField);
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return (this.day - 1) / 7 + 1;
            }
            case ALIGNED_WEEK_OF_YEAR: {
                return (this.getDayOfYear() - 1) / 7 + 1;
            }
            case MONTH_OF_YEAR: {
                return this.month;
            }
            case PROLEPTIC_MONTH: {
                throw new DateTimeException("Field too large for an int: " + temporalField);
            }
            case YEAR_OF_ERA: {
                return this.year >= 1 ? this.year : 1 - this.year;
            }
            case YEAR: {
                return this.year;
            }
            case ERA: {
                return this.year >= 1 ? 1 : 0;
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)(this.month - 1);
    }

    public IsoChronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    public Era getEra() {
        return super.getEra();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        return Month.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return this.getMonth().firstDayOfYear(this.isLeapYear()) + this.day - 1;
    }

    public DayOfWeek getDayOfWeek() {
        int n = Jdk8Methods.floorMod(this.toEpochDay() + 3L, 7);
        return DayOfWeek.of(n + 1);
    }

    public boolean isLeapYear() {
        return IsoChronology.INSTANCE.isLeapYear(this.year);
    }

    public int lengthOfMonth() {
        switch (this.month) {
            case 2: {
                return this.isLeapYear() ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public LocalDate with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return (LocalDate)temporalAdjuster;
        }
        return (LocalDate)temporalAdjuster.adjustInto(this);
    }

    public LocalDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            switch (chronoField) {
                case DAY_OF_WEEK: {
                    return this.plusDays(l - (long)this.getDayOfWeek().getValue());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return this.withDayOfMonth((int)l);
                }
                case DAY_OF_YEAR: {
                    return this.withDayOfYear((int)l);
                }
                case EPOCH_DAY: {
                    return LocalDate.ofEpochDay(l);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusWeeks(l - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH));
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusWeeks(l - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR));
                }
                case MONTH_OF_YEAR: {
                    return this.withMonth((int)l);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(l - this.getLong(ChronoField.PROLEPTIC_MONTH));
                }
                case YEAR_OF_ERA: {
                    return this.withYear((int)(this.year >= 1 ? l : 1L - l));
                }
                case YEAR: {
                    return this.withYear((int)l);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == l ? this : this.withYear(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return (LocalDate)temporalField.adjustInto(this, l);
    }

    public LocalDate withYear(int n) {
        if (this.year == n) {
            return this;
        }
        ChronoField.YEAR.checkValidValue(n);
        return LocalDate.resolvePreviousValid(n, this.month, this.day);
    }

    public LocalDate withMonth(int n) {
        if (this.month == n) {
            return this;
        }
        ChronoField.MONTH_OF_YEAR.checkValidValue(n);
        return LocalDate.resolvePreviousValid(this.year, n, this.day);
    }

    public LocalDate withDayOfMonth(int n) {
        if (this.day == n) {
            return this;
        }
        return LocalDate.of(this.year, this.month, n);
    }

    public LocalDate withDayOfYear(int n) {
        if (this.getDayOfYear() == n) {
            return this;
        }
        return LocalDate.ofYearDay(this.year, n);
    }

    public LocalDate plus(TemporalAmount temporalAmount) {
        return (LocalDate)temporalAmount.addTo(this);
    }

    public LocalDate plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case DAYS: {
                    return this.plusDays(l);
                }
                case WEEKS: {
                    return this.plusWeeks(l);
                }
                case MONTHS: {
                    return this.plusMonths(l);
                }
                case YEARS: {
                    return this.plusYears(l);
                }
                case DECADES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 10));
                }
                case CENTURIES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 100));
                }
                case MILLENNIA: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 1000));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Jdk8Methods.safeAdd(this.getLong(ChronoField.ERA), l));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return (LocalDate)temporalUnit.addTo(this, l);
    }

    public LocalDate plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        int n = ChronoField.YEAR.checkValidIntValue((long)this.year + l);
        return LocalDate.resolvePreviousValid(n, this.month, this.day);
    }

    public LocalDate plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year * 12L + (long)(this.month - 1);
        long l3 = l2 + l;
        int n = ChronoField.YEAR.checkValidIntValue(Jdk8Methods.floorDiv(l3, 12L));
        int n2 = Jdk8Methods.floorMod(l3, 12) + 1;
        return LocalDate.resolvePreviousValid(n, n2, this.day);
    }

    public LocalDate plusWeeks(long l) {
        return this.plusDays(Jdk8Methods.safeMultiply(l, 7));
    }

    public LocalDate plusDays(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = Jdk8Methods.safeAdd(this.toEpochDay(), l);
        return LocalDate.ofEpochDay(l2);
    }

    public LocalDate minus(TemporalAmount temporalAmount) {
        return (LocalDate)temporalAmount.subtractFrom(this);
    }

    public LocalDate minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public LocalDate minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public LocalDate minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public LocalDate minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public LocalDate minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.localDate()) {
            return this;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return super.adjustInto(temporal);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        LocalDate localDate = LocalDate.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case DAYS: {
                    return this.daysUntil(localDate);
                }
                case WEEKS: {
                    return this.daysUntil(localDate) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(localDate);
                }
                case YEARS: {
                    return this.monthsUntil(localDate) / 12L;
                }
                case DECADES: {
                    return this.monthsUntil(localDate) / 120L;
                }
                case CENTURIES: {
                    return this.monthsUntil(localDate) / 1200L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(localDate) / 12000L;
                }
                case ERAS: {
                    return localDate.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, localDate);
    }

    long daysUntil(LocalDate localDate) {
        return localDate.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(LocalDate localDate) {
        long l = this.getProlepticMonth() * 32L + (long)this.getDayOfMonth();
        long l2 = localDate.getProlepticMonth() * 32L + (long)localDate.getDayOfMonth();
        return (l2 - l) / 32L;
    }

    public Period until(ChronoLocalDate chronoLocalDate) {
        LocalDate localDate = LocalDate.from(chronoLocalDate);
        long l = localDate.getProlepticMonth() - this.getProlepticMonth();
        int n = localDate.day - this.day;
        if (l > 0L && n < 0) {
            LocalDate localDate2 = this.plusMonths(--l);
            n = (int)(localDate.toEpochDay() - localDate2.toEpochDay());
        } else if (l < 0L && n > 0) {
            ++l;
            n -= localDate.lengthOfMonth();
        }
        long l2 = l / 12L;
        int n2 = (int)(l % 12L);
        return Period.of(Jdk8Methods.safeToInt(l2), n2, n);
    }

    public LocalDateTime atTime(LocalTime localTime) {
        return LocalDateTime.of(this, localTime);
    }

    public LocalDateTime atTime(int n, int n2) {
        return this.atTime(LocalTime.of(n, n2));
    }

    public LocalDateTime atTime(int n, int n2, int n3) {
        return this.atTime(LocalTime.of(n, n2, n3));
    }

    public LocalDateTime atTime(int n, int n2, int n3, int n4) {
        return this.atTime(LocalTime.of(n, n2, n3, n4));
    }

    public OffsetDateTime atTime(OffsetTime offsetTime) {
        return OffsetDateTime.of(LocalDateTime.of(this, offsetTime.toLocalTime()), offsetTime.getOffset());
    }

    public LocalDateTime atStartOfDay() {
        return LocalDateTime.of(this, LocalTime.MIDNIGHT);
    }

    public ZonedDateTime atStartOfDay(ZoneId zoneId) {
        ZoneRules zoneRules;
        ZoneOffsetTransition zoneOffsetTransition;
        Jdk8Methods.requireNonNull(zoneId, "zone");
        LocalDateTime localDateTime = this.atTime(LocalTime.MIDNIGHT);
        if (!(zoneId instanceof ZoneOffset) && (zoneOffsetTransition = (zoneRules = zoneId.getRules()).getTransition(localDateTime)) != null && zoneOffsetTransition.isGap()) {
            localDateTime = zoneOffsetTransition.getDateTimeAfter();
        }
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    public long toEpochDay() {
        long l = this.year;
        long l2 = this.month;
        long l3 = 0L;
        l3 += 365L * l;
        l3 = l >= 0L ? (l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l3 -= l / -4L - l / -100L + l / -400L);
        l3 += (367L * l2 - 362L) / 12L;
        l3 += (long)(this.day - 1);
        if (l2 > 2L) {
            --l3;
            if (!this.isLeapYear()) {
                --l3;
            }
        }
        return l3 - 719528L;
    }

    public int compareTo(ChronoLocalDate chronoLocalDate) {
        if (chronoLocalDate instanceof LocalDate) {
            return this.compareTo0((LocalDate)chronoLocalDate);
        }
        return super.compareTo(chronoLocalDate);
    }

    int compareTo0(LocalDate localDate) {
        int n = this.year - localDate.year;
        if (n == 0 && (n = this.month - localDate.month) == 0) {
            n = this.day - localDate.day;
        }
        return n;
    }

    public boolean isAfter(ChronoLocalDate chronoLocalDate) {
        if (chronoLocalDate instanceof LocalDate) {
            return this.compareTo0((LocalDate)chronoLocalDate) > 0;
        }
        return super.isAfter(chronoLocalDate);
    }

    public boolean isBefore(ChronoLocalDate chronoLocalDate) {
        if (chronoLocalDate instanceof LocalDate) {
            return this.compareTo0((LocalDate)chronoLocalDate) < 0;
        }
        return super.isBefore(chronoLocalDate);
    }

    public boolean isEqual(ChronoLocalDate chronoLocalDate) {
        if (chronoLocalDate instanceof LocalDate) {
            return this.compareTo0((LocalDate)chronoLocalDate) == 0;
        }
        return super.isEqual(chronoLocalDate);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDate) {
            return this.compareTo0((LocalDate)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.year;
        short s = this.month;
        short s2 = this.day;
        return n & 0xFFFFF800 ^ (n << 11) + (s << 6) + s2;
    }

    public String toString() {
        int n = this.year;
        short s = this.month;
        short s2 = this.day;
        int n2 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder(10);
        if (n2 < 1000) {
            if (n < 0) {
                stringBuilder.append(n - 10000).deleteCharAt(1);
            } else {
                stringBuilder.append(n + 10000).deleteCharAt(0);
            }
        } else {
            if (n > 9999) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n);
        }
        return stringBuilder.append(s < 10 ? "-0" : "-").append(s).append(s2 < 10 ? "-0" : "-").append(s2).toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        return super.format(dateTimeFormatter);
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
    }

    static LocalDate readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return LocalDate.of(n, by, (int)by2);
    }
}

