/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Comparator;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.OffsetDateTime$1;
import oz.threeten.bp.OffsetDateTime$2;
import oz.threeten.bp.OffsetTime;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.ZonedDateTime;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporal;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneRules;

public final class OffsetDateTime
extends DefaultInterfaceTemporal
implements Serializable,
Comparable,
Temporal,
TemporalAdjuster {
    public static final OffsetDateTime MIN = LocalDateTime.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetDateTime MAX = LocalDateTime.MAX.atOffset(ZoneOffset.MIN);
    public static final TemporalQuery FROM = new OffsetDateTime$1();
    private static final Comparator INSTANT_COMPARATOR = new OffsetDateTime$2();
    private static final long serialVersionUID = 2287754244819255394L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static Comparator timeLineOrder() {
        return INSTANT_COMPARATOR;
    }

    public static OffsetDateTime now() {
        return OffsetDateTime.now(Clock.systemDefaultZone());
    }

    public static OffsetDateTime now(ZoneId zoneId) {
        return OffsetDateTime.now(Clock.system(zoneId));
    }

    public static OffsetDateTime now(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return OffsetDateTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static OffsetDateTime of(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(instant, "instant");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetDateTime) {
            return (OffsetDateTime)temporalAccessor;
        }
        try {
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            try {
                LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
                return OffsetDateTime.of(localDateTime, zoneOffset);
            }
            catch (DateTimeException dateTimeException) {
                Instant instant = Instant.from(temporalAccessor);
                return OffsetDateTime.ofInstant(instant, zoneOffset);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetDateTime from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static OffsetDateTime parse(CharSequence charSequence) {
        return OffsetDateTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static OffsetDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (OffsetDateTime)dateTimeFormatter.parse(charSequence, FROM);
    }

    private OffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        this.dateTime = (LocalDateTime)Jdk8Methods.requireNonNull(localDateTime, "dateTime");
        this.offset = (ZoneOffset)Jdk8Methods.requireNonNull(zoneOffset, "offset");
    }

    private OffsetDateTime with(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (this.dateTime == localDateTime && this.offset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased() || temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.dateTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new DateTimeException("Field too large for an int: " + temporalField);
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(temporalField);
        }
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        return this.with(this.dateTime, zoneOffset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getTotalSeconds() - this.offset.getTotalSeconds();
        LocalDateTime localDateTime = this.dateTime.plusSeconds(n);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    public OffsetDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate || temporalAdjuster instanceof LocalTime || temporalAdjuster instanceof LocalDateTime) {
            return this.with(this.dateTime.with(temporalAdjuster), this.offset);
        }
        if (temporalAdjuster instanceof Instant) {
            return OffsetDateTime.ofInstant((Instant)temporalAdjuster, this.offset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.dateTime, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetDateTime) {
            return (OffsetDateTime)temporalAdjuster;
        }
        return (OffsetDateTime)temporalAdjuster.adjustInto(this);
    }

    public OffsetDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return OffsetDateTime.ofInstant(Instant.ofEpochSecond(l, this.getNano()), this.offset);
                }
                case OFFSET_SECONDS: {
                    return this.with(this.dateTime, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
                }
            }
            return this.with(this.dateTime.with(temporalField, l), this.offset);
        }
        return (OffsetDateTime)temporalField.adjustInto(this, l);
    }

    public OffsetDateTime withYear(int n) {
        return this.with(this.dateTime.withYear(n), this.offset);
    }

    public OffsetDateTime withMonth(int n) {
        return this.with(this.dateTime.withMonth(n), this.offset);
    }

    public OffsetDateTime withDayOfMonth(int n) {
        return this.with(this.dateTime.withDayOfMonth(n), this.offset);
    }

    public OffsetDateTime withDayOfYear(int n) {
        return this.with(this.dateTime.withDayOfYear(n), this.offset);
    }

    public OffsetDateTime withHour(int n) {
        return this.with(this.dateTime.withHour(n), this.offset);
    }

    public OffsetDateTime withMinute(int n) {
        return this.with(this.dateTime.withMinute(n), this.offset);
    }

    public OffsetDateTime withSecond(int n) {
        return this.with(this.dateTime.withSecond(n), this.offset);
    }

    public OffsetDateTime withNano(int n) {
        return this.with(this.dateTime.withNano(n), this.offset);
    }

    public OffsetDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.dateTime.truncatedTo(temporalUnit), this.offset);
    }

    public OffsetDateTime plus(TemporalAmount temporalAmount) {
        return (OffsetDateTime)temporalAmount.addTo(this);
    }

    public OffsetDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(l, temporalUnit), this.offset);
        }
        return (OffsetDateTime)temporalUnit.addTo(this, l);
    }

    public OffsetDateTime plusYears(long l) {
        return this.with(this.dateTime.plusYears(l), this.offset);
    }

    public OffsetDateTime plusMonths(long l) {
        return this.with(this.dateTime.plusMonths(l), this.offset);
    }

    public OffsetDateTime plusWeeks(long l) {
        return this.with(this.dateTime.plusWeeks(l), this.offset);
    }

    public OffsetDateTime plusDays(long l) {
        return this.with(this.dateTime.plusDays(l), this.offset);
    }

    public OffsetDateTime plusHours(long l) {
        return this.with(this.dateTime.plusHours(l), this.offset);
    }

    public OffsetDateTime plusMinutes(long l) {
        return this.with(this.dateTime.plusMinutes(l), this.offset);
    }

    public OffsetDateTime plusSeconds(long l) {
        return this.with(this.dateTime.plusSeconds(l), this.offset);
    }

    public OffsetDateTime plusNanos(long l) {
        return this.with(this.dateTime.plusNanos(l), this.offset);
    }

    public OffsetDateTime minus(TemporalAmount temporalAmount) {
        return (OffsetDateTime)temporalAmount.subtractFrom(this);
    }

    public OffsetDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public OffsetDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public OffsetDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public OffsetDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public OffsetDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public OffsetDateTime minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    public OffsetDateTime minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    public OffsetDateTime minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    public OffsetDateTime minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return this.getOffset();
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return this.toLocalDate();
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.zoneId()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        OffsetDateTime offsetDateTime = OffsetDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            offsetDateTime = offsetDateTime.withOffsetSameInstant(this.offset);
            return this.dateTime.until(offsetDateTime.dateTime, temporalUnit);
        }
        return temporalUnit.between(this, offsetDateTime);
    }

    public ZonedDateTime atZoneSameInstant(ZoneId zoneId) {
        return ZonedDateTime.ofInstant(this.dateTime, this.offset, zoneId);
    }

    public ZonedDateTime atZoneSimilarLocal(ZoneId zoneId) {
        return ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime.of(this.dateTime.toLocalTime(), this.offset);
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.dateTime, this.offset);
    }

    public Instant toInstant() {
        return this.dateTime.toInstant(this.offset);
    }

    public long toEpochSecond() {
        return this.dateTime.toEpochSecond(this.offset);
    }

    public int compareTo(OffsetDateTime offsetDateTime) {
        if (this.getOffset().equals(offsetDateTime.getOffset())) {
            return this.toLocalDateTime().compareTo(offsetDateTime.toLocalDateTime());
        }
        int n = Jdk8Methods.compareLongs(this.toEpochSecond(), offsetDateTime.toEpochSecond());
        if (n == 0 && (n = this.toLocalTime().getNano() - offsetDateTime.toLocalTime().getNano()) == 0) {
            n = this.toLocalDateTime().compareTo(offsetDateTime.toLocalDateTime());
        }
        return n;
    }

    public boolean isAfter(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 > (l = offsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() > offsetDateTime.toLocalTime().getNano();
    }

    public boolean isBefore(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 < (l = offsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() < offsetDateTime.toLocalTime().getNano();
    }

    public boolean isEqual(OffsetDateTime offsetDateTime) {
        return this.toEpochSecond() == offsetDateTime.toEpochSecond() && this.toLocalTime().getNano() == offsetDateTime.toLocalTime().getNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return this.dateTime.equals(offsetDateTime.dateTime) && this.offset.equals(offsetDateTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + this.offset.toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    private Object writeReplace() {
        return new Ser(69, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        this.dateTime.writeExternal(dataOutput);
        this.offset.writeExternal(dataOutput);
    }

    static OffsetDateTime readExternal(DataInput dataInput) {
        LocalDateTime localDateTime = LocalDateTime.readExternal(dataInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(dataInput);
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }
}

