/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.OffsetDateTime;
import oz.threeten.bp.OffsetTime$1;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneRules;

public final class OffsetTime
extends DefaultInterfaceTemporalAccessor
implements Serializable,
Comparable,
Temporal,
TemporalAdjuster {
    public static final OffsetTime MIN = LocalTime.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetTime MAX = LocalTime.MAX.atOffset(ZoneOffset.MIN);
    public static final TemporalQuery FROM = new OffsetTime$1();
    private static final long serialVersionUID = 7264499704384272492L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime now() {
        return OffsetTime.now(Clock.systemDefaultZone());
    }

    public static OffsetTime now(ZoneId zoneId) {
        return OffsetTime.now(Clock.system(zoneId));
    }

    public static OffsetTime now(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return OffsetTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static OffsetTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime of(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        return new OffsetTime(LocalTime.of(n, n2, n3, n4), zoneOffset);
    }

    public static OffsetTime ofInstant(Instant instant, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(instant, "instant");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() % 86400L;
        l = (l + (long)zoneOffset.getTotalSeconds()) % 86400L;
        if (l < 0L) {
            l += 86400L;
        }
        LocalTime localTime = LocalTime.ofSecondOfDay(l, instant.getNano());
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetTime) {
            return (OffsetTime)temporalAccessor;
        }
        try {
            LocalTime localTime = LocalTime.from(temporalAccessor);
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            return new OffsetTime(localTime, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetTime from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static OffsetTime parse(CharSequence charSequence) {
        return OffsetTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_TIME);
    }

    public static OffsetTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (OffsetTime)dateTimeFormatter.parse(charSequence, FROM);
    }

    private OffsetTime(LocalTime localTime, ZoneOffset zoneOffset) {
        this.time = (LocalTime)Jdk8Methods.requireNonNull(localTime, "time");
        this.offset = (ZoneOffset)Jdk8Methods.requireNonNull(zoneOffset, "offset");
    }

    private OffsetTime with(LocalTime localTime, ZoneOffset zoneOffset) {
        if (this.time == localTime && this.offset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetTime(localTime, zoneOffset);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.time.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.time.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        return zoneOffset != null && zoneOffset.equals(this.offset) ? this : new OffsetTime(this.time, zoneOffset);
    }

    public OffsetTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getTotalSeconds() - this.offset.getTotalSeconds();
        LocalTime localTime = this.time.plusSeconds(n);
        return new OffsetTime(localTime, zoneOffset);
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getNano() {
        return this.time.getNano();
    }

    public OffsetTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalTime) {
            return this.with((LocalTime)temporalAdjuster, this.offset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.time, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetTime) {
            return (OffsetTime)temporalAdjuster;
        }
        return (OffsetTime)temporalAdjuster.adjustInto(this);
    }

    public OffsetTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                return this.with(this.time, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.time.with(temporalField, l), this.offset);
        }
        return (OffsetTime)temporalField.adjustInto(this, l);
    }

    public OffsetTime withHour(int n) {
        return this.with(this.time.withHour(n), this.offset);
    }

    public OffsetTime withMinute(int n) {
        return this.with(this.time.withMinute(n), this.offset);
    }

    public OffsetTime withSecond(int n) {
        return this.with(this.time.withSecond(n), this.offset);
    }

    public OffsetTime withNano(int n) {
        return this.with(this.time.withNano(n), this.offset);
    }

    public OffsetTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.time.truncatedTo(temporalUnit), this.offset);
    }

    public OffsetTime plus(TemporalAmount temporalAmount) {
        return (OffsetTime)temporalAmount.addTo(this);
    }

    public OffsetTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.time.plus(l, temporalUnit), this.offset);
        }
        return (OffsetTime)temporalUnit.addTo(this, l);
    }

    public OffsetTime plusHours(long l) {
        return this.with(this.time.plusHours(l), this.offset);
    }

    public OffsetTime plusMinutes(long l) {
        return this.with(this.time.plusMinutes(l), this.offset);
    }

    public OffsetTime plusSeconds(long l) {
        return this.with(this.time.plusSeconds(l), this.offset);
    }

    public OffsetTime plusNanos(long l) {
        return this.with(this.time.plusNanos(l), this.offset);
    }

    public OffsetTime minus(TemporalAmount temporalAmount) {
        return (OffsetTime)temporalAmount.subtractFrom(this);
    }

    public OffsetTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public OffsetTime minusHours(long l) {
        return this.with(this.time.minusHours(l), this.offset);
    }

    public OffsetTime minusMinutes(long l) {
        return this.with(this.time.minusMinutes(l), this.offset);
    }

    public OffsetTime minusSeconds(long l) {
        return this.with(this.time.minusSeconds(l), this.offset);
    }

    public OffsetTime minusNanos(long l) {
        return this.with(this.time.minusNanos(l), this.offset);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return this.getOffset();
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return this.time;
        }
        if (temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.zoneId()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.NANO_OF_DAY, this.time.toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        OffsetTime offsetTime = OffsetTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = offsetTime.toEpochNano() - this.toEpochNano();
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return l;
                }
                case MICROS: {
                    return l / 1000L;
                }
                case MILLIS: {
                    return l / 1000000L;
                }
                case SECONDS: {
                    return l / 1000000000L;
                }
                case MINUTES: {
                    return l / 60000000000L;
                }
                case HOURS: {
                    return l / 3600000000000L;
                }
                case HALF_DAYS: {
                    return l / 43200000000000L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, offsetTime);
    }

    public OffsetDateTime atDate(LocalDate localDate) {
        return OffsetDateTime.of(localDate, this.time, this.offset);
    }

    public LocalTime toLocalTime() {
        return this.time;
    }

    private long toEpochNano() {
        long l = this.time.toNanoOfDay();
        long l2 = (long)this.offset.getTotalSeconds() * 1000000000L;
        return l - l2;
    }

    public int compareTo(OffsetTime offsetTime) {
        if (this.offset.equals(offsetTime.offset)) {
            return this.time.compareTo(offsetTime.time);
        }
        int n = Jdk8Methods.compareLongs(this.toEpochNano(), offsetTime.toEpochNano());
        if (n == 0) {
            n = this.time.compareTo(offsetTime.time);
        }
        return n;
    }

    public boolean isAfter(OffsetTime offsetTime) {
        return this.toEpochNano() > offsetTime.toEpochNano();
    }

    public boolean isBefore(OffsetTime offsetTime) {
        return this.toEpochNano() < offsetTime.toEpochNano();
    }

    public boolean isEqual(OffsetTime offsetTime) {
        return this.toEpochNano() == offsetTime.toEpochNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return this.time.equals(offsetTime.time) && this.offset.equals(offsetTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.time.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.time.toString() + this.offset.toString();
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    private Object writeReplace() {
        return new Ser(66, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        this.time.writeExternal(dataOutput);
        this.offset.writeExternal(dataOutput);
    }

    static OffsetTime readExternal(DataInput dataInput) {
        LocalTime localTime = LocalTime.readExternal(dataInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(dataInput);
        return OffsetTime.of(localTime, zoneOffset);
    }
}

