/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeParseException;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;

public final class Period
extends ChronoPeriod
implements Serializable {
    public static final Period ZERO = new Period(0, 0, 0);
    private static final long serialVersionUID = -8290556941213247973L;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?", 2);
    private final int years;
    private final int months;
    private final int days;

    public static Period ofYears(int n) {
        return Period.create(n, 0, 0);
    }

    public static Period ofMonths(int n) {
        return Period.create(0, n, 0);
    }

    public static Period ofWeeks(int n) {
        return Period.create(0, 0, Jdk8Methods.safeMultiply(n, 7));
    }

    public static Period ofDays(int n) {
        return Period.create(0, 0, n);
    }

    public static Period of(int n, int n2, int n3) {
        return Period.create(n, n2, n3);
    }

    public static Period from(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            return (Period)temporalAmount;
        }
        if (temporalAmount instanceof ChronoPeriod && !IsoChronology.INSTANCE.equals(((ChronoPeriod)temporalAmount).getChronology())) {
            throw new DateTimeException("Period requires ISO chronology: " + temporalAmount);
        }
        Jdk8Methods.requireNonNull(temporalAmount, "amount");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (TemporalUnit temporalUnit : temporalAmount.getUnits()) {
            long l = temporalAmount.get(temporalUnit);
            if (temporalUnit == ChronoUnit.YEARS) {
                n = Jdk8Methods.safeToInt(l);
                continue;
            }
            if (temporalUnit == ChronoUnit.MONTHS) {
                n2 = Jdk8Methods.safeToInt(l);
                continue;
            }
            if (temporalUnit == ChronoUnit.DAYS) {
                n3 = Jdk8Methods.safeToInt(l);
                continue;
            }
            throw new DateTimeException("Unit must be Years, Months or Days, but was " + temporalUnit);
        }
        return Period.create(n, n2, n3);
    }

    public static Period between(LocalDate localDate, LocalDate localDate2) {
        return localDate.until(localDate2);
    }

    public static Period parse(CharSequence charSequence) {
        Jdk8Methods.requireNonNull(charSequence, "text");
        Matcher matcher = PATTERN.matcher(charSequence);
        if (matcher.matches()) {
            int n = "-".equals(matcher.group(1)) ? -1 : 1;
            String string = matcher.group(2);
            String string2 = matcher.group(3);
            String string3 = matcher.group(4);
            String string4 = matcher.group(5);
            if (string != null || string2 != null || string3 != null || string4 != null) {
                try {
                    int n2 = Period.parseNumber(charSequence, string, n);
                    int n3 = Period.parseNumber(charSequence, string2, n);
                    int n4 = Period.parseNumber(charSequence, string3, n);
                    int n5 = Period.parseNumber(charSequence, string4, n);
                    n5 = Jdk8Methods.safeAdd(n5, Jdk8Methods.safeMultiply(n4, 7));
                    return Period.create(n2, n3, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0).initCause(numberFormatException);
                }
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0);
    }

    private static int parseNumber(CharSequence charSequence, String string, int n) {
        if (string == null) {
            return 0;
        }
        int n2 = Integer.parseInt(string);
        try {
            return Jdk8Methods.safeMultiply(n2, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw (DateTimeParseException)new DateTimeParseException("Text cannot be parsed to a Period", charSequence, 0).initCause(arithmeticException);
        }
    }

    private static Period create(int n, int n2, int n3) {
        if ((n | n2 | n3) == 0) {
            return ZERO;
        }
        return new Period(n, n2, n3);
    }

    private Period(int n, int n2, int n3) {
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    private Object readResolve() {
        if ((this.years | this.months | this.days) == 0) {
            return ZERO;
        }
        return this;
    }

    public List getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS));
    }

    public Chronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    public long get(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.YEARS) {
            return this.years;
        }
        if (temporalUnit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.days;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public boolean isNegative() {
        return this.years < 0 || this.months < 0 || this.days < 0;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Period withYears(int n) {
        if (n == this.years) {
            return this;
        }
        return Period.create(n, this.months, this.days);
    }

    public Period withMonths(int n) {
        if (n == this.months) {
            return this;
        }
        return Period.create(this.years, n, this.days);
    }

    public Period withDays(int n) {
        if (n == this.days) {
            return this;
        }
        return Period.create(this.years, this.months, n);
    }

    public Period plus(TemporalAmount temporalAmount) {
        Period period = Period.from(temporalAmount);
        return Period.create(Jdk8Methods.safeAdd(this.years, period.years), Jdk8Methods.safeAdd(this.months, period.months), Jdk8Methods.safeAdd(this.days, period.days));
    }

    public Period plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.years, l)), this.months, this.days);
    }

    public Period plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(this.years, Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.months, l)), this.days);
    }

    public Period plusDays(long l) {
        if (l == 0L) {
            return this;
        }
        return Period.create(this.years, this.months, Jdk8Methods.safeToInt(Jdk8Methods.safeAdd((long)this.days, l)));
    }

    public Period minus(TemporalAmount temporalAmount) {
        Period period = Period.from(temporalAmount);
        return Period.create(Jdk8Methods.safeSubtract(this.years, period.years), Jdk8Methods.safeSubtract(this.months, period.months), Jdk8Methods.safeSubtract(this.days, period.days));
    }

    public Period minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public Period minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public Period minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public Period multipliedBy(int n) {
        if (this == ZERO || n == 1) {
            return this;
        }
        return Period.create(Jdk8Methods.safeMultiply(this.years, n), Jdk8Methods.safeMultiply(this.months, n), Jdk8Methods.safeMultiply(this.days, n));
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period normalized() {
        long l = this.toTotalMonths();
        long l2 = l / 12L;
        int n = (int)(l % 12L);
        if (l2 == (long)this.years && n == this.months) {
            return this;
        }
        return Period.create(Jdk8Methods.safeToInt(l2), n, this.days);
    }

    public long toTotalMonths() {
        return (long)this.years * 12L + (long)this.months;
    }

    public Temporal addTo(Temporal temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        if (this.years != 0) {
            temporal = this.months != 0 ? temporal.plus(this.toTotalMonths(), ChronoUnit.MONTHS) : temporal.plus(this.years, ChronoUnit.YEARS);
        } else if (this.months != 0) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    public Temporal subtractFrom(Temporal temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        if (this.years != 0) {
            temporal = this.months != 0 ? temporal.minus(this.toTotalMonths(), ChronoUnit.MONTHS) : temporal.minus(this.years, ChronoUnit.YEARS);
        } else if (this.months != 0) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return this.years == period.years && this.months == period.months && this.days == period.days;
        }
        return false;
    }

    public int hashCode() {
        return this.years + Integer.rotateLeft(this.months, 8) + Integer.rotateLeft(this.days, 16);
    }

    public String toString() {
        if (this == ZERO) {
            return "P0D";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('P');
        if (this.years != 0) {
            stringBuilder.append(this.years).append('Y');
        }
        if (this.months != 0) {
            stringBuilder.append(this.months).append('M');
        }
        if (this.days != 0) {
            stringBuilder.append(this.days).append('D');
        }
        return stringBuilder.toString();
    }
}

