/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.Month;
import oz.threeten.bp.MonthDay;
import oz.threeten.bp.Ser;
import oz.threeten.bp.Year$1;
import oz.threeten.bp.YearMonth;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporalAccessor;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class Year
extends DefaultInterfaceTemporalAccessor
implements Serializable,
Comparable,
Temporal,
TemporalAdjuster {
    public static final int MIN_VALUE = -999999999;
    public static final int MAX_VALUE = 999999999;
    public static final TemporalQuery FROM = new Year$1();
    private static final long serialVersionUID = -23038383694477807L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
    private final int year;

    public static Year now() {
        return Year.now(Clock.systemDefaultZone());
    }

    public static Year now(ZoneId zoneId) {
        return Year.now(Clock.system(zoneId));
    }

    public static Year now(Clock clock) {
        LocalDate localDate = LocalDate.now(clock);
        return Year.of(localDate.getYear());
    }

    public static Year of(int n) {
        ChronoField.YEAR.checkValidValue(n);
        return new Year(n);
    }

    public static Year from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof Year) {
            return (Year)temporalAccessor;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporalAccessor))) {
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            return Year.of(temporalAccessor.get(ChronoField.YEAR));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain Year from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static Year parse(CharSequence charSequence) {
        return Year.parse(charSequence, PARSER);
    }

    public static Year parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (Year)dateTimeFormatter.parse(charSequence, FROM);
    }

    public static boolean isLeap(long l) {
        return (l & 3L) == 0L && (l % 100L != 0L || l % 400L == 0L);
    }

    private Year(int n) {
        this.year = n;
    }

    public int getValue() {
        return this.year;
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.YEAR || temporalField == ChronoField.YEAR_OF_ERA || temporalField == ChronoField.ERA;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit == ChronoUnit.YEARS || temporalUnit == ChronoUnit.DECADES || temporalUnit == ChronoUnit.CENTURIES || temporalUnit == ChronoUnit.MILLENNIA || temporalUnit == ChronoUnit.ERAS;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.YEAR_OF_ERA) {
            return this.year <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
        }
        return super.range(temporalField);
    }

    public int get(TemporalField temporalField) {
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case YEAR_OF_ERA: {
                    return this.year < 1 ? 1 - this.year : this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year < 1 ? 0 : 1;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public boolean isLeap() {
        return Year.isLeap(this.year);
    }

    public boolean isValidMonthDay(MonthDay monthDay) {
        return monthDay != null && monthDay.isValidYear(this.year);
    }

    public int length() {
        return this.isLeap() ? 366 : 365;
    }

    public Year with(TemporalAdjuster temporalAdjuster) {
        return (Year)temporalAdjuster.adjustInto(this);
    }

    public Year with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            switch (chronoField) {
                case YEAR_OF_ERA: {
                    return Year.of((int)(this.year < 1 ? 1L - l : l));
                }
                case YEAR: {
                    return Year.of((int)l);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == l ? this : Year.of(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return (Year)temporalField.adjustInto(this, l);
    }

    public Year plus(TemporalAmount temporalAmount) {
        return (Year)temporalAmount.addTo(this);
    }

    public Year plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case YEARS: {
                    return this.plusYears(l);
                }
                case DECADES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 10));
                }
                case CENTURIES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 100));
                }
                case MILLENNIA: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 1000));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Jdk8Methods.safeAdd(this.getLong(ChronoField.ERA), l));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return (Year)temporalUnit.addTo(this, l);
    }

    public Year plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        return Year.of(ChronoField.YEAR.checkValidIntValue((long)this.year + l));
    }

    public Year minus(TemporalAmount temporalAmount) {
        return (Year)temporalAmount.subtractFrom(this);
    }

    public Year minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public Year minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.YEARS;
        }
        if (temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.YEAR, this.year);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        Year year = Year.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = (long)year.year - (long)this.year;
            switch ((ChronoUnit)temporalUnit) {
                case YEARS: {
                    return l;
                }
                case DECADES: {
                    return l / 10L;
                }
                case CENTURIES: {
                    return l / 100L;
                }
                case MILLENNIA: {
                    return l / 1000L;
                }
                case ERAS: {
                    return year.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, year);
    }

    public LocalDate atDay(int n) {
        return LocalDate.ofYearDay(this.year, n);
    }

    public YearMonth atMonth(Month month) {
        return YearMonth.of(this.year, month);
    }

    public YearMonth atMonth(int n) {
        return YearMonth.of(this.year, n);
    }

    public LocalDate atMonthDay(MonthDay monthDay) {
        return monthDay.atYear(this.year);
    }

    public int compareTo(Year year) {
        return this.year - year.year;
    }

    public boolean isAfter(Year year) {
        return this.year > year.year;
    }

    public boolean isBefore(Year year) {
        return this.year < year.year;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Year) {
            return this.year == ((Year)object).year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        return Integer.toString(this.year);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    private Object writeReplace() {
        return new Ser(67, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.year);
    }

    static Year readExternal(DataInput dataInput) {
        return Year.of(dataInput.readInt());
    }
}

