/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId$1;
import oz.threeten.bp.ZoneId$2;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.ZoneRegion;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesException;
import oz.threeten.bp.zone.ZoneRulesProvider;

public abstract class ZoneId
implements Serializable {
    public static final TemporalQuery FROM = new ZoneId$1();
    public static final Map SHORT_IDS;
    private static final long serialVersionUID = 8352817235686L;

    public static ZoneId systemDefault() {
        return ZoneId.of(TimeZone.getDefault().getID(), SHORT_IDS);
    }

    public static Set getAvailableZoneIds() {
        return new HashSet(ZoneRulesProvider.getAvailableZoneIds());
    }

    public static ZoneId of(String string, Map map) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        Jdk8Methods.requireNonNull(map, "aliasMap");
        String string2 = (String)map.get(string);
        string2 = string2 != null ? string2 : string;
        return ZoneId.of(string2);
    }

    public static ZoneId of(String string) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        if (string.equals("Z")) {
            return ZoneOffset.UTC;
        }
        if (string.length() == 1) {
            throw new DateTimeException("Invalid zone: " + string);
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            return ZoneOffset.of(string);
        }
        if (string.equals("UTC") || string.equals("GMT") || string.equals("UT")) {
            return new ZoneRegion(string, ZoneOffset.UTC.getRules());
        }
        if (string.startsWith("UTC+") || string.startsWith("GMT+") || string.startsWith("UTC-") || string.startsWith("GMT-")) {
            ZoneOffset zoneOffset = ZoneOffset.of(string.substring(3));
            if (zoneOffset.getTotalSeconds() == 0) {
                return new ZoneRegion(string.substring(0, 3), zoneOffset.getRules());
            }
            return new ZoneRegion(string.substring(0, 3) + zoneOffset.getId(), zoneOffset.getRules());
        }
        if (string.startsWith("UT+") || string.startsWith("UT-")) {
            ZoneOffset zoneOffset = ZoneOffset.of(string.substring(2));
            if (zoneOffset.getTotalSeconds() == 0) {
                return new ZoneRegion("UT", zoneOffset.getRules());
            }
            return new ZoneRegion("UT" + zoneOffset.getId(), zoneOffset.getRules());
        }
        return ZoneRegion.ofId(string, true);
    }

    public static ZoneId ofOffset(String string, ZoneOffset zoneOffset) {
        Jdk8Methods.requireNonNull(string, "prefix");
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        if (string.length() == 0) {
            return zoneOffset;
        }
        if (string.equals("GMT") || string.equals("UTC") || string.equals("UT")) {
            if (zoneOffset.getTotalSeconds() == 0) {
                return new ZoneRegion(string, zoneOffset.getRules());
            }
            return new ZoneRegion(string + zoneOffset.getId(), zoneOffset.getRules());
        }
        throw new IllegalArgumentException("Invalid prefix, must be GMT, UTC or UT: " + string);
    }

    public static ZoneId from(TemporalAccessor temporalAccessor) {
        ZoneId zoneId = (ZoneId)temporalAccessor.query(TemporalQueries.zone());
        if (zoneId == null) {
            throw new DateTimeException("Unable to obtain ZoneId from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
        return zoneId;
    }

    ZoneId() {
        if (this.getClass() != ZoneOffset.class && this.getClass() != ZoneRegion.class) {
            throw new AssertionError((Object)"Invalid subclass");
        }
    }

    public abstract String getId();

    public abstract ZoneRules getRules();

    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendZoneText(textStyle).toFormatter(locale).format(new ZoneId$2(this));
    }

    public ZoneId normalized() {
        try {
            ZoneRules zoneRules = this.getRules();
            if (zoneRules.isFixedOffset()) {
                return zoneRules.getOffset(Instant.EPOCH);
            }
        }
        catch (ZoneRulesException zoneRulesException) {
            // empty catch block
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneId) {
            ZoneId zoneId = (ZoneId)object;
            return this.getId().equals(zoneId.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    abstract void write(DataOutput var1);

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ACT", "Australia/Darwin");
        hashMap.put("AET", "Australia/Sydney");
        hashMap.put("AGT", "America/Argentina/Buenos_Aires");
        hashMap.put("ART", "Africa/Cairo");
        hashMap.put("AST", "America/Anchorage");
        hashMap.put("BET", "America/Sao_Paulo");
        hashMap.put("BST", "Asia/Dhaka");
        hashMap.put("CAT", "Africa/Harare");
        hashMap.put("CNT", "America/St_Johns");
        hashMap.put("CST", "America/Chicago");
        hashMap.put("CTT", "Asia/Shanghai");
        hashMap.put("EAT", "Africa/Addis_Ababa");
        hashMap.put("ECT", "Europe/Paris");
        hashMap.put("IET", "America/Indiana/Indianapolis");
        hashMap.put("IST", "Asia/Kolkata");
        hashMap.put("JST", "Asia/Tokyo");
        hashMap.put("MIT", "Pacific/Apia");
        hashMap.put("NET", "Asia/Yerevan");
        hashMap.put("NST", "Pacific/Auckland");
        hashMap.put("PLT", "Asia/Karachi");
        hashMap.put("PNT", "America/Phoenix");
        hashMap.put("PRT", "America/Puerto_Rico");
        hashMap.put("PST", "America/Los_Angeles");
        hashMap.put("SST", "Pacific/Guadalcanal");
        hashMap.put("VST", "Asia/Ho_Chi_Minh");
        hashMap.put("EST", "-05:00");
        hashMap.put("MST", "-07:00");
        hashMap.put("HST", "-10:00");
        SHORT_IDS = Collections.unmodifiableMap(hashMap);
    }
}

