/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.regex.Pattern;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesException;
import oz.threeten.bp.zone.ZoneRulesProvider;

final class ZoneRegion
extends ZoneId
implements Serializable {
    private static final long serialVersionUID = 8386373296231747096L;
    private static final Pattern PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9~/._+-]+");
    private final String id;
    private final transient ZoneRules rules;

    private static ZoneRegion ofLenient(String string) {
        if (string.equals("Z") || string.startsWith("+") || string.startsWith("-")) {
            throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + string);
        }
        if (string.equals("UTC") || string.equals("GMT") || string.equals("UT")) {
            return new ZoneRegion(string, ZoneOffset.UTC.getRules());
        }
        if (string.startsWith("UTC+") || string.startsWith("GMT+") || string.startsWith("UTC-") || string.startsWith("GMT-")) {
            ZoneOffset zoneOffset = ZoneOffset.of(string.substring(3));
            if (zoneOffset.getTotalSeconds() == 0) {
                return new ZoneRegion(string.substring(0, 3), zoneOffset.getRules());
            }
            return new ZoneRegion(string.substring(0, 3) + zoneOffset.getId(), zoneOffset.getRules());
        }
        if (string.startsWith("UT+") || string.startsWith("UT-")) {
            ZoneOffset zoneOffset = ZoneOffset.of(string.substring(2));
            if (zoneOffset.getTotalSeconds() == 0) {
                return new ZoneRegion("UT", zoneOffset.getRules());
            }
            return new ZoneRegion("UT" + zoneOffset.getId(), zoneOffset.getRules());
        }
        return ZoneRegion.ofId(string, false);
    }

    static ZoneRegion ofId(String string, boolean bl) {
        ZoneRules zoneRules;
        block4: {
            Jdk8Methods.requireNonNull(string, "zoneId");
            if (string.length() < 2 || !PATTERN.matcher(string).matches()) {
                throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + string);
            }
            zoneRules = null;
            try {
                zoneRules = ZoneRulesProvider.getRules(string, true);
            }
            catch (ZoneRulesException zoneRulesException) {
                if (string.equals("GMT0")) {
                    zoneRules = ZoneOffset.UTC.getRules();
                }
                if (!bl) break block4;
                throw zoneRulesException;
            }
        }
        return new ZoneRegion(string, zoneRules);
    }

    ZoneRegion(String string, ZoneRules zoneRules) {
        this.id = string;
        this.rules = zoneRules;
    }

    public String getId() {
        return this.id;
    }

    public ZoneRules getRules() {
        return this.rules != null ? this.rules : ZoneRulesProvider.getRules(this.id, false);
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeByte(7);
        this.writeExternal(dataOutput);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeUTF(this.id);
    }

    static ZoneId readExternal(DataInput dataInput) {
        String string = dataInput.readUTF();
        return ZoneRegion.ofLenient(string);
    }
}

