/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.Serializable;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoLocalDateTimeImpl;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalUnit;

abstract class ChronoDateImpl
extends ChronoLocalDate
implements Serializable,
Temporal,
TemporalAdjuster {
    private static final long serialVersionUID = 6282433883239719096L;

    ChronoDateImpl() {
    }

    public ChronoDateImpl plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case DAYS: {
                    return this.plusDays(l);
                }
                case WEEKS: {
                    return this.plusDays(Jdk8Methods.safeMultiply(l, 7));
                }
                case MONTHS: {
                    return this.plusMonths(l);
                }
                case YEARS: {
                    return this.plusYears(l);
                }
                case DECADES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 10));
                }
                case CENTURIES: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 100));
                }
                case MILLENNIA: {
                    return this.plusYears(Jdk8Methods.safeMultiply(l, 1000));
                }
            }
            throw new DateTimeException(temporalUnit + " not valid for chronology " + this.getChronology().getId());
        }
        return (ChronoDateImpl)this.getChronology().ensureChronoLocalDate(temporalUnit.addTo(this, l));
    }

    abstract ChronoDateImpl plusYears(long var1);

    abstract ChronoDateImpl plusMonths(long var1);

    ChronoDateImpl plusWeeks(long l) {
        return this.plusDays(Jdk8Methods.safeMultiply(l, 7));
    }

    abstract ChronoDateImpl plusDays(long var1);

    ChronoDateImpl minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    ChronoDateImpl minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    ChronoDateImpl minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    ChronoDateImpl minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public ChronoLocalDateTime atTime(LocalTime localTime) {
        return ChronoLocalDateTimeImpl.of(this, localTime);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        ChronoLocalDate chronoLocalDate = this.getChronology().date(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            return LocalDate.from(this).until(chronoLocalDate, temporalUnit);
        }
        return temporalUnit.between(this, chronoLocalDate);
    }

    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        throw new UnsupportedOperationException("Not supported in ThreeTen backport");
    }
}

