/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.util.Comparator;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.chrono.ChronoLocalDate$1;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoLocalDateTimeImpl;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporal;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;

public abstract class ChronoLocalDate
extends DefaultInterfaceTemporal
implements Comparable,
Temporal,
TemporalAdjuster {
    private static final Comparator DATE_COMPARATOR = new ChronoLocalDate$1();

    public static Comparator timeLineOrder() {
        return DATE_COMPARATOR;
    }

    public static ChronoLocalDate from(TemporalAccessor temporalAccessor) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        if (temporalAccessor instanceof ChronoLocalDate) {
            return (ChronoLocalDate)temporalAccessor;
        }
        Chronology chronology = (Chronology)temporalAccessor.query(TemporalQueries.chronology());
        if (chronology == null) {
            throw new DateTimeException("No Chronology found to create ChronoLocalDate: " + temporalAccessor.getClass());
        }
        return chronology.date(temporalAccessor);
    }

    public abstract Chronology getChronology();

    public Era getEra() {
        return this.getChronology().eraOf(this.get(ChronoField.ERA));
    }

    public boolean isLeapYear() {
        return this.getChronology().isLeapYear(this.getLong(ChronoField.YEAR));
    }

    public abstract int lengthOfMonth();

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ChronoLocalDate with(TemporalAdjuster temporalAdjuster) {
        return this.getChronology().ensureChronoLocalDate(super.with(temporalAdjuster));
    }

    public abstract ChronoLocalDate with(TemporalField var1, long var2);

    public ChronoLocalDate plus(TemporalAmount temporalAmount) {
        return this.getChronology().ensureChronoLocalDate(super.plus(temporalAmount));
    }

    public abstract ChronoLocalDate plus(long var1, TemporalUnit var3);

    public ChronoLocalDate minus(TemporalAmount temporalAmount) {
        return this.getChronology().ensureChronoLocalDate(super.minus(temporalAmount));
    }

    public ChronoLocalDate minus(long l, TemporalUnit temporalUnit) {
        return this.getChronology().ensureChronoLocalDate(super.minus(l, temporalUnit));
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return this.getChronology();
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.DAYS;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return LocalDate.ofEpochDay(this.toEpochDay());
        }
        if (temporalQuery == TemporalQueries.localTime() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toEpochDay());
    }

    public abstract ChronoPeriod until(ChronoLocalDate var1);

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public ChronoLocalDateTime atTime(LocalTime localTime) {
        return ChronoLocalDateTimeImpl.of(this, localTime);
    }

    public long toEpochDay() {
        return this.getLong(ChronoField.EPOCH_DAY);
    }

    public int compareTo(ChronoLocalDate chronoLocalDate) {
        int n = Jdk8Methods.compareLongs(this.toEpochDay(), chronoLocalDate.toEpochDay());
        if (n == 0) {
            n = this.getChronology().compareTo(chronoLocalDate.getChronology());
        }
        return n;
    }

    public boolean isAfter(ChronoLocalDate chronoLocalDate) {
        return this.toEpochDay() > chronoLocalDate.toEpochDay();
    }

    public boolean isBefore(ChronoLocalDate chronoLocalDate) {
        return this.toEpochDay() < chronoLocalDate.toEpochDay();
    }

    public boolean isEqual(ChronoLocalDate chronoLocalDate) {
        return this.toEpochDay() == chronoLocalDate.toEpochDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoLocalDate) {
            return this.compareTo((ChronoLocalDate)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        long l = this.toEpochDay();
        return this.getChronology().hashCode() ^ (int)(l ^ l >>> 32);
    }

    public String toString() {
        long l = this.getLong(ChronoField.YEAR_OF_ERA);
        long l2 = this.getLong(ChronoField.MONTH_OF_YEAR);
        long l3 = this.getLong(ChronoField.DAY_OF_MONTH);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(this.getChronology().toString()).append(" ").append(this.getEra()).append(" ").append(l).append(l2 < 10L ? "-0" : "-").append(l2).append(l3 < 10L ? "-0" : "-").append(l3);
        return stringBuilder.toString();
    }
}

