/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.util.Comparator;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime$1;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.DefaultInterfaceTemporal;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;

public abstract class ChronoLocalDateTime
extends DefaultInterfaceTemporal
implements Comparable,
Temporal,
TemporalAdjuster {
    private static final Comparator DATE_TIME_COMPARATOR = new ChronoLocalDateTime$1();

    public static Comparator timeLineOrder() {
        return DATE_TIME_COMPARATOR;
    }

    public static ChronoLocalDateTime from(TemporalAccessor temporalAccessor) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        if (temporalAccessor instanceof ChronoLocalDateTime) {
            return (ChronoLocalDateTime)temporalAccessor;
        }
        Chronology chronology = (Chronology)temporalAccessor.query(TemporalQueries.chronology());
        if (chronology == null) {
            throw new DateTimeException("No Chronology found to create ChronoLocalDateTime: " + temporalAccessor.getClass());
        }
        return chronology.localDateTime(temporalAccessor);
    }

    public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public abstract ChronoLocalDate toLocalDate();

    public abstract LocalTime toLocalTime();

    public ChronoLocalDateTime with(TemporalAdjuster temporalAdjuster) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.with(temporalAdjuster));
    }

    public abstract ChronoLocalDateTime with(TemporalField var1, long var2);

    public ChronoLocalDateTime plus(TemporalAmount temporalAmount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.plus(temporalAmount));
    }

    public abstract ChronoLocalDateTime plus(long var1, TemporalUnit var3);

    public ChronoLocalDateTime minus(TemporalAmount temporalAmount) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.minus(temporalAmount));
    }

    public ChronoLocalDateTime minus(long l, TemporalUnit temporalUnit) {
        return this.toLocalDate().getChronology().ensureChronoLocalDateTime(super.minus(l, temporalUnit));
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return this.getChronology();
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return LocalDate.ofEpochDay(this.toLocalDate().toEpochDay());
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        return super.query(temporalQuery);
    }

    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay());
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public abstract ChronoZonedDateTime atZone(ZoneId var1);

    public Instant toInstant(ZoneOffset zoneOffset) {
        return Instant.ofEpochSecond(this.toEpochSecond(zoneOffset), this.toLocalTime().getNano());
    }

    public long toEpochSecond(ZoneOffset zoneOffset) {
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        long l = this.toLocalDate().toEpochDay();
        long l2 = l * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return l2 -= (long)zoneOffset.getTotalSeconds();
    }

    public int compareTo(ChronoLocalDateTime chronoLocalDateTime) {
        int n = this.toLocalDate().compareTo(chronoLocalDateTime.toLocalDate());
        if (n == 0 && (n = this.toLocalTime().compareTo(chronoLocalDateTime.toLocalTime())) == 0) {
            n = this.getChronology().compareTo(chronoLocalDateTime.getChronology());
        }
        return n;
    }

    public boolean isAfter(ChronoLocalDateTime chronoLocalDateTime) {
        long l;
        long l2 = this.toLocalDate().toEpochDay();
        return l2 > (l = chronoLocalDateTime.toLocalDate().toEpochDay()) || l2 == l && this.toLocalTime().toNanoOfDay() > chronoLocalDateTime.toLocalTime().toNanoOfDay();
    }

    public boolean isBefore(ChronoLocalDateTime chronoLocalDateTime) {
        long l;
        long l2 = this.toLocalDate().toEpochDay();
        return l2 < (l = chronoLocalDateTime.toLocalDate().toEpochDay()) || l2 == l && this.toLocalTime().toNanoOfDay() < chronoLocalDateTime.toLocalTime().toNanoOfDay();
    }

    public boolean isEqual(ChronoLocalDateTime chronoLocalDateTime) {
        return this.toLocalTime().toNanoOfDay() == chronoLocalDateTime.toLocalTime().toNanoOfDay() && this.toLocalDate().toEpochDay() == chronoLocalDateTime.toLocalDate().toEpochDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoLocalDateTime) {
            return this.compareTo((ChronoLocalDateTime)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toLocalDate().hashCode() ^ this.toLocalTime().hashCode();
    }

    public String toString() {
        return this.toLocalDate().toString() + 'T' + this.toLocalTime().toString();
    }
}

